/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.refcombo;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.CommandInvoker;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.ReferenceComboSetting;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/refcombo/searchParent", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"parent"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/refcombo/SearchParentCommand", displayName="\u30d7\u30ed\u30d1\u30c6\u30a3\u30a8\u30c7\u30a3\u30bf\u53d6\u5f97\u30de\u30f3\u30c9")
public final class SearchParentCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/refcombo/searchParent";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private CommandInvoker ci = (CommandInvoker)ManagerLocator.getInstance().getManager(CommandInvoker.class);

    public String execute(RequestContext request) {
        Command cmd = this.ci.getCommandInstance("gem/generic/refcombo/GetEditorCommand");
        cmd.execute(request);
        ReferencePropertyEditor editor = (ReferencePropertyEditor)request.getAttribute("editor");
        if (editor == null) {
            return "NOT_DEFINED_EDITOR";
        }
        String defName = request.getParam("defName");
        String propName = request.getParam("propName");
        String currentName = request.getParam("currentName");
        String oid = request.getParam("oid");
        EntityDefinition ed = this.edm.get(defName);
        if (ed == null) {
            return "NOT_DEFINED_ENTITY";
        }
        PropertyDefinition pd = ed.getProperty(propName);
        if (pd == null) {
            return "NOT_DEFINED_PROPERTY";
        }
        if (!(pd instanceof ReferenceProperty)) {
            return "NOT_REFERENCE_PROPERTY";
        }
        ReferenceProperty rp = (ReferenceProperty)pd;
        EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
        if (red == null) {
            return "NOT_DEFINED_REFERENCE_ENITY";
        }
        ReferenceComboSetting setting = editor.getReferenceComboSetting();
        this.searchParent(request, rp, setting, rp.getName(), currentName, oid);
        return null;
    }

    private void searchParent(RequestContext request, ReferenceProperty crp, ReferenceComboSetting setting, String childName, String currentName, String childOid) {
        EntityDefinition ed = this.edm.get(crp.getObjectDefinitionName());
        ReferenceProperty rp = (ReferenceProperty)ed.getProperty(setting.getPropertyName());
        if (rp != null) {
            String propName = childName + "." + rp.getName();
            if (currentName.equals(propName)) {
                Query q;
                Entity ret;
                if (childOid != null && (ret = (Entity)this.em.searchEntity(q = new Query().select(new Object[]{rp.getName() + "." + "oid"}).from(crp.getObjectDefinitionName()).where((Condition)new Equals("oid", (Object)childOid))).getFirst()) != null && ret.getValue(rp.getName()) != null) {
                    Entity ref = (Entity)ret.getValue(rp.getName());
                    request.setAttribute("parent", (Object)ref);
                }
            } else if (setting.getParent() != null && StringUtil.isNotBlank((String)setting.getParent().getPropertyName())) {
                this.searchParent(request, rp, setting.getParent(), propName, currentName, childOid);
            }
        }
    }
}

