/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.reflink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.HasDisplayScriptBindings;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.editor.LinkProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/link/getLinkItem", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"selName", "data"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/link/GetReferenceLinkItemCommand", displayName="\u9023\u52d5\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97")
public final class GetReferenceLinkItemCommand
implements Command,
HasDisplayScriptBindings {
    public static final String WEBAPI_NAME = "gem/generic/link/getLinkItem";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String viewType = request.getParam("viewType");
        String viewName = request.getParam("viewName");
        String propName = request.getParam("propName");
        String linkValue = request.getParam("linkValue");
        Entity entity = this.getBindingEntity(request);
        PropertyEditor editor = this.evm.getPropertyEditor(defName, viewType, viewName, propName, entity);
        ReferencePropertyEditor rpe = null;
        if (editor instanceof ReferencePropertyEditor) {
            rpe = (ReferencePropertyEditor)editor;
        }
        if (rpe != null) {
            List<SimpleEntity> data = this.getData(rpe, linkValue, request);
            request.setAttribute("data", data);
        }
        return "SUCCESS";
    }

    private List<SimpleEntity> getData(final ReferencePropertyEditor editor, String linkValue, RequestContext request) {
        boolean doSearch = false;
        LinkProperty linkProperty = editor.getLinkProperty();
        Object condition = null;
        if (linkProperty != null) {
            EntityDefinition ed;
            doSearch = false;
            if (StringUtil.isNotEmpty((String)linkValue) && (ed = this.edm.get(editor.getObjectName())) != null) {
                PropertyDefinition pd = ed.getProperty(linkProperty.getLinkToPropertyName());
                String upperPropName = linkProperty.getLinkToPropertyName();
                String upperValue = linkValue;
                Equals upperCondition = null;
                if (pd instanceof ReferenceProperty) {
                    upperPropName = upperPropName + "." + "oid";
                    int lastIndex = upperValue.lastIndexOf("_");
                    if (lastIndex < 0) {
                        upperCondition = new Equals(linkProperty.getLinkToPropertyName() + "." + "oid", (Object)upperValue);
                    } else {
                        String oid = upperValue.substring(0, lastIndex);
                        Long version = CommandUtil.getLong(upperValue.substring(lastIndex + 1));
                        upperCondition = new And(new Condition[]{new Equals(linkProperty.getLinkToPropertyName() + "." + "oid", (Object)oid), new Equals(linkProperty.getLinkToPropertyName() + "." + "version", (Object)version)});
                    }
                } else {
                    upperCondition = new Equals(linkProperty.getLinkToPropertyName(), (Object)linkValue);
                }
                if (StringUtil.isNotEmpty((String)editor.getCondition())) {
                    condition = new PreparedQuery(editor.getCondition()).condition(null);
                }
                condition = condition != null ? new And(new Condition[]{condition, upperCondition}) : upperCondition;
                doSearch = true;
            }
        }
        if (doSearch) {
            Query q = new Query();
            q.from(editor.getObjectName());
            q.select(new Object[]{"oid", "version"});
            if (editor.getDisplayLabelItem() != null) {
                q.select().add((Object)editor.getDisplayLabelItem());
            } else {
                q.select().add((Object)"name");
            }
            if (condition != null) {
                q.where(condition);
            }
            if (editor.getSortType() != null) {
                String sortItem;
                String string = sortItem = editor.getSortItem() != null ? editor.getSortItem() : "oid";
                if (!"oid".equals(sortItem) && !"name".equals(sortItem)) {
                    q.select().add((Object)sortItem);
                }
                SortSpec.SortType sortType = SortSpec.SortType.ASC;
                if ("DESC".equals(editor.getSortType().name())) {
                    sortType = SortSpec.SortType.DESC;
                }
                q.order(new SortSpec[]{new SortSpec(sortItem, sortType)});
            }
            final ArrayList<SimpleEntity> list = new ArrayList<SimpleEntity>();
            this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                @Override
                public boolean test(Entity dataModel) {
                    if (editor.getDisplayLabelItem() != null) {
                        String displayLabelItem = editor.getDisplayLabelItem();
                        list.add(new SimpleEntity(dataModel.getOid(), dataModel.getVersion(), (String)dataModel.getValue(displayLabelItem)));
                    } else {
                        list.add(new SimpleEntity(dataModel));
                    }
                    return true;
                }
            });
            return list;
        }
        return Collections.emptyList();
    }

    class SimpleEntity {
        private String oid;
        private String name;
        private Long version;

        public SimpleEntity(Entity entity) {
            this.oid = entity.getOid();
            this.name = entity.getName();
            this.setVersion(entity.getVersion());
        }

        public SimpleEntity(String oid, Long version, String name) {
            this.oid = oid;
            this.version = version;
            this.name = name;
        }

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Long getVersion() {
            return this.version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }
    }
}

