/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.reftree;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.common.JqTreeData;
import org.iplass.gem.command.common.JsonStreamingOutput;
import org.iplass.gem.command.generic.HasDisplayScriptBindings;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferenceRecursiveTreeSetting;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/reftree/searchReferenceTreeData", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"data"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/reftree/SearchTreeDataCommand")
public class SearchTreeDataCommand
implements Command,
HasDisplayScriptBindings {
    public static final String WEBAPI_NAME = "gem/generic/reftree/searchReferenceTreeData";
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String viewType = request.getParam("viewType");
        String viewName = request.getParam("viewName");
        String propName = request.getParam("propName");
        String oid = request.getParam("oid");
        String linkValue = request.getParam("linkValue");
        Entity entity = this.getBindingEntity(request);
        PropertyEditor editor = this.evm.getPropertyEditor(defName, viewType, viewName, propName, entity);
        ArrayList<RefTreeJqTreeData> ret = new ArrayList<RefTreeJqTreeData>();
        ret.addAll(this.search((ReferencePropertyEditor)editor, oid, linkValue));
        request.setAttribute("data", (Object)new JsonStreamingOutput(ret));
        return "SUCCESS";
    }

    private List<RefTreeJqTreeData> search(ReferencePropertyEditor editor, String oid, String linkValue) {
        ReferenceRecursiveTreeSetting treeSetting = editor.getReferenceRecursiveTreeSetting();
        Query query = new Query().select(new Object[]{"oid", "version", new Count(treeSetting.getChildPropertyName() + ".oid")}).from(editor.getObjectName()).groupBy(new Object[]{"oid", "version"});
        if (editor.getDisplayLabelItem() != null) {
            query.select().add((Object)editor.getDisplayLabelItem());
            query.getGroupBy().add((Object)editor.getDisplayLabelItem());
        } else {
            query.select().add((Object)"name");
            query.getGroupBy().add((Object)"name");
        }
        if (oid == null && treeSetting.getRootCondition() != null) {
            And and = new And();
            and.addExpression(new PreparedQuery(treeSetting.getRootCondition()).condition(null));
            if (editor.getLinkProperty() != null && StringUtil.isNotBlank((String)linkValue)) {
                and.addExpression((Condition)new Equals(editor.getLinkProperty().getLinkToPropertyName(), (Object)linkValue));
            }
            query.where((Condition)and);
        } else if (oid != null) {
            query.where((Condition)new In("oid", new SubQuery(new Query().selectDistinct(new Object[]{treeSetting.getChildPropertyName() + ".oid"}).from(editor.getObjectName()).where((Condition)new Equals("oid", (Object)oid)))));
        }
        if (editor.getSortItem() != null) {
            String sortItem = editor.getSortItem();
            SortSpec.SortType sortType = null;
            sortType = editor.getSortType() == null ? SortSpec.SortType.ASC : SortSpec.SortType.valueOf((String)editor.getSortType().name());
            query.getGroupBy().add((Object)sortItem);
            query.order(new SortSpec[]{new SortSpec(sortItem, sortType)});
        }
        List list = this.em.search(query).getList();
        ArrayList<RefTreeJqTreeData> ret = new ArrayList<RefTreeJqTreeData>();
        for (Object[] data : list) {
            ret.add(new RefTreeJqTreeData(data));
        }
        return ret;
    }

    class RefTreeJqTreeData
    extends JqTreeData {
        private String oid;
        private Long version;

        public RefTreeJqTreeData(Object[] data) {
            this.setId((String)data[0]);
            this.setOid((String)data[0]);
            this.setVersion((Long)data[1]);
            this.setLoad_on_demand((Long)data[2] > 0L);
            this.setName((String)data[3]);
        }

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public Long getVersion() {
            return this.version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }
    }
}

