/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.refunique;

import java.util.function.Predicate;
import org.iplass.gem.command.generic.HasDisplayScriptBindings;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/refunique/getUniqueItem", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"data"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/refunique/ReferenceUniqueCommand", displayName="\u53c2\u7167\u30e6\u30cb\u30fc\u30af\u30ad\u30fc\u30b3\u30de\u30f3\u30c9")
public class GetReferenceUniqueItemCommand
implements Command,
HasDisplayScriptBindings {
    public static final String WEBAPI_NAME = "gem/generic/refunique/getUniqueItem";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String viewName = request.getParam("viewName");
        String propName = request.getParam("propName");
        String viewType = request.getParam("viewType");
        String uniqueValue = request.getParam("uniqueValue");
        Entity entity = this.getBindingEntity(request);
        PropertyEditor editor = this.evm.getPropertyEditor(defName, viewType, viewName, propName, entity);
        ReferencePropertyEditor rpe = null;
        if (editor instanceof ReferencePropertyEditor) {
            rpe = (ReferencePropertyEditor)editor;
        }
        if (rpe == null) {
            return "NOT_DEFINED_EDITOR";
        }
        if (!this.isUniqueProp(rpe)) {
            return "NOT_UNIQUE_PROP";
        }
        SimpleEntity data = this.getData(rpe, uniqueValue, request);
        request.setAttribute("data", (Object)data);
        return "SUCCESS";
    }

    private boolean isUniqueProp(ReferencePropertyEditor editor) {
        if ("oid".equals(editor.getUniqueItem())) {
            return true;
        }
        EntityDefinition ed = this.edm.get(editor.getObjectName());
        PropertyDefinition pd = ed.getProperty(editor.getUniqueItem());
        return pd.getIndexType() == IndexType.UNIQUE || pd.getIndexType() == IndexType.UNIQUE_WITHOUT_NULL;
    }

    private SimpleEntity getData(final ReferencePropertyEditor editor, String uniqueValue, RequestContext request) {
        Query q = new Query();
        q.select(new Object[]{"oid", "version", editor.getUniqueItem()});
        if (editor.getDisplayLabelItem() != null) {
            q.select().add((Object)editor.getDisplayLabelItem());
        } else {
            q.select().add((Object)"name");
        }
        q.from(editor.getObjectName());
        if (uniqueValue == null) {
            q.where((Condition)new IsNull(editor.getUniqueItem()));
        } else {
            q.where((Condition)new Equals(editor.getUniqueItem(), (Object)uniqueValue));
        }
        final SimpleEntity data = new SimpleEntity();
        this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                data.setOid(dataModel.getOid());
                data.setVersion(dataModel.getVersion());
                if (editor.getDisplayLabelItem() != null) {
                    String displayLabelItem = editor.getDisplayLabelItem();
                    data.setName((String)dataModel.getValue(displayLabelItem));
                } else {
                    data.setName(dataModel.getName());
                }
                String uniqueItem = editor.getUniqueItem();
                if (uniqueItem != null) {
                    String uniqueValue = ConvertUtil.convertToString((Object)dataModel.getValue(uniqueItem));
                    data.setUniqueValue(uniqueValue);
                }
                return false;
            }
        });
        return data;
    }

    class SimpleEntity {
        private String oid;
        private String name;
        private Long version;
        private String uniqueValue;

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Long getVersion() {
            return this.version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }

        public String getUniqueValue() {
            return this.uniqueValue;
        }

        public void setUniqueValue(String uniqueValue) {
            this.uniqueValue = uniqueValue;
        }
    }
}

