/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.generic.search.CsvDownloadSearchContext;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.gem.command.generic.search.SearchQueryInterrupterHandler;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.csv.MultipleFormat;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.SearchQueryInterrupter;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.CsvItem;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.web.ResultStreamWriter;
import org.iplass.mtp.web.template.TemplateUtil;

public class CSVDownloadSearchViewWriter
implements ResultStreamWriter {
    private static final String CR = "\n";
    private static final String DOUBLE_QUOT = "\"";
    private static final int BOM = 65279;
    private CsvDownloadSearchContext context;
    private Writer writer;
    private GemConfigService gcs = null;

    public CSVDownloadSearchViewWriter(CsvDownloadSearchContext context) {
        this.context = context;
        this.gcs = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
    }

    public void write(OutputStream out) throws IOException {
        String charSet = this.context.getCharacterCode();
        this.writer = new BufferedWriter(new OutputStreamWriter(out, charSet));
        if ("UTF-8".equalsIgnoreCase(charSet)) {
            try {
                this.writer.write(65279);
            }
            catch (IOException e) {
                throw new EntityCsvException((Throwable)e);
            }
        }
        List<CsvDownloadSearchContext.CsvColumn> columns = this.context.getCsvColumns();
        this.writeHeader(columns);
        this.writeData(columns);
        this.writeFooter();
        this.writer.flush();
    }

    private void writeHeader(List<CsvDownloadSearchContext.CsvColumn> columns) {
        for (CsvDownloadSearchContext.CsvColumn column : columns) {
            int multi = column.getMultiplicity();
            if (multi <= 1) {
                this.writeText(column.getColumnLabel());
                if (columns.indexOf(column) >= columns.size() - 1) continue;
                this.writeComma();
                continue;
            }
            if (this.context.getMultipleFormat() == MultipleFormat.EACH_COLUMN) {
                for (int i = 0; i < multi; ++i) {
                    if (i != 0) {
                        this.writeComma();
                    }
                    this.writeText(column.getColumnLabel() + "[" + i + "]");
                }
            } else {
                this.writeText(column.getColumnLabel());
            }
            if (columns.indexOf(column) >= columns.size() - 1) continue;
            this.writeComma();
        }
        this.writeCR();
    }

    private void writeData(List<CsvDownloadSearchContext.CsvColumn> columns) {
        Query query = new Query();
        query.setSelect(this.context.getSelect());
        query.from(this.context.getDefName());
        query.setWhere(this.context.getWhere());
        query.setVersiond(this.context.isVersioned());
        query.setOrderBy(this.context.getOrderBy());
        int maxCount = this.gcs.getCsvDownloadMaxCount();
        SearchConditionSection section = this.context.getConditionSection();
        if (section.getCsvdownloadMaxCount() != null) {
            maxCount = section.getCsvdownloadMaxCount();
        }
        if (maxCount > 0) {
            query.setLimit(new Limit(maxCount));
        }
        int cacheLimit = this.gcs.getSearchResultCacheLimit();
        SearchQueryInterrupterHandler handler = this.context.getSearchQueryInterrupterHandler();
        MultipleFormat multipleFormat = this.context.getMultipleFormat();
        boolean isOutputCodeValue = this.context.isOutputCodeValue();
        boolean isShowUserNameWithPrivilegedValue = ((SearchContextBase)this.context).getForm().isShowUserNameWithPrivilegedValue();
        new CsvDownloadSearchImpl(handler, columns, cacheLimit, isShowUserNameWithPrivilegedValue).execute(query, new EntityViewTypeFormatter(this, columns, multipleFormat, isOutputCodeValue));
    }

    private void writeFooter() {
        GemConfigService service = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        if (service.isCsvDownloadWithFooter()) {
            try {
                this.writer.write(service.getCsvDownloadFooter());
            }
            catch (IOException e) {
                throw new EntityCsvException((Throwable)e);
            }
            this.writeCR();
        }
    }

    private void writeText(String text) {
        try {
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            String outText = StringEscapeUtils.escapeCsv((String)text);
            if (this.gcs.isCsvDownloadQuoteAll()) {
                if (outText.startsWith(DOUBLE_QUOT) && outText.endsWith(DOUBLE_QUOT)) {
                    this.writer.write(outText);
                } else {
                    this.writer.write(DOUBLE_QUOT + outText + DOUBLE_QUOT);
                }
            } else if (outText.startsWith(" ") || outText.endsWith(" ")) {
                this.writer.write(DOUBLE_QUOT + outText + DOUBLE_QUOT);
            } else {
                this.writer.write(outText);
            }
        }
        catch (IOException e) {
            throw new EntityCsvException((Throwable)e);
        }
    }

    private void writeComma() {
        try {
            this.writer.write(",");
        }
        catch (IOException e) {
            throw new EntityCsvException((Throwable)e);
        }
    }

    private void writeCR() {
        try {
            this.writer.write(CR);
        }
        catch (IOException e) {
            throw new EntityCsvException((Throwable)e);
        }
    }

    private static class EntityViewTypeFormatter
    implements Predicate<Entity> {
        private CSVDownloadSearchViewWriter writer;
        private List<CsvDownloadSearchContext.CsvColumn> columns;
        private MultipleFormat multipleFormat;
        private boolean isOutputCodeValue;

        public EntityViewTypeFormatter(CSVDownloadSearchViewWriter writer, List<CsvDownloadSearchContext.CsvColumn> columns, MultipleFormat multipleFormat, boolean isOutputCodeValue) {
            this.writer = writer;
            this.columns = columns;
            this.multipleFormat = multipleFormat;
            this.isOutputCodeValue = isOutputCodeValue;
        }

        @Override
        public boolean test(Entity entity) {
            Iterator<CsvDownloadSearchContext.CsvColumn> itc = this.columns.iterator();
            while (itc.hasNext()) {
                CsvDownloadSearchContext.CsvColumn csvColumn = itc.next();
                String propName = csvColumn.getPropertyName();
                int multiple = csvColumn.getMultiplicity();
                Object value = entity.getValue(propName);
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    this.formatMultipleValue(csvColumn, multiple, values);
                } else if (value != null && value.toString().length() != 0) {
                    this.writer.writeText(this.valueToString(value));
                } else if (value == null && multiple > 1 && this.multipleFormat == MultipleFormat.EACH_COLUMN) {
                    for (int i = 0; i < multiple - 1; ++i) {
                        this.writer.writeComma();
                    }
                }
                if (!itc.hasNext()) continue;
                this.writer.writeComma();
            }
            this.writer.writeCR();
            return true;
        }

        private void formatMultipleValue(CsvDownloadSearchContext.CsvColumn csvColumn, int multiple, Object[] values) {
            PropertyDefinition pd = csvColumn.getPropertyDefinition();
            CsvItem csvItem = csvColumn.getCsvItem();
            if (pd != null && pd instanceof SelectProperty && csvItem != null && csvItem.getEditor() instanceof SelectPropertyEditor) {
                this.formatMultipleSelectValue((SelectProperty)pd, (SelectPropertyEditor)csvItem.getEditor(), multiple, values);
            } else if (this.multipleFormat == MultipleFormat.EACH_COLUMN) {
                this.formatSplitMultipleValue(multiple, values);
            } else {
                this.formatUnSplitMultipleValue(multiple, values);
            }
        }

        private void formatSplitMultipleValue(int multiple, Object[] values) {
            for (int i = 0; i < multiple; ++i) {
                if (values.length - 1 >= i && values[i] != null) {
                    this.writer.writeText(this.valueToString(values[i]));
                }
                if (i >= multiple - 1) continue;
                this.writer.writeComma();
            }
        }

        private void formatUnSplitMultipleValue(int multiple, Object[] values) {
            int arrayLen = values.length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < multiple && (i < arrayLen || this.multipleFormat != MultipleFormat.ONE_COLUMN); ++i) {
                String strValue;
                if (i != 0) {
                    sb.append(",");
                }
                if (i >= arrayLen || !StringUtil.isNotEmpty((String)(strValue = this.valueToString(values[i])))) continue;
                String outText = StringEscapeUtils.escapeCsv((String)strValue);
                if (strValue.contains(CSVDownloadSearchViewWriter.DOUBLE_QUOT)) {
                    outText = outText.replaceAll(Pattern.quote("\"\""), CSVDownloadSearchViewWriter.DOUBLE_QUOT);
                }
                sb.append(outText);
            }
            this.writer.writeText(sb.toString());
        }

        private void formatMultipleSelectValue(SelectProperty sp, SelectPropertyEditor spe, int multiple, Object[] values) {
            Object[] outputValues = values;
            if (spe.isSortCsvOutputValue()) {
                List selectableValues = sp.getSelectValueList();
                ArrayList<SelectValue> sortedValues = new ArrayList<SelectValue>(selectableValues.size());
                for (int i = 0; i < multiple; ++i) {
                    if (selectableValues.size() < i + 1) {
                        if (i >= multiple - 1) continue;
                        sortedValues.add(null);
                        continue;
                    }
                    SelectValue targetValue = (SelectValue)selectableValues.get(i);
                    boolean exist = false;
                    for (Object storeValue : values) {
                        if (storeValue == null || !((SelectValue)storeValue).getValue().equals(targetValue.getValue())) continue;
                        exist = true;
                        break;
                    }
                    if (exist) {
                        sortedValues.add(targetValue);
                        continue;
                    }
                    sortedValues.add(null);
                }
                outputValues = sortedValues.toArray();
            }
            if (this.multipleFormat == MultipleFormat.EACH_COLUMN) {
                this.formatSplitMultipleValue(multiple, outputValues);
            } else {
                this.formatUnSplitMultipleValue(multiple, outputValues);
            }
        }

        private String valueToString(Object obj) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof Entity) {
                Entity ge = (Entity)obj;
                return ge.getOid();
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).toPlainString();
            }
            if (obj instanceof Float) {
                return BigDecimal.valueOf(((Float)obj).floatValue()).toPlainString();
            }
            if (obj instanceof Double) {
                return BigDecimal.valueOf((Double)obj).toPlainString();
            }
            if (obj instanceof SelectValue) {
                if (this.isOutputCodeValue) {
                    return ((SelectValue)obj).getValue();
                }
                return ((SelectValue)obj).getDisplayName();
            }
            if (obj instanceof BinaryReference) {
                return ((BinaryReference)obj).getName();
            }
            if (obj instanceof Timestamp) {
                return DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getOutputDatetimeSecFormat(), (boolean)true).format(obj);
            }
            if (obj instanceof Date) {
                return DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getOutputDateFormat(), (boolean)false).format(obj);
            }
            if (obj instanceof Time) {
                return DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getOutputTimeSecFormat(), (boolean)false).format(obj);
            }
            return obj.toString();
        }
    }

    private static class CsvDownloadSearchImpl {
        private SearchQueryInterrupterHandler handler;
        private List<CsvDownloadSearchContext.CsvColumn> columns;
        private int cacheLimit;
        private EntityManager em;
        private boolean isShowUserNameWithPrivilegedValue;
        private Set<String> userProperties;

        public CsvDownloadSearchImpl(SearchQueryInterrupterHandler handler, List<CsvDownloadSearchContext.CsvColumn> columns, int cacheLimit, boolean isShowUserNameWithPrivilegedValue) {
            this.handler = handler;
            this.columns = columns;
            this.cacheLimit = cacheLimit;
            this.em = (EntityManager)ManagerLocator.manager(EntityManager.class);
            this.isShowUserNameWithPrivilegedValue = isShowUserNameWithPrivilegedValue;
        }

        public void execute(Query query, EntityViewTypeFormatter formatter) {
            this.checkUserPropertyEditor();
            SearchQueryContext sqc = this.handler.beforeSearch(query, SearchQueryInterrupter.SearchQueryType.CSV);
            if (sqc.isDoPrivileged()) {
                AuthContext.doPrivileged(() -> this.searchEntity(sqc, formatter));
            } else if (sqc.getWithoutConditionReferenceName() != null) {
                EntityPermission.doQueryAs((String[])sqc.getWithoutConditionReferenceName(), () -> {
                    this.searchEntity(sqc, formatter);
                    return null;
                });
            } else {
                this.searchEntity(sqc, formatter);
            }
        }

        private void checkUserPropertyEditor() {
            this.userProperties = this.columns.stream().filter(column -> column.getEditor() instanceof UserPropertyEditor).map(column -> column.getPropertyName()).collect(Collectors.toSet());
        }

        private void searchEntity(final SearchQueryContext sqc, final EntityViewTypeFormatter formatter) {
            final ArrayList<Entity> tmpResult = new ArrayList<Entity>();
            final HashSet<String> userOides = new HashSet<String>();
            this.em.searchEntity(sqc.getQuery(), (Predicate)new Predicate<Entity>(){

                @Override
                public boolean test(Entity entity) {
                    handler.afterSearch(sqc.getQuery(), entity, SearchQueryInterrupter.SearchQueryType.CSV);
                    tmpResult.add(entity);
                    for (String userProp : userProperties) {
                        if (!StringUtil.isNotEmpty((String)((String)entity.getValue(userProp)))) continue;
                        userOides.add(entity.getValue(userProp));
                    }
                    if (tmpResult.size() == cacheLimit) {
                        this.setUserProperty(tmpResult, userOides);
                        for (Entity afterModel : tmpResult) {
                            if (formatter.test(afterModel)) continue;
                            tmpResult.clear();
                            userOides.clear();
                            return false;
                        }
                        tmpResult.clear();
                        userOides.clear();
                    }
                    return true;
                }
            });
            this.setUserProperty(tmpResult, userOides);
            for (Entity afterModel : tmpResult) {
                if (formatter.test(afterModel)) continue;
                return;
            }
        }

        private void setUserProperty(List<Entity> tmpResult, Set<String> userOides) {
            if (this.userProperties.isEmpty() || userOides.isEmpty()) {
                return;
            }
            final HashMap userMap = new HashMap();
            Query q = new Query().select(new Object[]{"oid", "name"}).from("mtp.auth.User").where((Condition)new In("oid", userOides.toArray()));
            if (this.isShowUserNameWithPrivilegedValue) {
                AuthContext.doPrivileged(() -> this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity entity) {
                        userMap.put(entity.getOid(), entity.getName());
                        return true;
                    }
                }));
            } else {
                this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

                    @Override
                    public boolean test(Entity entity) {
                        userMap.put(entity.getOid(), entity.getName());
                        return true;
                    }
                });
            }
            for (Entity entity : tmpResult) {
                for (String userProp : this.userProperties) {
                    String userOid = (String)entity.getValue(userProp);
                    if (!StringUtil.isNotEmpty((String)userOid) || !userMap.containsKey(userOid)) continue;
                    entity.setValue(userProp, userMap.get(userOid));
                }
            }
        }
    }
}

