/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.CSVDownloadSearchViewWriter;
import org.iplass.gem.command.generic.search.CsvDownloadSearchContext;
import org.iplass.gem.command.generic.search.CsvDownloadUploadableWriter;
import org.iplass.gem.command.generic.search.DetailSearchCommand;
import org.iplass.gem.command.generic.search.FixedSearchCommand;
import org.iplass.gem.command.generic.search.NormalSearchCommand;
import org.iplass.gem.command.generic.search.SearchCommandBase;
import org.iplass.gem.command.generic.search.SearchContext;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.web.actionmapping.ActionUtil;
import org.iplass.mtp.web.actionmapping.ResponseHeader;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/generic/search/csvdownload", result={@Result(status="SUCCESS", type=Result.Type.STREAM, useContentDisposition=true), @Result(status="ERROR_PARAMETER", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/defaultLayout")})
@CommandClass(name="gem/generic/search/CsvDownloadCommand", displayName="CSV\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9")
public final class CsvDownloadCommand
implements Command {
    public static final String ACTION_NAME = "gem/generic/search/csvdownload";
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"mtp.audit.download");
    private static final String ENTITY_NAME_BINDING_NAME = "entityName";
    private static final String ENTITY_DISP_BINDING_NAME = "entityDisplayName";
    private static final String VIEW_NAME_BINDING_NAME = "viewName";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);

    public String execute(RequestContext request) {
        String searchType = request.getParam("searchType");
        SearchCommandBase command = null;
        if ("normal".equals(searchType)) {
            command = new NormalSearchCommand();
        } else if ("detail".equals(searchType)) {
            command = new DetailSearchCommand();
        } else if ("fixed".equals(searchType)) {
            command = new FixedSearchCommand();
        }
        CsvDownloadSearchContext context = this.getContext(request, command);
        if (!context.checkParameter()) {
            return "ERROR_PARAMETER";
        }
        SearchConditionSection section = context.getConditionSection();
        section.setNonOutputBinaryRef(section.isNonOutputBinaryRef());
        section.setNonOutputReference(section.isNonOutputReference());
        section.setNonOutputOid(section.isNonOutputOid());
        EntityDefinition ed = context.getEntityDefinition();
        Object writer = null;
        writer = context.isForUpload() ? new CsvDownloadUploadableWriter(context) : new CSVDownloadSearchViewWriter(context);
        HashMap<String, Object> csvVariableMap = new HashMap<String, Object>();
        csvVariableMap.put(ENTITY_NAME_BINDING_NAME, ed.getName());
        csvVariableMap.put(ENTITY_DISP_BINDING_NAME, TemplateUtil.getMultilingualString((String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList()));
        csvVariableMap.put(VIEW_NAME_BINDING_NAME, StringUtil.isEmpty((String)context.getViewName()) ? null : context.getViewName());
        String defaultName = TemplateUtil.getMultilingualString((String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList());
        String filename = this.evm.getCsvDownloadFileName(context.getDefName(), context.getViewName(), defaultName, csvVariableMap) + ".csv";
        auditLogger.info("EntityCsvDownload," + filename + "," + context.getDefName() + " " + context.getWhere() + " isForUpload:" + context.isForUpload());
        request.setAttribute("fileName", (Object)filename);
        request.setAttribute("contentType", (Object)("text/csv;charset=" + context.getCharacterCode()));
        request.setAttribute("streamData", writer);
        String token = request.getParam("fileDownloadToken");
        if (StringUtil.isNotBlank((String)token)) {
            ResponseHeader header = ActionUtil.getResponseHeader();
            Cookie cookie = new Cookie("fileDownloadToken", token);
            String path = TemplateUtil.getTenantContextPath();
            if (StringUtil.isBlank((String)path)) {
                path = "/";
            }
            cookie.setPath(path);
            header.addCookie(cookie);
        }
        return "SUCCESS";
    }

    private CsvDownloadSearchContext getContext(RequestContext request, SearchCommandBase command) {
        SearchContext context = null;
        try {
            context = command.getContextClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new EntityRuntimeException(CsvDownloadCommand.resourceString("command.generic.search.CsvDownloadCommand.internalErr", new Object[0]), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new EntityRuntimeException(CsvDownloadCommand.resourceString("command.generic.search.CsvDownloadCommand.internalErr", new Object[0]), (Throwable)e);
        }
        if (context != null) {
            context.setRequest(request);
            context.setEntityDefinition(this.edm.get(context.getDefName()));
            context.setEntityView((EntityView)this.evm.get(context.getDefName()));
        }
        return new CsvDownloadSearchContext((SearchContextBase)context);
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

