/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.gem.command.generic.search.SearchQueryInterrupterHandler;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.csv.MultipleFormat;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.SearchQueryInterrupter;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.CsvItem;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvDownloadSearchContext
extends SearchContextBase {
    private static Logger log = LoggerFactory.getLogger(CsvDownloadSearchContext.class);
    private static final String DEFAULT_CHAR_SET = "UTF-8";
    private SearchContextBase context;

    public CsvDownloadSearchContext(SearchContextBase context) {
        this.context = context;
    }

    @Override
    public RequestContext getRequest() {
        return this.context.getRequest();
    }

    @Override
    public void setRequest(RequestContext request) {
        super.setRequest(request);
        this.context.setRequest(request);
    }

    @Override
    public EntityDefinition getEntityDefinition() {
        return this.context.getEntityDefinition();
    }

    @Override
    public void setEntityDefinition(EntityDefinition definition) {
        this.context.setEntityDefinition(definition);
    }

    @Override
    public EntityView getEntityView() {
        return this.context.getEntityView();
    }

    @Override
    public void setEntityView(EntityView view) {
        this.context.setEntityView(view);
    }

    @Override
    public String getDefName() {
        return this.context.getDefName();
    }

    @Override
    protected String getViewName() {
        return this.context.getViewName();
    }

    @Override
    public Select getSelect() {
        if (this.isOutputSpecifyProperties() && !this.isOutputResult()) {
            boolean distinct = this.getConditionSection().isDistinct();
            Set<String> properties = this.getConditionSection().getCsvdownloadPropertiesSet();
            Select select = new Select();
            select.setDistinct(distinct);
            for (String property : properties) {
                PropertyDefinition pd = this.context.getPropertyDefinition(property);
                if (pd == null) continue;
                if (pd instanceof ReferenceProperty) {
                    select.add((Object)(property + "." + "name"));
                    continue;
                }
                select.add((Object)property);
            }
            return select;
        }
        return this.context.getSelect();
    }

    @Override
    public Where getWhere() {
        return this.context.getWhere();
    }

    @Override
    public OrderBy getOrderBy() {
        return this.context.getOrderBy();
    }

    @Override
    public Limit getLimit() {
        return this.context.getLimit();
    }

    @Override
    public boolean isVersioned() {
        return this.context.isVersioned();
    }

    @Override
    public boolean isSearch() {
        return this.context.isSearch();
    }

    @Override
    public boolean isCount() {
        return this.context.isCount();
    }

    @Override
    public boolean checkParameter() {
        return this.context.checkParameter();
    }

    @Override
    public boolean validation() {
        return this.context.validation();
    }

    @Override
    protected SearchFormView getForm() {
        return this.context.getForm();
    }

    public boolean isForUpload() {
        return Boolean.valueOf(this.getRequest().getParam("isForUpload"));
    }

    public boolean isNoDispName() {
        return Boolean.valueOf(this.getRequest().getParam("isNoDispName"));
    }

    public boolean isOutputResult() {
        return Boolean.valueOf(this.getRequest().getParam("isOutputResult"));
    }

    public boolean isOutputCodeValue() {
        return Boolean.valueOf(this.getRequest().getParam("isOutputCodeValue"));
    }

    @Override
    public SearchConditionSection getConditionSection() {
        return this.context.getConditionSection();
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String propName) {
        return this.context.getPropertyDefinition(propName);
    }

    @Override
    protected SearchResultSection getResultSection() {
        return this.context.getResultSection();
    }

    public String getCharacterCode() {
        if (StringUtil.isEmpty((String)this.getRequest().getParam("characterCode"))) {
            return DEFAULT_CHAR_SET;
        }
        return this.getRequest().getParam("characterCode");
    }

    public MultipleFormat getMultipleFormat() {
        if (this.getConditionSection().getCsvMultipleFormat() != null) {
            return this.getConditionSection().getCsvMultipleFormat();
        }
        return MultipleFormat.EACH_COLUMN;
    }

    public List<CsvColumn> getCsvColumns() {
        if (this.isOutputSpecifyProperties() && !this.isOutputResult()) {
            ArrayList<CsvColumn> columns = new ArrayList<CsvColumn>();
            Set<String> propertyNames = this.getConditionSection().getCsvdownloadPropertiesSet();
            for (String propertyName : propertyNames) {
                CsvColumn column = this.getCsvColumn(propertyName);
                if (column == null) continue;
                columns.add(column);
            }
            return columns;
        }
        LinkedHashMap<String, CsvColumn> columnMap = new LinkedHashMap<String, CsvColumn>();
        SearchConditionSection section = this.getConditionSection();
        if (!section.isNonOutputOid()) {
            PropertyDefinition pd = this.getPropertyDefinition("oid");
            CsvColumn csvColumn = new CsvColumn("oid");
            csvColumn.setPropertyDefinition(pd);
            csvColumn.setCsvItem(null);
            csvColumn.setColumnLabel(this.getEntityIdColLabel());
            columnMap.put(csvColumn.getPropertyName(), csvColumn);
        }
        List csvItems = this.getResultSection().getElements().stream().filter(element -> EntityViewUtil.isDisplayElement(this.getDefName(), element.getElementRuntimeId(), OutputType.SEARCHRESULT, null)).filter(element -> element instanceof CsvItem && ((CsvItem)((Object)element)).isOutputCsv()).map(e -> (CsvItem)((Object)e)).collect(Collectors.toList());
        for (CsvItem csvItem : csvItems) {
            String propertyName = csvItem.getPropertyName();
            if (csvItem.getEditor() instanceof ReferencePropertyEditor) {
                List<NestProperty> nest = ((ReferencePropertyEditor)csvItem.getEditor()).getNestProperties();
                this.addColumn(columnMap, propertyName, csvItem, nest.toArray(new NestProperty[nest.size()]));
                continue;
            }
            if (csvItem.getEditor() instanceof JoinPropertyEditor) {
                this.addColumn(columnMap, propertyName, csvItem, new NestProperty[0]);
                JoinPropertyEditor je = (JoinPropertyEditor)csvItem.getEditor();
                for (NestProperty nest : je.getProperties()) {
                    if (!nest.isOutputCsv()) continue;
                    this.addColumn(columnMap, nest.getPropertyName(), nest, new NestProperty[0]);
                }
                continue;
            }
            this.addColumn(columnMap, propertyName, csvItem, new NestProperty[0]);
        }
        return new ArrayList<CsvColumn>(columnMap.values());
    }

    public CsvColumn getCsvColumn(String propertyName) {
        CsvColumn column = null;
        PropertyDefinition pd = this.getPropertyDefinition(propertyName);
        if (pd != null) {
            if (pd instanceof ReferenceProperty) {
                column = new CsvColumn(propertyName + "." + "name");
                column.setReferenceProperty(pd);
                EntityDefinition red = this.getReferenceEntityDefinition((ReferenceProperty)pd);
                column.setPropertyDefinition(red.getProperty("name"));
            } else {
                column = new CsvColumn(propertyName);
                column.setPropertyDefinition(pd);
            }
            CsvItem csvItem = this.getCsvItem(propertyName);
            column.setCsvItem(csvItem);
        } else {
            CsvItem csvItem = this.getCsvItem(propertyName);
            if (csvItem != null) {
                column = new CsvColumn(propertyName);
                column.setCsvItem(csvItem);
            }
        }
        if (column != null) {
            column.setColumnLabel(this.getColumnLabel(column));
        }
        return column;
    }

    private boolean isOutputSpecifyProperties() {
        return StringUtil.isNotBlank((String)this.getConditionSection().getCsvdownloadProperties());
    }

    private void addColumn(LinkedHashMap<String, CsvColumn> columnMap, String propertyName, CsvItem csvItem, NestProperty ... nestProperties) {
        PropertyDefinition pd = this.getPropertyDefinition(propertyName);
        if (pd instanceof ReferenceProperty) {
            if (nestProperties != null && nestProperties.length > 0) {
                EntityDefinition red = this.getReferenceEntityDefinition((ReferenceProperty)pd);
                for (NestProperty nestProperty : nestProperties) {
                    PropertyDefinition rpd;
                    if (!nestProperty.isOutputCsv() || (rpd = red.getProperty(nestProperty.getPropertyName())) == null) continue;
                    if ("oid".equals(nestProperty.getPropertyName())) {
                        if (this.getConditionSection().isNonOutputOid()) continue;
                        CsvColumn csvColumn = new CsvColumn(propertyName + "." + nestProperty.getPropertyName());
                        csvColumn.setPropertyDefinition(rpd);
                        csvColumn.setCsvItem(nestProperty);
                        csvColumn.setColumnLabel(this.getColumnLabel(csvColumn));
                        columnMap.putIfAbsent(csvColumn.getPropertyName(), csvColumn);
                        continue;
                    }
                    String nestPropName = propertyName + "." + nestProperty.getPropertyName();
                    if (!(rpd instanceof ReferenceProperty)) {
                        CsvColumn csvColumn = new CsvColumn(nestPropName);
                        csvColumn.setPropertyDefinition(rpd);
                        csvColumn.setCsvItem(nestProperty);
                        csvColumn.setColumnLabel(this.getColumnLabel(csvColumn));
                        columnMap.putIfAbsent(csvColumn.getPropertyName(), csvColumn);
                    }
                    if (!(nestProperty.getEditor() instanceof ReferencePropertyEditor)) continue;
                    ReferencePropertyEditor rpe = (ReferencePropertyEditor)nestProperty.getEditor();
                    List<NestProperty> _nest = rpe.getNestProperties();
                    this.addColumn(columnMap, nestPropName, nestProperty, _nest.toArray(new NestProperty[_nest.size()]));
                }
            } else if (!this.getConditionSection().isNonOutputReference()) {
                EntityDefinition red = this.getReferenceEntityDefinition((ReferenceProperty)pd);
                if (!this.getConditionSection().isNonOutputOid()) {
                    CsvColumn oidColumn = new CsvColumn(propertyName + "." + "oid");
                    oidColumn.setReferenceProperty(pd);
                    oidColumn.setPropertyDefinition(red.getProperty("oid"));
                    oidColumn.setCsvItem(csvItem);
                    oidColumn.setColumnLabel(this.getColumnLabel(oidColumn));
                    columnMap.putIfAbsent(oidColumn.getPropertyName(), oidColumn);
                }
                CsvColumn csvColumn = new CsvColumn(propertyName + "." + "name");
                csvColumn.setReferenceProperty(pd);
                csvColumn.setPropertyDefinition(red.getProperty("name"));
                csvColumn.setCsvItem(csvItem);
                csvColumn.setColumnLabel(this.getColumnLabel(csvColumn));
                columnMap.putIfAbsent(csvColumn.getPropertyName(), csvColumn);
            }
        } else if (pd instanceof BinaryProperty) {
            if (!this.getConditionSection().isNonOutputBinaryRef()) {
                CsvColumn csvColumn = new CsvColumn(propertyName);
                csvColumn.setPropertyDefinition(pd);
                csvColumn.setCsvItem(csvItem);
                csvColumn.setColumnLabel(this.getColumnLabel(csvColumn));
                columnMap.putIfAbsent(csvColumn.getPropertyName(), csvColumn);
            }
        } else {
            CsvColumn csvColumn = new CsvColumn(propertyName);
            csvColumn.setPropertyDefinition(pd);
            csvColumn.setCsvItem(csvItem);
            csvColumn.setColumnLabel(this.getColumnLabel(csvColumn));
            columnMap.putIfAbsent(csvColumn.getPropertyName(), csvColumn);
        }
    }

    private CsvItem getCsvItem(String propertyName) {
        int firstDotIndex = propertyName.indexOf(46);
        if (firstDotIndex > -1) {
            ReferencePropertyEditor editor;
            CsvItem nestProperty;
            String topPropName = propertyName.substring(0, firstDotIndex);
            String subPropName = propertyName.substring(firstDotIndex + 1);
            CsvItem property = this.getTopCsvItem(topPropName);
            if (property != null && property.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)property.getEditor()).getNestProperties().isEmpty() && (nestProperty = this.getNestCsvItem((editor = (ReferencePropertyEditor)property.getEditor()).getNestProperties(), subPropName)) != null) {
                return nestProperty;
            }
        }
        CsvItem property = this.getTopCsvItem(propertyName);
        return property;
    }

    private CsvItem getTopCsvItem(String propertyName) {
        Optional<CsvItem> csvItem = this.getResultSection().getElements().stream().filter(element -> element instanceof CsvItem).map(element -> (CsvItem)((Object)element)).filter(element -> propertyName.equals(element.getPropertyName())).findFirst();
        if (csvItem.isPresent()) {
            return csvItem.get();
        }
        return null;
    }

    private CsvItem getNestCsvItem(List<NestProperty> properties, String propertyName) {
        int firstDotIndex = propertyName.indexOf(46);
        if (firstDotIndex > -1) {
            String topPropName = propertyName.substring(0, firstDotIndex);
            String subPropName = propertyName.substring(firstDotIndex + 1);
            NestProperty property = this.getNestProperty(properties, topPropName);
            if (property != null && property.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)property.getEditor()).getNestProperties().isEmpty()) {
                ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
                return this.getNestCsvItem(editor.getNestProperties(), subPropName);
            }
        } else {
            NestProperty property = this.getNestProperty(properties, propertyName);
            if (property != null) {
                return property;
            }
        }
        return null;
    }

    private NestProperty getNestProperty(List<NestProperty> properties, String propName) {
        Optional<NestProperty> nest = properties.stream().filter(property -> propName.equals(property.getPropertyName())).findFirst();
        if (nest.isPresent()) {
            return nest.get();
        }
        return null;
    }

    public String getColumnLabel(String propertyName) {
        CsvColumn csvColumn = this.getCsvColumn(propertyName);
        return this.getColumnLabel(csvColumn);
    }

    private String getColumnLabel(CsvColumn csvColumn) {
        PropertyDefinition pd;
        String displayLabel;
        CsvItem csvItem;
        if (csvColumn.getCsvItem() != null && !StringUtil.isEmpty((String)(csvItem = csvColumn.getCsvItem()).getDisplayLabel()) && (displayLabel = TemplateUtil.getMultilingualString((String)csvItem.getDisplayLabel(), csvItem.getLocalizedDisplayLabelList())) != null) {
            return displayLabel;
        }
        if (csvColumn.getReferenceProperty() != null) {
            pd = csvColumn.getReferenceProperty();
            String referenceName = TemplateUtil.getMultilingualString((String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
            if (csvColumn.getPropertyDefinition() != null && csvColumn.getPropertyDefinition().getName().equals("oid")) {
                return referenceName + "(ID)";
            }
            if (csvColumn.getPropertyDefinition() != null && csvColumn.getPropertyDefinition().getName().equals("name")) {
                return referenceName;
            }
        }
        if (csvColumn.getPropertyDefinition() != null) {
            pd = csvColumn.getPropertyDefinition();
            return TemplateUtil.getMultilingualString((String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
        }
        throw new EntityCsvException("not found csv column name. name=" + csvColumn.getPropertyName());
    }

    private String getEntityIdColLabel() {
        String displayName = TemplateUtil.getMultilingualString((String)this.getEntityDefinition().getDisplayName(), (List)this.getEntityDefinition().getLocalizedDisplayNameList());
        String viewTitle = TemplateUtil.getMultilingualString((String)this.getForm().getTitle(), this.getForm().getLocalizedTitleList());
        if (StringUtil.isNotBlank((String)viewTitle)) {
            displayName = viewTitle;
        }
        return displayName + "(ID)";
    }

    @Override
    public SearchQueryInterrupterHandler getSearchQueryInterrupterHandler() {
        if (this.isForUpload()) {
            SearchQueryInterrupterHandlerForUpload handler = null;
            if (this.getForm().isUseInterrupterForCsvDownload()) {
                handler = new SearchQueryInterrupterHandlerForUpload(this.getRequest(), this.context, this.createInterrupter(this.getForm().getInterrupterName()));
            } else {
                log.debug("not use search query interrupter, set default.");
                handler = new SearchQueryInterrupterHandlerForUpload(this.getRequest(), this.context, this.getDefaultSearchQueryInterrupter());
            }
            return handler;
        }
        if (this.getForm().isUseInterrupterForCsvDownload()) {
            return this.context.getSearchQueryInterrupterHandler();
        }
        log.debug("not use search query interrupter, set default.");
        return new SearchQueryInterrupterHandler(this.getRequest(), this.context, this.getDefaultSearchQueryInterrupter());
    }

    public static class CsvColumn {
        private String propertyName;
        private String columnLabel;
        private PropertyDefinition propertyDefinition;
        private CsvItem csvItem;
        private PropertyDefinition referenceProperty;

        public CsvColumn(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getColumnLabel() {
            return this.columnLabel;
        }

        public void setColumnLabel(String columnLabel) {
            this.columnLabel = columnLabel;
        }

        public PropertyDefinition getPropertyDefinition() {
            return this.propertyDefinition;
        }

        public void setPropertyDefinition(PropertyDefinition propertyDefinition) {
            this.propertyDefinition = propertyDefinition;
        }

        public CsvItem getCsvItem() {
            return this.csvItem;
        }

        public void setCsvItem(CsvItem csvItem) {
            this.csvItem = csvItem;
        }

        public PropertyDefinition getReferenceProperty() {
            return this.referenceProperty;
        }

        public void setReferenceProperty(PropertyDefinition referenceProperty) {
            this.referenceProperty = referenceProperty;
        }

        public PropertyEditor getEditor() {
            if (this.csvItem != null) {
                PropertyEditor editor = this.csvItem.getEditor();
                if (editor instanceof JoinPropertyEditor) {
                    return ((JoinPropertyEditor)editor).getEditor();
                }
                if (editor instanceof DateRangePropertyEditor) {
                    return ((DateRangePropertyEditor)editor).getEditor();
                }
                return editor;
            }
            return null;
        }

        public int getMultiplicity() {
            if (this.propertyDefinition != null && !(this.propertyDefinition instanceof ReferenceProperty)) {
                return this.propertyDefinition.getMultiplicity();
            }
            return 1;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CsvColumn [");
            builder.append("propertyName=");
            builder.append(this.propertyName);
            builder.append(", columnName=");
            builder.append(this.columnLabel);
            builder.append(", multiplicity=");
            builder.append(this.getMultiplicity());
            builder.append(", property=");
            if (this.propertyDefinition != null) {
                builder.append(this.propertyDefinition.getClass().getSimpleName());
            } else {
                builder.append("null");
            }
            builder.append(", csvItem=");
            if (this.csvItem != null) {
                builder.append(this.csvItem.getClass().getSimpleName());
            } else {
                builder.append("null");
            }
            builder.append(", editor=");
            builder.append(this.getEditor());
            builder.append(", referenceProperty=");
            if (this.referenceProperty != null) {
                builder.append(this.referenceProperty.getDisplayName());
            } else {
                builder.append("null");
            }
            builder.append("]");
            return builder.toString();
        }
    }

    private class SearchQueryInterrupterHandlerForUpload
    extends SearchQueryInterrupterHandler {
        public SearchQueryInterrupterHandlerForUpload(RequestContext request, SearchContextBase context, SearchQueryInterrupter interrupter) {
            super(request, context, interrupter);
        }

        @Override
        public SearchQueryContext beforeSearch(Query query, SearchQueryInterrupter.SearchQueryType type) {
            log.debug("query localized flag is not set.");
            SearchFormView formView = CsvDownloadSearchContext.this.getForm();
            SearchQueryContext ret = super.getInterrupter().beforeSearch(super.getRequest(), formView, query, type);
            query.setLocalized(false);
            return ret;
        }

        @Override
        public void afterSearch(Query query, Entity entity, SearchQueryInterrupter.SearchQueryType type) {
            SearchFormView formView = CsvDownloadSearchContext.this.getForm();
            super.getInterrupter().afterSearch(super.getRequest(), formView, query, entity, type);
        }
    }
}

