/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.generic.search.CsvDownloadSearchContext;
import org.iplass.gem.command.generic.search.SearchQueryInterrupterHandler;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.entity.csv.EntitySearchCsvWriter;
import org.iplass.mtp.impl.entity.csv.EntityWriteOption;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.SearchQueryInterrupter;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.web.ResultStreamWriter;

public class CsvDownloadUploadableWriter
implements ResultStreamWriter {
    private CsvDownloadSearchContext context;
    private GemConfigService gcs = null;
    private CsvUploadService cus = null;

    public CsvDownloadUploadableWriter(CsvDownloadSearchContext context) {
        this.context = context;
        this.gcs = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        this.cus = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
    }

    public void write(OutputStream out) throws IOException {
        EntityDefinition ed = this.context.getEntityDefinition();
        String charset = this.context.getCharacterCode();
        SearchConditionSection section = this.context.getConditionSection();
        int maxCount = this.gcs.getCsvDownloadMaxCount();
        if (section.getCsvdownloadMaxCount() != null) {
            maxCount = section.getCsvdownloadMaxCount();
        }
        boolean loadOnceOfHasMultipleReferenceEntity = section.isUploadableCsvdownloadLoadAtOnce();
        int loadSizeOfHasMultipleReferenceEntity = this.gcs.getUploadableCsvDownloadLoadSize();
        if (section.getUploadableCsvdownloadLoadSize() != null) {
            loadSizeOfHasMultipleReferenceEntity = section.getUploadableCsvdownloadLoadSize();
        }
        ArrayList<String> directProperties = null;
        if (section.getCsvdownloadUploadableProperties() != null) {
            directProperties = new ArrayList<String>(section.getCsvdownloadUploadablePropertiesSet());
        }
        HashMap sortMap = new HashMap();
        SearchQueryInterrupterHandler handler = this.context.getSearchQueryInterrupterHandler();
        EntityWriteOption option = new EntityWriteOption().charset(charset).quoteAll(this.gcs.isCsvDownloadQuoteAll()).withReferenceVersion(this.gcs.isCsvDownloadReferenceVersion()).properties(directProperties).where(this.context.getWhere()).orderBy(this.context.getOrderBy()).limit(maxCount).loadOnceOfHasMultipleReferenceEntity(loadOnceOfHasMultipleReferenceEntity).loadSizeOfHasMultipleReferenceEntity(loadSizeOfHasMultipleReferenceEntity).versioned(this.context.isVersioned()).mustOrderByWithLimit(this.cus.isMustOrderByWithLimit()).columnDisplayName(property -> {
            if (this.context.isNoDispName()) {
                return "";
            }
            return "(" + this.context.getColumnLabel(property.getName()) + ")";
        }).sortSelectValue(property -> sortMap.computeIfAbsent(property, select -> {
            SelectPropertyEditor spe;
            boolean sortValue = false;
            CsvDownloadSearchContext.CsvColumn column = this.context.getCsvColumn(select.getName());
            if (column != null && column.getEditor() instanceof SelectPropertyEditor && (spe = (SelectPropertyEditor)column.getEditor()).isSortCsvOutputValue()) {
                sortValue = true;
            }
            return sortValue;
        })).beforeSearch(query -> {
            SearchQueryContext sqc = handler.beforeSearch((Query)query, SearchQueryInterrupter.SearchQueryType.CSV);
            EntityWriteOption.SearchQueryCsvContext sqcc = new EntityWriteOption.SearchQueryCsvContext(sqc.getQuery());
            sqcc.setDoPrivileged(sqc.isDoPrivileged());
            sqcc.setWithoutConditionReferenceName(sqc.getWithoutConditionReferenceName());
            return sqcc;
        }).afterSearch((query, entity) -> handler.afterSearch((Query)query, (Entity)entity, SearchQueryInterrupter.SearchQueryType.CSV));
        try (EntitySearchCsvWriter writer = new EntitySearchCsvWriter(out, ed.getName(), option);){
            writer.write();
        }
    }
}

