/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.ReferencePropertySearchCondition;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Not;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.impl.entity.property.PropertyService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.filter.expression.FilterExpressionParser;
import org.iplass.mtp.view.filter.expression.FilterValueExpressionChecker;
import org.iplass.mtp.view.filter.expression.UnsupportedFilterOperationException;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailSearchContext
extends SearchContextBase {
    private static Logger logger = LoggerFactory.getLogger(DetailSearchContext.class);
    private List<SearchConditionDetail> details;
    private Map<Integer, PropertySearchCondition> searchConditions;

    @Override
    public Where getWhere() {
        try {
            this.initParam();
        }
        catch (ApplicationException e) {
            return null;
        }
        And a = new And();
        Condition defaultCondition = this.getDefaultCondition();
        if (defaultCondition != null) {
            a.addExpression(defaultCondition);
        }
        List<Condition> conditions = this.getConditions();
        String expr = this.getDetailConditionExpr();
        if ("Expression".equals(expr)) {
            a.addExpression(this.getFilterExpressionCondition());
        } else if ("And".equals(expr)) {
            if (!conditions.isEmpty()) {
                a.addExpression((Condition)new And(conditions));
            }
        } else if ("Or".equals(expr)) {
            if (!conditions.isEmpty()) {
                a.addExpression((Condition)new Or(conditions));
            }
        } else if ("Not".equals(expr) && !conditions.isEmpty()) {
            And and = new And();
            for (Condition con : conditions) {
                Not not = new Not(con);
                and.addExpression((Condition)not);
            }
            a.addExpression((Condition)and);
        }
        Where w = new Where();
        if (a.getChildExpressions() != null && !a.getChildExpressions().isEmpty()) {
            w.setCondition((Condition)a);
        }
        return w;
    }

    @Override
    public boolean checkParameter() {
        boolean isValid = true;
        try {
            this.initParam();
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            isValid = false;
        }
        if (isValid) {
            for (int i = 0; i < this.details.size(); ++i) {
                SearchConditionDetail detail = this.details.get(i);
                if (detail == null) continue;
                PropertyItem property = null;
                if (detail.getPropertyName().indexOf(".") == -1) {
                    property = this.getLayoutProperty(detail.getPropertyName());
                } else {
                    property = this.getLayoutProperty(detail.getPropertyName());
                    if (property == null) {
                        String[] tmp = detail.getPropertyName().split("\\.");
                        property = this.getLayoutProperty(tmp[0]);
                    }
                }
                if (property != null) {
                    if (!EntityViewUtil.isDisplayElement(this.getDefName(), property.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || property.isHideDetailCondition()) {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
                if (!isValid) break;
                PropertySearchCondition condition = this.searchConditions.get(i);
                if (condition == null || condition.checkDetailParameter(property)) continue;
                isValid = false;
                break;
            }
        }
        if (isValid) {
            try {
                this.validateFilterExpression();
            }
            catch (UnsupportedFilterOperationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)((Object)e));
                }
                this.getRequest().setAttribute("message", (Object)e.getMessage());
                isValid = false;
            }
        } else {
            this.getRequest().setAttribute("message", (Object)DetailSearchContext.resourceString("command.generic.search.SearchCommandBase.searchCondErr", new Object[0]));
        }
        return isValid;
    }

    @Override
    public boolean validation() {
        HashMap<String, String> propMap = this.getRequiredPropertyMap();
        for (Map.Entry<String, String> entry : propMap.entrySet()) {
            SearchConditionDetail detail = null;
            for (SearchConditionDetail _detail : this.details) {
                if (_detail == null || !entry.getKey().equals(_detail.getPropertyName())) continue;
                detail = _detail;
                break;
            }
            if (detail != null) continue;
            this.getRequest().setAttribute("message", (Object)DetailSearchContext.resourceString("command.generic.search.DetailSearchContext.pleaseInput", entry.getValue()));
            return false;
        }
        return true;
    }

    private HashMap<String, String> getRequiredPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        List<PropertyItem> properties = this.getLayoutProperties();
        for (PropertyItem property : properties) {
            String propName;
            PropertyDefinition pd;
            if (property.isBlank() || !EntityViewUtil.isDisplayElement(this.getDefName(), property.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || property.isHideDetailCondition() || !this.isDisplayProperty(pd = this.getPropertyDefinition(propName = property.getPropertyName()))) continue;
            if (pd instanceof ReferenceProperty && property.getEditor() instanceof ReferencePropertyEditor) {
                String defName = ((ReferenceProperty)pd).getObjectDefinitionName();
                String displayLabel = TemplateUtil.getMultilingualString((String)property.getDisplayLabel(), property.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
                this.getRequiredNestPropertyMap(map, propName, displayLabel, defName, (ReferencePropertyEditor)property.getEditor(), property.isRequiredDetail());
                continue;
            }
            if (!property.isRequiredDetail()) continue;
            String displayLabel = TemplateUtil.getMultilingualString((String)property.getDisplayLabel(), property.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
            map.put(propName, displayLabel);
        }
        return map;
    }

    private void getRequiredNestPropertyMap(HashMap<String, String> map, String propName, String displayLabel, String defName, ReferencePropertyEditor editor, boolean required) {
        boolean showNest = false;
        if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.SELECT || editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.CHECKBOX || editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.REFCOMBO || editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LINK && editor.isUseSearchDialog()) {
            if (required) {
                map.put(propName, displayLabel);
            }
        } else if (editor.getNestProperties().isEmpty()) {
            if (required) {
                map.put(propName, displayLabel);
            }
        } else {
            showNest = true;
            if (editor.isUseNestConditionWithProperty() && required) {
                map.put(propName, displayLabel);
            }
        }
        if (showNest || editor.isUseNestConditionWithProperty()) {
            EntityDefinition ed = ((EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class)).get(defName);
            for (NestProperty np : editor.getNestProperties()) {
                String npName = propName + "." + np.getPropertyName();
                PropertyDefinition pd = ed.getProperty(np.getPropertyName());
                if (pd instanceof ReferenceProperty && np.getEditor() instanceof ReferencePropertyEditor) {
                    String refDefName = ((ReferenceProperty)pd).getObjectDefinitionName();
                    String refDisplayLabel = TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
                    this.getRequiredNestPropertyMap(map, npName, refDisplayLabel, refDefName, (ReferencePropertyEditor)np.getEditor(), np.isRequiredDetail());
                    continue;
                }
                if (!np.isRequiredDetail()) continue;
                String refDisplayLabel = TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
                map.put(npName, refDisplayLabel);
            }
        }
    }

    private boolean isDisplayProperty(PropertyDefinition property) {
        if (property instanceof LongTextProperty) {
            PropertyService service = (PropertyService)ServiceRegistry.getRegistry().getService(PropertyService.class);
            return service.isRemainInlineText();
        }
        return true;
    }

    @Override
    public boolean isVersioned() {
        String allVer = this.getRequest().getParam("allVersionDtl");
        return "1".equals(allVer);
    }

    private void initParam() {
        this.getSearchConditionDetails();
        this.convertCondition();
    }

    private List<Condition> getConditions() {
        ArrayList<Condition> ret = new ArrayList<Condition>();
        for (PropertySearchCondition condition : this.searchConditions.values()) {
            List<Condition> _cond;
            if (condition == null || (_cond = condition.convertDetailCondition()).isEmpty()) continue;
            ret.add(_cond.get(0));
        }
        return ret;
    }

    private Condition getFilterExpressionCondition() {
        String filterExpression = this.getFilterExpression();
        FilterExpressionParser parser = new FilterExpressionParser(filterExpression, new FilterExpressionParser.FilterItemHandler(){

            @Override
            public boolean isIndexOutOfBounds(int index) {
                return index >= DetailSearchContext.this.searchConditions.size();
            }

            @Override
            public Condition getCondition(int index) {
                List<Condition> _cond;
                PropertySearchCondition cond = (PropertySearchCondition)DetailSearchContext.this.searchConditions.get(index);
                Condition c = null;
                if (cond != null && !(_cond = cond.convertDetailCondition()).isEmpty()) {
                    c = _cond.get(0);
                }
                return c;
            }
        });
        return parser.parse();
    }

    private void getSearchConditionDetails() {
        if (this.details == null) {
            this.details = new ArrayList<SearchConditionDetail>();
            int count = this.getCondtionCount();
            for (int i = 0; i < count; ++i) {
                SearchConditionDetail detail = this.getDetailCondition(i);
                this.details.add(detail);
            }
        }
    }

    private int getCondtionCount() {
        Integer count = this.getRequest().getParamAsInt("dtlCndCount");
        return count == null ? 0 : count;
    }

    private SearchConditionDetail getDetailCondition(int index) {
        String propName = this.getRequest().getParam("dtlCndPropNm_" + index);
        if (StringUtil.isBlank((String)propName)) {
            return null;
        }
        String predicate = this.getRequest().getParam("dtlCndPrdct_" + index);
        if (StringUtil.isBlank((String)predicate)) {
            return null;
        }
        String value = this.getRequest().getParam("dtlCndVl_" + index);
        if (StringUtil.isBlank((String)value) && !"NotNull".equals(predicate) && !"Null".equals(predicate)) {
            return null;
        }
        SearchConditionDetail detail = new SearchConditionDetail();
        detail.setPropertyName(propName);
        detail.setPredicate(predicate);
        detail.setValue(value);
        return detail;
    }

    private void convertCondition() {
        if (this.searchConditions == null) {
            this.searchConditions = new HashMap<Integer, PropertySearchCondition>();
            for (int i = 0; i < this.details.size(); ++i) {
                SearchConditionDetail detail = this.details.get(i);
                if (detail == null) {
                    this.searchConditions.put(i, null);
                    continue;
                }
                this.searchConditions.put(i, this.detail2Condition(detail));
            }
        }
    }

    private PropertySearchCondition detail2Condition(SearchConditionDetail detail) {
        PropertySearchCondition condition = null;
        int firstDotIndex = detail.getPropertyName().indexOf(46);
        if (firstDotIndex == -1) {
            PropertyDefinition pd = this.getPropertyDefinition(detail.getPropertyName());
            if (pd == null) {
                throw new ApplicationException();
            }
            PropertyItem property = this.getLayoutProperty(pd.getName());
            if (property == null) {
                throw new ApplicationException();
            }
            condition = PropertySearchCondition.newInstance(pd, property.getEditor(), detail);
        } else {
            PropertyItem property = this.getLayoutProperty(detail.getPropertyName());
            if (property != null) {
                PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(detail.getPropertyName(), this.getEntityDefinition());
                if (pd == null) {
                    throw new ApplicationException();
                }
                condition = PropertySearchCondition.newInstance(pd, property.getEditor(), detail);
            } else {
                String parent = detail.getPropertyName().substring(0, firstDotIndex);
                PropertyDefinition pd = this.getEntityDefinition().getProperty(parent);
                if (pd == null) {
                    throw new ApplicationException();
                }
                property = this.getLayoutProperty(parent);
                if (property == null) {
                    throw new ApplicationException();
                }
                if (pd instanceof ReferenceProperty && property.getEditor() instanceof ReferencePropertyEditor) {
                    ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
                    PropertyDefinition _pd = this.getPropertyDefinition(detail.getPropertyName());
                    if (_pd != null) {
                        ReferencePropertySearchCondition _condition = (ReferencePropertySearchCondition)PropertySearchCondition.newInstance(pd, editor, detail);
                        _condition.setNestProperty(_pd);
                        condition = _condition;
                    } else {
                        throw new ApplicationException();
                    }
                }
            }
        }
        return condition;
    }

    private void validateFilterExpression() {
        String expr = this.getDetailConditionExpr();
        if (StringUtil.isEmpty((String)expr) || !"Expression".equals(expr)) {
            return;
        }
        String filterExpression = this.getFilterExpression();
        if (StringUtil.isEmpty((String)filterExpression)) {
            throw new UnsupportedFilterOperationException(DetailSearchContext.resourceString("command.generic.search.DetailSearchContext.requiredExpressionErr", new Object[0]));
        }
        FilterValueExpressionChecker checker = new FilterValueExpressionChecker();
        checker.execute(filterExpression);
    }

    private String getDetailConditionExpr() {
        return this.getRequest().getParam("dtlCndExpr");
    }

    private String getFilterExpression() {
        return this.getRequest().getParam("dtlCndFilterExpression");
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

