/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.SyntaxService;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QuerySyntaxRegister;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterItem;
import org.iplass.mtp.view.filter.EntityFilterManager;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;

public class FixedSearchContext
extends SearchContextBase {
    @Override
    public Where getWhere() {
        Condition defaultCond;
        Where where = null;
        EntityFilterManager efm = (EntityFilterManager)ManagerLocator.getInstance().getManager(EntityFilterManager.class);
        EntityFilter entityFilter = (EntityFilter)efm.get(this.getDefName());
        EntityFilterItem item = null;
        String filterName = this.getFilterName();
        if (entityFilter != null && filterName != null && !filterName.isEmpty()) {
            item = entityFilter.getItem(filterName);
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (item != null && item.getCondition() != null) {
            conditions.add(new PreparedQuery(item.getCondition()).condition(null));
        }
        if (this.getConditionSection().isUseDefaultConditionWithFilterDefinition() && (defaultCond = this.getDefaultCondition()) != null) {
            conditions.add(defaultCond);
        }
        if (!conditions.isEmpty()) {
            And and = new And(conditions);
            where = new Where((Condition)and);
        }
        return where;
    }

    @Override
    public boolean checkParameter() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OrderBy getOrderBy() {
        OrderBy orderBy = null;
        EntityFilterManager efm = (EntityFilterManager)ManagerLocator.getInstance().getManager(EntityFilterManager.class);
        EntityFilter entityFilter = (EntityFilter)efm.get(this.getDefName());
        EntityFilterItem item = null;
        String filterName = this.getFilterName();
        if (entityFilter != null && filterName != null && !filterName.isEmpty()) {
            item = entityFilter.getItem(filterName);
        }
        if (item != null && StringUtil.isNotEmpty((String)item.getSort())) {
            SyntaxService service = (SyntaxService)ServiceRegistry.getRegistry().getService(SyntaxService.class);
            OrderBySyntax syntax = (OrderBySyntax)service.getSyntaxContext(QuerySyntaxRegister.QUERY_CONTEXT).getSyntax(OrderBySyntax.class);
            ParseContext context = new ParseContext("order by " + item.getSort());
            try {
                orderBy = syntax.parse(context);
                SortSpec sortSpec = this.getSortSpec();
                if (sortSpec == null) return orderBy;
                orderBy.getSortSpecList().add(0, sortSpec);
                return orderBy;
            }
            catch (ParseException e) {
                throw new SystemException(e.getMessage(), (Throwable)e);
            }
        } else {
            SortSpec sortSpec = this.getSortSpec();
            if (sortSpec == null) return orderBy;
            orderBy = new OrderBy();
            orderBy.add(sortSpec);
        }
        return orderBy;
    }

    private SortSpec getSortSpec() {
        SortSpec sortSpec = null;
        String sortKey = this.getRequest().getParam("sortKey");
        if (StringUtil.isNotBlank((String)sortKey)) {
            String key = null;
            PropertyDefinition pd = this.getPropertyDefinition(sortKey);
            key = pd instanceof ReferenceProperty ? sortKey + "." + "oid" : sortKey;
            String sortType = this.getRequest().getParam("sortType");
            SortSpec.SortType type = null;
            type = StringUtil.isBlank((String)sortType) ? SortSpec.SortType.DESC : SortSpec.SortType.valueOf((String)sortType);
            PropertyColumn property = this.getLayoutPropertyColumn(sortKey);
            if (property != null) {
                SortSpec.NullOrderingSpec nullOrderingSpec = this.getNullOrderingSpec(property.getNullOrderType());
                sortSpec = new SortSpec(key, type);
                sortSpec.setNullOrderingSpec(nullOrderingSpec);
            }
        }
        return sortSpec;
    }

    private String getFilterName() {
        return this.getRequest().getParam("filterName");
    }
}

