/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.SearchConditionValidationException;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.ReferencePropertySearchCondition;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferenceComboSetting;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalSearchContext
extends SearchContextBase {
    private static Logger logger = LoggerFactory.getLogger(NormalSearchContext.class);
    private NormalConditionValue condition;
    private Map<String, PropertySearchCondition> propertyConditions;
    private Map<String, PropertySearchCondition> nestPropertyConditions;

    @Override
    public Where getWhere() {
        Condition defaultCondition;
        List<Condition> list;
        Where w = new Where();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        this.getPropertyConditions();
        if (this.propertyConditions != null && !this.propertyConditions.isEmpty()) {
            for (PropertySearchCondition condition : this.propertyConditions.values()) {
                list = condition.convertNormalCondition();
                if (list == null || list.isEmpty()) continue;
                conditions.addAll(list);
            }
        }
        if (this.nestPropertyConditions != null && !this.nestPropertyConditions.isEmpty()) {
            for (PropertySearchCondition condition : this.nestPropertyConditions.values()) {
                list = condition.convertNormalCondition();
                if (list == null || list.isEmpty()) continue;
                conditions.addAll(list);
            }
        }
        if ((defaultCondition = this.getDefaultCondition()) != null) {
            conditions.add(defaultCondition);
        }
        if (conditions.size() > 0) {
            w.setCondition((Condition)new And(conditions));
        }
        return w;
    }

    @Override
    public boolean checkParameter() {
        PropertySearchCondition propertyCondition;
        boolean isValid = true;
        try {
            if (this.propertyConditions == null) {
                this.getPropertyConditions();
            }
        }
        catch (ApplicationException e) {
            isValid = false;
        }
        if (isValid) {
            for (PropertyDefinition pd : this.getPropertyList()) {
                Object value;
                PropertyItem property = this.getLayoutPropertyForCheck(pd.getName());
                propertyCondition = null;
                if (property != null) {
                    if ((!EntityViewUtil.isDisplayElement(this.getDefName(), property.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || property.isHideNormalCondition()) && (value = this.condition.getValue(property.getPropertyName())) != null) {
                        if (value.getClass().isArray()) {
                            if (((Object[])value).length != 0) {
                                isValid = false;
                            }
                        } else {
                            isValid = false;
                        }
                        if (!isValid) break;
                    }
                    propertyCondition = this.propertyConditions.get(property.getPropertyName());
                } else {
                    value = this.condition.getValue(pd.getName());
                    if (value != null) {
                        if (value.getClass().isArray()) {
                            if (((Object[])value).length != 0) {
                                isValid = false;
                            }
                        } else {
                            isValid = false;
                        }
                        if (!isValid) break;
                    }
                    propertyCondition = this.propertyConditions.get(pd.getName());
                }
                if (propertyCondition == null || propertyCondition.checkNormalParameter(property)) continue;
                isValid = false;
                break;
            }
        }
        if (isValid) {
            List<PropertyItem> properties = this.getLayoutProperties();
            for (PropertyItem property : properties) {
                Object value;
                if (property.isBlank() || this.getEntityDefinition().getProperty(property.getPropertyName()) != null) continue;
                if ((!EntityViewUtil.isDisplayElement(this.getDefName(), property.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || property.isHideNormalCondition()) && (value = this.condition.getValue(property.getPropertyName())) != null) {
                    if (value.getClass().isArray()) {
                        if (((Object[])value).length != 0) {
                            isValid = false;
                        }
                    } else {
                        isValid = false;
                    }
                    if (!isValid) break;
                }
                if ((propertyCondition = this.nestPropertyConditions.get(property.getPropertyName())) == null || propertyCondition.checkNormalParameter(property)) continue;
                isValid = false;
                break;
            }
        }
        if (!isValid) {
            this.getRequest().setAttribute("message", (Object)NormalSearchContext.resourceString("command.generic.search.SearchCommandBase.searchCondErr", new Object[0]));
        }
        return isValid;
    }

    @Override
    public boolean validation() {
        List<PropertyItem> properties = this.getLayoutProperties();
        for (PropertyItem property : properties) {
            if (property.isBlank() || !EntityViewUtil.isDisplayElement(this.getDefName(), property.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || property.isHideNormalCondition()) continue;
            PropertyDefinition pd = this.getPropertyDefinition(property.getPropertyName());
            PropertySearchCondition propertyCondition = null;
            propertyCondition = property.getPropertyName().indexOf(".") == -1 ? this.propertyConditions.get(property.getPropertyName()) : this.nestPropertyConditions.get(property.getPropertyName());
            if (property.isRequiredNormal() && (propertyCondition == null || propertyCondition.getValue() == null)) {
                String displayLabel = TemplateUtil.getMultilingualString((String)property.getDisplayLabel(), property.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
                this.getRequest().setAttribute("message", (Object)NormalSearchContext.resourceString("command.generic.search.NormalSearchContext.pleaseInput", displayLabel));
                return false;
            }
            if (!(pd instanceof ReferenceProperty) || !(property.getEditor() instanceof ReferencePropertyEditor)) continue;
            try {
                if (propertyCondition == null) {
                    propertyCondition = new ReferencePropertySearchCondition(pd, property.getEditor(), null);
                }
                ((ReferencePropertySearchCondition)propertyCondition).validateNormalParameter(property.isRequiredNormal());
            }
            catch (SearchConditionValidationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)((Object)e));
                }
                if (e.getMessage() == null) {
                    String displayLabel = TemplateUtil.getMultilingualString((String)property.getDisplayLabel(), property.getLocalizedDisplayLabelList(), (String)pd.getDisplayName(), (List)pd.getLocalizedDisplayNameList());
                    this.getRequest().setAttribute("message", (Object)NormalSearchContext.resourceString("command.generic.search.NormalSearchContext.pleaseInput", displayLabel));
                } else {
                    this.getRequest().setAttribute("message", (Object)e.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    private Map<String, PropertySearchCondition> getPropertyConditions() {
        if (this.propertyConditions == null) {
            this.condition = new NormalConditionValue();
            this.propertyConditions = new LinkedHashMap<String, PropertySearchCondition>();
            for (PropertyDefinition p : this.getPropertyList()) {
                Object value = this.getConditionValue(p, p.getName());
                if (value == null || value.getClass().isArray() && ((Object[])value).length == 0) continue;
                PropertyItem property = this.getLayoutProperty(p.getName());
                if (property == null || property.isHideNormalCondition()) {
                    throw new ApplicationException();
                }
                this.condition.setValue(property.getPropertyName(), value);
                this.propertyConditions.put(property.getPropertyName(), PropertySearchCondition.newInstance(p, property.getEditor(), value));
            }
            this.nestPropertyConditions = new LinkedHashMap<String, PropertySearchCondition>();
            List<PropertyItem> properties = this.getLayoutProperties();
            for (PropertyItem property : properties) {
                PropertyDefinition pd;
                Object value;
                if (property.isBlank() || this.getEntityDefinition().getProperty(property.getPropertyName()) != null || (value = this.getConditionValue(pd = EntityViewUtil.getPropertyDefinition(property.getPropertyName(), this.getEntityDefinition()), property.getPropertyName())) == null || value.getClass().isArray() && ((Object[])value).length == 0) continue;
                int lastIndex = property.getPropertyName().lastIndexOf(".");
                String parentName = property.getPropertyName().substring(0, lastIndex);
                if (property == null || property.isHideNormalCondition()) {
                    throw new ApplicationException();
                }
                this.condition.setValue(property.getPropertyName(), value);
                this.nestPropertyConditions.put(property.getPropertyName(), PropertySearchCondition.newInstance(pd, property.getEditor(), value, parentName));
            }
        }
        return this.propertyConditions;
    }

    private Object getConditionValue(PropertyDefinition p, String propName) {
        String conditionPrefix = "sc_";
        Object ret = null;
        if (p instanceof DateProperty) {
            Date[] date = new Date[]{this.getRequest().getParamAsDate("sc_" + propName + "From", TemplateUtil.getLocaleFormat().getServerDateFormat()), this.getRequest().getParamAsDate("sc_" + propName + "To", TemplateUtil.getLocaleFormat().getServerDateFormat())};
            ret = date[0] == null && date[1] == null ? null : date;
        } else if (p instanceof TimeProperty) {
            Time[] time = new Time[]{this.getRequest().getParamAsTime("sc_" + propName + "From", TemplateUtil.getLocaleFormat().getServerTimeFormat()), this.getRequest().getParamAsTime("sc_" + propName + "To", TemplateUtil.getLocaleFormat().getServerTimeFormat())};
            ret = time[0] == null && time[1] == null ? null : time;
        } else if (p instanceof DateTimeProperty) {
            Timestamp[] timestamp = new Timestamp[]{this.getRequest().getParamAsTimestamp("sc_" + propName + "From", TemplateUtil.getLocaleFormat().getServerDateTimeFormat()), this.getRequest().getParamAsTimestamp("sc_" + propName + "To", TemplateUtil.getLocaleFormat().getServerDateTimeFormat())};
            ret = timestamp[0] == null && timestamp[1] == null ? null : timestamp;
        } else if (p instanceof SelectProperty) {
            ret = this.getSelectValue("sc_" + propName);
        } else if (p instanceof ReferenceProperty) {
            if (p.getName().equals(propName)) {
                ret = this.getReferenceValue((ReferenceProperty)p);
            } else {
                PropertyItem property = this.getLayoutProperty(propName);
                if (property != null) {
                    ReferencePropertyEditor re = (ReferencePropertyEditor)property.getEditor();
                    re.setPropertyName(propName);
                    ret = this.getReferenceValue((ReferenceProperty)p, re);
                } else {
                    ret = this.getNestReferenceValue((ReferenceProperty)p, propName);
                }
            }
        } else if (p instanceof ExpressionProperty) {
            ret = this.getExpressionValue((ExpressionProperty)p, "sc_" + propName);
        } else if (p instanceof DecimalProperty) {
            BigDecimal[] decimal = new BigDecimal[]{this.getRequest().getParamAsBigDecimal("sc_" + propName), this.getRequest().getParamAsBigDecimal("sc_" + propName + "To")};
            ret = decimal[0] == null && decimal[1] == null ? null : decimal;
        } else if (p instanceof FloatProperty) {
            Double[] dbl = new Double[]{this.getRequest().getParamAsDouble("sc_" + propName), this.getRequest().getParamAsDouble("sc_" + propName + "To")};
            ret = dbl[0] == null && dbl[1] == null ? null : dbl;
        } else if (p instanceof IntegerProperty) {
            Long[] lng = new Long[]{this.getRequest().getParamAsLong("sc_" + propName), this.getRequest().getParamAsLong("sc_" + propName + "To")};
            ret = lng[0] == null && lng[1] == null ? null : lng;
        } else {
            String value = this.getRequest().getParam("sc_" + propName);
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            ret = p instanceof BooleanProperty ? Boolean.valueOf(Boolean.parseBoolean(value)) : value;
        }
        return ret;
    }

    private Object getExpressionValue(ExpressionProperty ep, String propName) {
        if (ep.getResultType() == PropertyDefinitionType.DATE) {
            String[] ret = new String[]{this.getRequest().getParam(propName), this.getRequest().getParam(propName + "From"), this.getRequest().getParam(propName + "To")};
            if (StringUtil.isBlank((String)ret[0]) && StringUtil.isBlank((String)ret[1]) && StringUtil.isBlank((String)ret[2])) {
                return null;
            }
            return ret;
        }
        if (ep.getResultType() == PropertyDefinitionType.DATETIME) {
            String[] ret = new String[]{this.getRequest().getParam(propName), this.getRequest().getParam(propName + "From"), this.getRequest().getParam(propName + "To")};
            if (StringUtil.isBlank((String)ret[0]) && StringUtil.isBlank((String)ret[1]) && StringUtil.isBlank((String)ret[2])) {
                return null;
            }
            return ret;
        }
        if (ep.getResultType() == PropertyDefinitionType.SELECT) {
            String[] ret = this.getRequest().getParams(propName);
            if (ret != null && ret.length > 0) {
                boolean isNull = true;
                for (int i = 0; i < ret.length; ++i) {
                    if (!StringUtil.isNotBlank((String)ret[i])) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
            }
            return ret;
        }
        if (ep.getResultType() == PropertyDefinitionType.TIME) {
            String[] ret = new String[]{this.getRequest().getParam(propName), this.getRequest().getParam(propName + "From"), this.getRequest().getParam(propName + "To")};
            if (StringUtil.isBlank((String)ret[0]) && StringUtil.isBlank((String)ret[1]) && StringUtil.isBlank((String)ret[2])) {
                return null;
            }
            return ret;
        }
        if (ep.getResultType() == PropertyDefinitionType.DECIMAL) {
            String[] ret = new String[]{this.getRequest().getParam(propName), this.getRequest().getParam(propName + "To")};
            if (StringUtil.isBlank((String)ret[0]) && StringUtil.isBlank((String)ret[1])) {
                return null;
            }
            return ret;
        }
        if (ep.getResultType() == PropertyDefinitionType.FLOAT) {
            String[] ret = new String[]{this.getRequest().getParam(propName), this.getRequest().getParam(propName + "To")};
            if (StringUtil.isBlank((String)ret[0]) && StringUtil.isBlank((String)ret[1])) {
                return null;
            }
            return ret;
        }
        if (ep.getResultType() == PropertyDefinitionType.INTEGER) {
            String[] ret = new String[]{this.getRequest().getParam(propName), this.getRequest().getParam(propName + "To")};
            if (StringUtil.isBlank((String)ret[0]) && StringUtil.isBlank((String)ret[1])) {
                return null;
            }
            return ret;
        }
        String ret = this.getRequest().getParam(propName);
        if (StringUtil.isBlank((String)ret)) {
            return null;
        }
        return ret;
    }

    private Object getReferenceValue(ReferenceProperty rp) {
        Object ret = null;
        List<PropertyItem> properties = this.getLayoutProperties();
        for (PropertyItem property : properties) {
            if (property.isBlank() || !property.getPropertyName().equals(rp.getName()) || !(property.getEditor() instanceof ReferencePropertyEditor)) continue;
            ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
            editor.setPropertyName(rp.getName());
            ret = this.getReferenceValue(rp, editor);
        }
        return ret;
    }

    private Object getNestReferenceValue(ReferenceProperty rp, String propName) {
        ReferencePropertyEditor editor = this.getReferencePropertyEditor(propName);
        return this.getReferenceValue(rp, editor);
    }

    private Object getReferenceValue(ReferenceProperty rp, ReferencePropertyEditor editor) {
        String oid;
        int lastIndex;
        String[] oid_ver;
        ReferencePropertySearchCondition.ReferenceNormalConditionValue ret = null;
        boolean showNest = false;
        String propName = null;
        propName = rp.getName().equals(editor.getPropertyName()) ? rp.getName() : editor.getPropertyName();
        if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.SELECT) {
            String oid2 = this.getRequest().getParam("sc_" + propName);
            if (StringUtil.isNotBlank((String)oid2)) {
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(new GenericEntity(rp.getObjectDefinitionName(), oid2, null));
            }
        } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.CHECKBOX) {
            ArrayList<GenericEntity> list = new ArrayList<GenericEntity>();
            String[] oid3 = (String[])this.getRequest().getParams("sc_" + propName, String.class);
            if (oid3 != null && oid3.length > 0) {
                for (String tmp : oid3) {
                    list.add(new GenericEntity(rp.getObjectDefinitionName(), tmp, null));
                }
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(list.toArray(new Entity[list.size()]));
            }
        } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.REFCOMBO) {
            ReferencePropertySearchCondition.RefComboCondition rcc;
            String oid4 = this.getRequest().getParam("sc_" + propName);
            if (StringUtil.isNotBlank((String)oid4)) {
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(new GenericEntity(rp.getObjectDefinitionName(), oid4, null));
            } else if (editor.getSearchType() == ReferencePropertyEditor.RefComboSearchType.UPPER && (rcc = this.getRefComboCondition(propName, editor.getReferenceComboSetting())) != null) {
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(rcc);
            }
        } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LINK && editor.isUseSearchDialog() || editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LABEL) {
            ArrayList<GenericEntity> list = new ArrayList<GenericEntity>();
            oid_ver = (String[])this.getRequest().getParams("sc_" + propName, String.class);
            if (oid_ver != null && oid_ver.length > 0) {
                for (String tmp : oid_ver) {
                    if (tmp == null) continue;
                    lastIndex = tmp.lastIndexOf("_");
                    oid = tmp.substring(0, lastIndex);
                    list.add(new GenericEntity(rp.getObjectDefinitionName(), oid, null));
                }
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(list.toArray(new Entity[list.size()]));
            }
        } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.TREE) {
            ArrayList<GenericEntity> list = new ArrayList<GenericEntity>();
            oid_ver = (String[])this.getRequest().getParams("sc_" + propName, String.class);
            if (oid_ver != null && oid_ver.length > 0) {
                for (String tmp : oid_ver) {
                    if (tmp == null) continue;
                    lastIndex = tmp.lastIndexOf("_");
                    oid = tmp.substring(0, lastIndex);
                    list.add(new GenericEntity(rp.getObjectDefinitionName(), oid, null));
                }
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(list.toArray(new Entity[list.size()]));
            }
        } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.UNIQUE && editor.isUseSearchDialog()) {
            ArrayList<GenericEntity> list = new ArrayList<GenericEntity>();
            oid_ver = (String[])this.getRequest().getParams("sc_" + propName, String.class);
            if (oid_ver != null && oid_ver.length > 0) {
                for (String tmp : oid_ver) {
                    if (tmp == null || tmp.length() == 0) continue;
                    lastIndex = tmp.lastIndexOf("_");
                    oid = tmp.substring(0, lastIndex);
                    list.add(new GenericEntity(rp.getObjectDefinitionName(), oid, null));
                }
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(list.toArray(new Entity[list.size()]));
            }
        } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.HIDDEN) {
            ArrayList<GenericEntity> list = new ArrayList<GenericEntity>();
            oid_ver = (String[])this.getRequest().getParams("sc_" + propName, String.class);
            if (oid_ver != null && oid_ver.length > 0) {
                for (String tmp : oid_ver) {
                    if (tmp == null) continue;
                    lastIndex = tmp.lastIndexOf("_");
                    oid = tmp.substring(0, lastIndex);
                    String version = tmp.substring(lastIndex + 1);
                    GenericEntity cond = new GenericEntity(rp.getObjectDefinitionName(), oid, null);
                    cond.setVersion(Long.valueOf(version));
                    list.add(cond);
                }
                ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(list.toArray(new Entity[list.size()]));
            }
        } else {
            boolean searchName = false;
            if (editor.getNestProperties().isEmpty()) {
                searchName = true;
            } else {
                if (editor.isUseNestConditionWithProperty()) {
                    searchName = true;
                }
                showNest = true;
            }
            if (searchName) {
                GenericEntity refEntity = null;
                String name = this.getRequest().getParam("sc_" + propName);
                if (StringUtil.isNotBlank((String)name)) {
                    refEntity = new GenericEntity(rp.getObjectDefinitionName());
                    refEntity.setName(name);
                    ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(refEntity);
                }
            }
        }
        if (showNest || editor.isUseNestConditionWithProperty()) {
            EntityDefinition ed = this.getReferenceEntityDefinition(rp);
            GenericEntity nest = null;
            for (NestProperty np : editor.getNestProperties()) {
                RangePropertyEditor rangep;
                PropertyDefinition pd = ed.getProperty(np.getPropertyName());
                Object value = this.getConditionValue(pd, propName + "." + pd.getName());
                if (value != null) {
                    if (nest == null) {
                        nest = new GenericEntity(rp.getObjectDefinitionName());
                    }
                    nest.setValue(pd.getName(), value);
                }
                if (!(np.getEditor() instanceof RangePropertyEditor) || (value = this.getConditionValue(pd = ed.getProperty((rangep = (RangePropertyEditor)((Object)np.getEditor())).getToPropertyName()), propName + "." + pd.getName())) == null) continue;
                if (nest == null) {
                    nest = new GenericEntity(rp.getObjectDefinitionName());
                }
                nest.setValue(pd.getName(), value);
            }
            if (nest != null) {
                if (ret == null) {
                    ret = new ReferencePropertySearchCondition.ReferenceNormalConditionValue(null);
                }
                ret.setNest((Entity)nest);
            }
        }
        return ret;
    }

    private ReferencePropertySearchCondition.RefComboCondition getRefComboCondition(String propName, ReferenceComboSetting setting) {
        String name = propName + "." + setting.getPropertyName();
        String oid = this.getRequest().getParam(name);
        if (StringUtil.isNotBlank((String)oid)) {
            return new ReferencePropertySearchCondition.RefComboCondition(oid, name);
        }
        if (setting.getParent() != null) {
            return this.getRefComboCondition(name, setting.getParent());
        }
        return null;
    }

    private ReferencePropertyEditor getReferencePropertyEditor(String propName) {
        String[] _propName = propName.split("\\.");
        List<PropertyItem> properties = this.getLayoutProperties();
        for (PropertyItem property : properties) {
            if (property.isBlank() || !property.getPropertyName().equals(_propName[0]) || !(property.getEditor() instanceof ReferencePropertyEditor)) continue;
            ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
            ReferencePropertyEditor ret = this.getNestReferencePropertyEditor(editor, _propName, 1);
            ret.setPropertyName(propName);
            return ret;
        }
        return null;
    }

    private ReferencePropertyEditor getNestReferencePropertyEditor(ReferencePropertyEditor editor, String[] propName, int index) {
        if (editor.getNestProperties().size() == 0 && propName.length < index) {
            return null;
        }
        if (propName.length == index) {
            return editor;
        }
        for (NestProperty property : editor.getNestProperties()) {
            if (!property.getPropertyName().equals(propName[index])) continue;
            if (property.getEditor() instanceof ReferencePropertyEditor) {
                return this.getNestReferencePropertyEditor((ReferencePropertyEditor)property.getEditor(), propName, ++index);
            }
            return null;
        }
        return null;
    }

    private Object getSelectValue(String propName) {
        SelectPropertyEditor.SelectDisplayType dispType;
        SelectValue ret = null;
        String strDispType = this.getRequest().getParam(propName + "_dispType");
        SelectPropertyEditor.SelectDisplayType selectDisplayType = dispType = StringUtil.isNotBlank((String)strDispType) ? SelectPropertyEditor.SelectDisplayType.valueOf(strDispType) : null;
        if (dispType == SelectPropertyEditor.SelectDisplayType.CHECKBOX || dispType == SelectPropertyEditor.SelectDisplayType.HIDDEN) {
            String[] values = this.getRequest().getParams(propName);
            ArrayList<SelectValue> list = new ArrayList<SelectValue>();
            if (values != null && values.length > 0) {
                for (String value : values) {
                    if (value == null || value.isEmpty()) continue;
                    list.add(new SelectValue(value));
                }
            }
            ret = list.toArray(new SelectValue[list.size()]);
        } else {
            String value = this.getRequest().getParam(propName);
            if (value != null && !value.isEmpty()) {
                ret = new SelectValue(value);
            }
        }
        return ret;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    public class NormalConditionValue {
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Object getValue(String propName) {
            return this.properties.get(propName);
        }

        public void setValue(String propName, Object value) {
            this.properties.put(propName, value);
        }
    }
}

