/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.iplass.gem.command.CreateSearchResultUtil;
import org.iplass.gem.command.common.SearchResultData;
import org.iplass.gem.command.generic.search.SearchCommandBase;
import org.iplass.gem.command.generic.search.SearchContext;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.gem.command.generic.search.handler.CreateSearchResultEventHandler;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.CommandInvoker;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/search/search", displayName="\u6c4e\u7528\u691c\u7d22", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, results={"count", "message", "htmlData"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/search/SearchCommand", displayName="\u6c4e\u7528\u691c\u7d22")
public final class SearchCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/search/search";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(RequestContext request) {
        String searchType = request.getParam("searchType");
        SearchCommandBase command = null;
        CommandInvoker ci = (CommandInvoker)ManagerLocator.getInstance().getManager(CommandInvoker.class);
        if ("normal".equals(searchType)) {
            command = (SearchCommandBase)ci.getCommandInstance("gem/generic/search/NormalSearchCommand");
        } else if ("detail".equals(searchType)) {
            command = (SearchCommandBase)ci.getCommandInstance("gem/generic/search/DetailSearchCommand");
        } else if ("fixed".equals(searchType)) {
            command = (SearchCommandBase)ci.getCommandInstance("gem/generic/search/FixedSearchCommand");
        }
        if (command == null) throw new IllegalArgumentException("invalid search type. value=" + searchType);
        String ret = command.execute(request);
        if ("SUCCESS".equals(ret)) {
            try {
                SearchResult result = (SearchResult)request.getAttribute("result");
                if (result != null) {
                    SearchContext sc = command.getContext(request);
                    SearchResultData resultData = CreateSearchResultUtil.getResultData(result.getList(), sc.getEntityDefinition(), ((SearchContextBase)sc).getResultSection(), ((SearchContextBase)sc).getViewName());
                    if (sc instanceof CreateSearchResultEventHandler) {
                        ((CreateSearchResultEventHandler)((Object)sc)).fireCreateSearchResultEvent(resultData);
                    }
                    request.setAttribute("htmlData", resultData.toResponse());
                    return "SUCCESS";
                }
                request.setAttribute("htmlData", new ArrayList());
                return "SUCCESS";
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            catch (ServletException e) {
                throw new SystemException((Throwable)e);
            }
        } else {
            if ("ERROR_PARAMETER".equals(ret)) {
                return "ERROR_PARAMETER";
            }
            if ("ERROR_VALIDATE".equals(ret)) {
                return "ERROR_VALIDATE";
            }
            if ("ERROR_SEARCH".equals(ret)) {
                return "ERROR_SEARCH";
            }
            String message = (String)request.getAttribute("message");
            throw new ApplicationException(message);
        }
    }
}

