/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.SearchContext;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.SearchQueryInterrupter;

public abstract class SearchCommandBase
implements Command {
    protected EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    protected EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    protected EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public String execute(RequestContext request) {
        SearchContext context = this.getContext(request);
        if (!context.checkParameter()) {
            return "ERROR_PARAMETER";
        }
        if (!context.validation()) {
            return "ERROR_VALIDATE";
        }
        Query query = null;
        query = this.isSearchDelete(request) ? this.toQueryForDelete(context) : (this.isSearchBulk(request) ? this.toQueryForBulkUpdate(context) : this.toQuery(context));
        if (query == null) {
            return "ERROR_SEARCH";
        }
        if (this.isValidateCondition(request)) {
            return "SUCCESS";
        }
        if (context.isCount()) {
            this.count(context, query.copy());
        }
        if (this.isSearchDelete(request)) {
            this.search(context, query.copy());
        } else if (this.isSearchBulk(request)) {
            this.search(context, query.copy());
        } else if (context.isSearch()) {
            Query q = query.copy();
            this.setOrderBy(context, q);
            this.setLimit(context, q);
            this.search(context, q);
        }
        return "SUCCESS";
    }

    public SearchContext getContext(RequestContext request) {
        SearchContext context = null;
        try {
            context = this.getContextClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new EntityRuntimeException(SearchCommandBase.resourceString("command.generic.search.SearchCommandBase.internalErr", new Object[0]), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new EntityRuntimeException(SearchCommandBase.resourceString("command.generic.search.SearchCommandBase.internalErr", new Object[0]), (Throwable)e);
        }
        if (context != null) {
            context.setRequest(request);
            context.setEntityDefinition(this.edm.get(context.getDefName()));
            context.setEntityView((EntityView)this.evm.get(context.getDefName()));
        }
        return context;
    }

    protected abstract Class<? extends SearchContext> getContextClass();

    protected Query toQuery(SearchContext context) {
        Query query = new Query();
        query.setSelect(context.getSelect());
        query.setFrom(context.getFrom());
        query.setWhere(context.getWhere());
        query.setVersiond(context.isVersioned());
        return query;
    }

    protected Query toQueryForDelete(SearchContext context) {
        Query query = new Query();
        query.select(new Object[]{"oid", "version"});
        query.from(context.getDefName());
        query.setWhere(context.getWhere());
        query.setVersiond(context.isVersioned());
        return query;
    }

    protected Query toQueryForBulkUpdate(SearchContext context) {
        Query query = new Query();
        query.select(new Object[]{"oid", "version", "updateDate"});
        query.from(context.getDefName());
        query.setWhere(context.getWhere());
        query.setVersiond(context.isVersioned());
        return query;
    }

    protected void setLimit(SearchContext context, Query query) {
        query.setLimit(context.getLimit());
    }

    protected void setOrderBy(SearchContext context, Query query) {
        query.setOrderBy(context.getOrderBy());
    }

    public boolean isSearchDelete(RequestContext request) {
        return request.getAttribute("isSearchDelete") != null && (Boolean)request.getAttribute("isSearchDelete") != false;
    }

    public void setSearchDelete(RequestContext request, boolean isDelete) {
        request.setAttribute("isSearchDelete", (Object)isDelete);
    }

    public boolean isSearchBulk(RequestContext request) {
        return request.getAttribute("isSearchBulk") != null && (Boolean)request.getAttribute("isSearchBulk") != false;
    }

    public void setSearchBulk(RequestContext request, boolean isBulk) {
        request.setAttribute("isSearchBulk", (Object)isBulk);
    }

    boolean isValidateCondition(RequestContext request) {
        return request.getAttribute("isValidateCondition") != null && (Boolean)request.getAttribute("isValidateCondition") != false;
    }

    void setValidateCondition(RequestContext request, boolean check) {
        request.setAttribute("isValidateCondition", (Object)check);
    }

    protected final void search(SearchContext context, Query query) {
        SearchContextBase _context = (SearchContextBase)context;
        ArrayList<String> userOidList = new ArrayList<String>();
        SearchQueryContext sqContext = _context.beforeSearch(query, SearchQueryInterrupter.SearchQueryType.SEACH);
        SearchResult result = null;
        result = sqContext.isDoPrivileged() ? (SearchResult)AuthContext.doPrivileged(() -> this.searchEntity(_context, userOidList, sqContext.getQuery())) : (sqContext.getWithoutConditionReferenceName() != null ? (SearchResult)EntityPermission.doQueryAs((String[])sqContext.getWithoutConditionReferenceName(), () -> this.searchEntity(_context, userOidList, sqContext.getQuery())) : this.searchEntity(_context, userOidList, sqContext.getQuery()));
        context.getRequest().setAttribute("result", (Object)result);
        if (!userOidList.isEmpty()) {
            this.setUserInfoMap(context, userOidList);
        }
    }

    private SearchResult<Entity> searchEntity(final SearchContextBase context, final List<String> userOidList, final Query query) {
        final ArrayList entityList = new ArrayList();
        this.em.searchEntity(query, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                context.afterSearch(query, dataModel, SearchQueryInterrupter.SearchQueryType.SEACH);
                if (context.isUseUserPropertyEditor()) {
                    for (String propertyName : context.getUseUserPropertyEditorPropertyName()) {
                        String oid = (String)dataModel.getValue(propertyName);
                        if (oid == null || userOidList.contains(oid)) continue;
                        userOidList.add(oid);
                    }
                }
                entityList.add(dataModel);
                return true;
            }
        });
        return new SearchResult(0, entityList);
    }

    private void setUserInfoMap(SearchContext context, List<String> userOidList) {
        HashMap<String, Entity> userMap = new HashMap<String, Entity>();
        SearchContextBase searchContextBase = (SearchContextBase)context;
        if (searchContextBase.getForm().isShowUserNameWithPrivilegedValue()) {
            AuthContext.doPrivileged(() -> this.searchUserMap(userMap, userOidList));
        } else {
            this.searchUserMap(userMap, userOidList);
        }
        context.getRequest().setAttribute("userInfoMap", userMap);
    }

    private void searchUserMap(final Map<String, Entity> userMap, List<String> userOidList) {
        Query q = new Query().select(new Object[]{"oid", "name"}).from("mtp.auth.User").where((Condition)new In("oid", userOidList.toArray()));
        this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                if (!userMap.containsKey(dataModel.getOid())) {
                    userMap.put(dataModel.getOid(), dataModel);
                }
                return true;
            }
        });
    }

    protected final void count(SearchContext context, Query query) {
        SearchContextBase _context = (SearchContextBase)context;
        SearchQueryContext sqContext = _context.beforeSearch(query, SearchQueryInterrupter.SearchQueryType.SEACH);
        Integer count = null;
        count = sqContext.isDoPrivileged() ? (Integer)AuthContext.doPrivileged(() -> this.em.count(sqContext.getQuery())) : (sqContext.getWithoutConditionReferenceName() != null ? (Integer)EntityPermission.doQueryAs((String[])sqContext.getWithoutConditionReferenceName(), () -> this.em.count(sqContext.getQuery())) : Integer.valueOf(this.em.count(sqContext.getQuery())));
        context.getRequest().setAttribute("count", (Object)count);
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

