/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.ViewUtil;
import org.iplass.gem.command.common.SearchResultData;
import org.iplass.gem.command.generic.search.SearchContext;
import org.iplass.gem.command.generic.search.SearchQueryInterrupterHandler;
import org.iplass.gem.command.generic.search.handler.CheckPermissionLimitConditionOfEditLinkHandler;
import org.iplass.gem.command.generic.search.handler.CreateSearchResultEvent;
import org.iplass.gem.command.generic.search.handler.CreateSearchResultEventHandler;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.AsOf;
import org.iplass.mtp.entity.query.From;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.NullOrderType;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.SearchFormViewHandler;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.SearchQueryInterrupter;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.view.generic.element.section.SortSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchContextBase
implements SearchContext,
CreateSearchResultEventHandler {
    private static Logger log = LoggerFactory.getLogger(SearchContextBase.class);
    private RequestContext request;
    private EntityDefinition definition;
    private EntityView view;
    private SearchFormView form;
    private Set<String> useUserPropertyEditorPropertyNameList;
    private SearchQueryInterrupterHandler interrupterHandler;
    private List<SearchFormViewHandler> searchFormViewHandlers;
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.manager(EntityViewManager.class);
    private UtilityClassDefinitionManager ucdm = (UtilityClassDefinitionManager)ManagerLocator.manager(UtilityClassDefinitionManager.class);

    @Override
    public RequestContext getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(RequestContext request) {
        this.request = request;
    }

    @Override
    public EntityDefinition getEntityDefinition() {
        return this.definition;
    }

    @Override
    public void setEntityDefinition(EntityDefinition definition) {
        this.definition = definition;
    }

    @Override
    public EntityView getEntityView() {
        return this.view;
    }

    @Override
    public void setEntityView(EntityView view) {
        this.view = view;
    }

    @Override
    public String getDefName() {
        return this.request.getParam("defName");
    }

    @Override
    public Select getSelect() {
        ArrayList<String> select = new ArrayList<String>();
        select.add("oid");
        select.add("name");
        select.add("version");
        if (this.getResultSection().getExclusiveControlPoint() == SearchResultSection.ExclusiveControlPoint.WHEN_SEARCH) {
            select.add("updateDate");
        }
        List<PropertyColumn> properties = this.getColumnProperties();
        for (PropertyColumn propertyColumn : properties) {
            if (!EntityViewUtil.isDisplayElement(this.getDefName(), propertyColumn.getElementRuntimeId(), OutputType.SEARCHRESULT, null)) continue;
            String propName = propertyColumn.getPropertyName();
            if (propertyColumn.getEditor() instanceof ReferencePropertyEditor) {
                List<NestProperty> nest = ((ReferencePropertyEditor)propertyColumn.getEditor()).getNestProperties();
                this.addSearchProperty(select, propName, propertyColumn.getEditor(), nest.toArray(new NestProperty[nest.size()]));
                continue;
            }
            if (propertyColumn.getEditor() instanceof JoinPropertyEditor) {
                JoinPropertyEditor je = (JoinPropertyEditor)propertyColumn.getEditor();
                this.addSearchProperty(select, propName, je.getEditor(), new NestProperty[0]);
                for (NestProperty nest : je.getProperties()) {
                    this.addSearchProperty(select, nest.getPropertyName(), nest.getEditor(), new NestProperty[0]);
                }
                continue;
            }
            if (propertyColumn.getEditor() instanceof RangePropertyEditor) {
                this.addSearchProperty(select, propName, new NestProperty[0]);
                RangePropertyEditor re = (RangePropertyEditor)((Object)propertyColumn.getEditor());
                if (!StringUtil.isNotBlank((String)re.getToPropertyName())) continue;
                this.addSearchProperty(select, re.getToPropertyName(), new NestProperty[0]);
                continue;
            }
            this.addSearchProperty(select, propName, new NestProperty[0]);
        }
        OrderBy orderBy = this.getOrderBy();
        if (orderBy != null) {
            for (SortSpec sortSpec : orderBy.getSortSpecList()) {
                String sortKey = sortSpec.getSortKey().toString();
                if (select.contains(sortKey)) continue;
                this.addSearchProperty(select, sortKey, new NestProperty[0]);
            }
        }
        boolean bl = this.getConditionSection().isDistinct();
        Select s = new Select().add(select.toArray());
        s.setDistinct(bl);
        return s;
    }

    @Override
    public From getFrom() {
        From from = new From(this.getDefName());
        Comparable<Date> specValue = null;
        String paramSpec = this.getRequest().getParam("specVersion");
        if (this.definition.getVersionControlType() != null && StringUtil.isNotBlank((String)paramSpec)) {
            if (VersionControlType.TIMEBASE.equals((Object)this.definition.getVersionControlType()) || VersionControlType.SIMPLE_TIMEBASE.equals((Object)this.definition.getVersionControlType())) {
                specValue = CommandUtil.getTimestamp(paramSpec);
            } else if (VersionControlType.VERSIONED.equals((Object)this.definition.getVersionControlType()) || VersionControlType.STATEBASE.equals((Object)this.definition.getVersionControlType())) {
                specValue = CommandUtil.getLong(paramSpec);
            }
        }
        if (specValue != null) {
            AsOf asof = new AsOf((ValueExpression)new Literal(specValue));
            from.setAsOf(asof);
        }
        return from;
    }

    @Override
    public OrderBy getOrderBy() {
        OrderBy orderBy = null;
        if (this.hasSortSetting()) {
            orderBy = new OrderBy();
            for (SortSetting ss : this.getSortSetting()) {
                String sortKey = ss.getSortKey();
                PropertyDefinition pd = this.getPropertyDefinition(sortKey);
                if (pd instanceof ReferenceProperty) {
                    PropertyColumn property = this.getLayoutPropertyColumn(sortKey);
                    sortKey = property != null ? sortKey + "." + this.getDisplayNestProperty(property) : sortKey + "." + "name";
                }
                SortSpec.SortType type = SortSpec.SortType.valueOf((String)ss.getSortType().name());
                SortSpec.NullOrderingSpec nullOrderingSpec = this.getNullOrderingSpec(ss.getNullOrderType());
                orderBy.add((Object)sortKey, type, nullOrderingSpec);
            }
        } else {
            String sortKey = this.getSortKey();
            if (sortKey != null) {
                if ("oid".equals(sortKey)) {
                    orderBy = new OrderBy();
                    orderBy.add((Object)sortKey, this.getSortType());
                } else {
                    PropertyColumn property = this.getLayoutPropertyColumn(sortKey);
                    if (property != null) {
                        PropertyDefinition pd = this.getPropertyDefinition(sortKey);
                        if (pd instanceof ReferenceProperty) {
                            sortKey = sortKey + "." + this.getDisplayNestProperty(property);
                        }
                        SortSpec.NullOrderingSpec nullOrderingSpec = this.getNullOrderingSpec(property.getNullOrderType());
                        orderBy = new OrderBy();
                        orderBy.add((Object)sortKey, this.getSortType(), nullOrderingSpec);
                    }
                }
            }
        }
        return orderBy;
    }

    @Override
    public Limit getLimit() {
        Limit limit = new Limit(this.getSearchLimit().intValue(), this.getOffset().intValue());
        return limit;
    }

    @Override
    public boolean isVersioned() {
        String allVer = this.getRequest().getParam("allVersion");
        return "1".equals(allVer);
    }

    @Override
    public boolean isSearch() {
        String isSearch = this.getRequest().getParam("isSearch");
        return "true".equals(isSearch);
    }

    @Override
    public boolean isCount() {
        String isCount = this.getRequest().getParam("isCount");
        return "true".equals(isCount);
    }

    @Override
    public boolean validation() {
        return true;
    }

    protected SearchFormView getForm() {
        String viewName = this.getViewName();
        if (this.form == null) {
            this.form = FormViewUtil.getSearchFormView(this.definition, this.view, viewName);
        }
        return this.form;
    }

    protected SearchConditionSection getConditionSection() {
        return this.getForm() != null ? this.getForm().getCondSection() : null;
    }

    protected List<PropertyItem> getLayoutProperties() {
        List filteredList = this.getConditionSection().getElements().stream().filter(e -> e instanceof PropertyItem).map(e -> (PropertyItem)e).collect(Collectors.toList());
        ArrayList<PropertyItem> properties = new ArrayList<PropertyItem>();
        for (PropertyItem property : filteredList) {
            if (property.getEditor() instanceof RangePropertyEditor) {
                RangePropertyEditor editor = (RangePropertyEditor)((Object)property.getEditor());
                PropertyItem from = (PropertyItem)ObjectUtil.deepCopy((Serializable)property);
                properties.add(from);
                PropertyItem to = (PropertyItem)ObjectUtil.deepCopy((Serializable)property);
                to.setPropertyName(editor.getToPropertyName());
                properties.add(to);
                continue;
            }
            properties.add(property);
        }
        return properties;
    }

    protected SearchResultSection getResultSection() {
        return this.getForm() != null ? this.getForm().getResultSection() : null;
    }

    protected List<PropertyColumn> getColumnProperties() {
        List<PropertyColumn> properties = this.getResultSection().getElements().stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).collect(Collectors.toList());
        return properties;
    }

    protected PropertyItem getLayoutProperty(String propName) {
        List<PropertyItem> properties = this.getLayoutProperties();
        Optional<PropertyItem> property = properties.stream().filter(e -> propName.equals(e.getPropertyName())).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    protected PropertyItem getLayoutPropertyForCheck(String propName) {
        List<PropertyItem> properties = this.getLayoutProperties();
        for (PropertyItem property : properties) {
            String condPropName = property.getPropertyName();
            if (StringUtil.isNotEmpty((String)condPropName) && condPropName.contains(".")) {
                condPropName = condPropName.split("\\.")[0];
            }
            if (!propName.equals(condPropName)) continue;
            return property;
        }
        return null;
    }

    protected PropertyColumn getLayoutPropertyColumn(String propName) {
        Optional<PropertyColumn> property = this.getColumnProperties().stream().filter(e -> propName.equals(e.getPropertyName())).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        return null;
    }

    protected List<PropertyDefinition> getPropertyList() {
        return this.definition.getPropertyList();
    }

    protected Condition getDefaultCondition() {
        SearchConditionSection section = this.getConditionSection();
        if (section == null || StringUtil.isEmpty((String)section.getDefaultCondition())) {
            return null;
        }
        return this.evm.getSearchConditionSectionDefaultCondition(this.getDefName(), section);
    }

    protected String getViewName() {
        return this.request.getParam("viewName");
    }

    protected String getSortKey() {
        String sortKey = this.request.getParam("sortKey");
        if (StringUtil.isBlank((String)sortKey)) {
            if (this.getConditionSection().isUnsorted()) {
                return null;
            }
            return "oid";
        }
        PropertyDefinition pd = this.getPropertyDefinition(sortKey);
        if (pd == null) {
            return "oid";
        }
        return sortKey;
    }

    protected SortSpec.SortType getSortType() {
        String sortType = this.request.getParam("sortType");
        if (StringUtil.isBlank((String)sortType)) {
            return SortSpec.SortType.DESC;
        }
        return SortSpec.SortType.valueOf((String)sortType);
    }

    protected SortSpec.NullOrderingSpec getNullOrderingSpec(NullOrderType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case FIRST: {
                return SortSpec.NullOrderingSpec.FIRST;
            }
            case LAST: {
                return SortSpec.NullOrderingSpec.LAST;
            }
        }
        return null;
    }

    protected boolean hasSortSetting() {
        SearchConditionSection section = this.getConditionSection();
        if (section != null) {
            return !section.getSortSetting().isEmpty();
        }
        return false;
    }

    protected List<SortSetting> getSortSetting() {
        SearchConditionSection section;
        PropertyColumn property;
        ArrayList<SortSetting> setting = new ArrayList<SortSetting>();
        String sortKey = this.getRequest().getParam("sortKey");
        if (StringUtil.isNotBlank((String)sortKey) && (property = this.getLayoutPropertyColumn(sortKey)) != null) {
            SortSetting ss = new SortSetting();
            ss.setSortKey(sortKey);
            String sortType = this.getRequest().getParam("sortType");
            if (StringUtil.isBlank((String)sortType)) {
                ss.setSortType(SearchConditionSection.ConditionSortType.DESC);
            } else {
                ss.setSortType(SearchConditionSection.ConditionSortType.valueOf(sortType));
            }
            ss.setNullOrderType(property.getNullOrderType());
            setting.add(ss);
        }
        if ((section = this.getConditionSection()) != null && !section.getSortSetting().isEmpty()) {
            setting.addAll(section.getSortSetting());
        }
        return setting;
    }

    protected String getDisplayNestProperty(PropertyColumn refProp) {
        PropertyEditor editor = refProp.getEditor();
        if (editor instanceof ReferencePropertyEditor && StringUtil.isNotEmpty((String)((ReferencePropertyEditor)editor).getDisplayLabelItem())) {
            return ((ReferencePropertyEditor)editor).getDisplayLabelItem();
        }
        return "name";
    }

    protected Integer getSearchLimit() {
        Integer limit = this.request.getParamAsInt("limit");
        if (limit == null) {
            limit = ViewUtil.getSearchLimit(this.getResultSection());
        }
        return limit;
    }

    protected Integer getOffset() {
        Integer offset = this.request.getParamAsInt("offset");
        if (offset == null) {
            offset = 0;
        }
        return offset;
    }

    protected void addSearchProperty(ArrayList<String> select, String propName, NestProperty ... nest) {
        this.addSearchProperty(select, propName, (PropertyEditor)null, nest);
    }

    protected void addSearchProperty(ArrayList<String> select, String propName, PropertyEditor editor, NestProperty ... nest) {
        PropertyDefinition pd = this.getPropertyDefinition(propName);
        if (pd instanceof ReferenceProperty) {
            if (!select.contains(propName + "." + "name")) {
                select.add(propName + "." + "name");
            }
            if (!select.contains(propName + "." + "oid")) {
                select.add(propName + "." + "oid");
            }
            if (!select.contains(propName + "." + "version")) {
                select.add(propName + "." + "version");
            }
            if (editor instanceof ReferencePropertyEditor) {
                this.addDisplayLabelProperty(select, propName, (ReferencePropertyEditor)editor);
            }
            if (nest != null && nest.length > 0) {
                EntityDefinition red = this.getReferenceEntityDefinition((ReferenceProperty)pd);
                for (NestProperty np : nest) {
                    Object jpe;
                    List<NestProperty> _nest;
                    PropertyDefinition rpd = red.getProperty(np.getPropertyName());
                    if (rpd == null || "oid".equals(np.getPropertyName()) || "name".equals(np.getPropertyName()) || "version".equals(np.getPropertyName())) continue;
                    String nestPropName = propName + "." + np.getPropertyName();
                    if (rpd instanceof ReferenceProperty) {
                        if (!select.contains(nestPropName + "." + "name")) {
                            select.add(nestPropName + "." + "name");
                        }
                        if (!select.contains(nestPropName + "." + "oid")) {
                            select.add(nestPropName + "." + "oid");
                        }
                        if (!select.contains(nestPropName + "." + "version")) {
                            select.add(nestPropName + "." + "version");
                        }
                    } else if (!select.contains(nestPropName)) {
                        select.add(nestPropName);
                    }
                    if (np.getEditor() instanceof ReferencePropertyEditor) {
                        ReferencePropertyEditor rpe = (ReferencePropertyEditor)np.getEditor();
                        if (!rpe.getNestProperties().isEmpty()) {
                            _nest = rpe.getNestProperties();
                            this.addSearchProperty(select, nestPropName, rpe, _nest.toArray(new NestProperty[_nest.size()]));
                        }
                        this.addDisplayLabelProperty(select, nestPropName, rpe);
                        continue;
                    }
                    if (np.getEditor() instanceof JoinPropertyEditor) {
                        jpe = (JoinPropertyEditor)np.getEditor();
                        this.addSearchProperty(select, nestPropName, ((JoinPropertyEditor)jpe).getEditor(), new NestProperty[0]);
                        if (((JoinPropertyEditor)jpe).getProperties().isEmpty()) continue;
                        _nest = ((JoinPropertyEditor)jpe).getProperties();
                        this.addSearchProperty(select, propName, editor, _nest.toArray(new NestProperty[_nest.size()]));
                        continue;
                    }
                    if (!(np.getEditor() instanceof RangePropertyEditor) || (jpe = (RangePropertyEditor)((Object)np.getEditor())).getToPropertyName() == null) continue;
                    select.add(propName + "." + jpe.getToPropertyName());
                }
            }
        } else if (!select.contains(propName)) {
            select.add(propName);
        }
    }

    protected void addDisplayLabelProperty(ArrayList<String> select, String propName, ReferencePropertyEditor rpe) {
        if (rpe.getDisplayLabelItem() == null) {
            return;
        }
        PropertyDefinition pd = this.getPropertyDefinition(propName);
        if (pd instanceof ReferenceProperty && !select.contains(propName + "." + rpe.getDisplayLabelItem())) {
            select.add(propName + "." + rpe.getDisplayLabelItem());
        }
    }

    protected EntityDefinition getReferenceEntityDefinition(ReferenceProperty rp) {
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        return edm.get(rp.getObjectDefinitionName());
    }

    protected PropertyDefinition getPropertyDefinition(String propName) {
        int firstDotIndex = propName.indexOf(46);
        if (firstDotIndex > 0) {
            EntityDefinition red;
            String topPropName = propName.substring(0, firstDotIndex);
            String subPropName = propName.substring(firstDotIndex + 1);
            PropertyDefinition topProperty = this.definition.getProperty(topPropName);
            if (topProperty instanceof ReferenceProperty && (red = this.getReferenceEntityDefinition((ReferenceProperty)topProperty)) != null) {
                EntityDefinition _definition = this.definition;
                this.definition = red;
                PropertyDefinition pd = this.getPropertyDefinition(subPropName);
                this.definition = _definition;
                return pd;
            }
        } else {
            return this.definition.getProperty(propName);
        }
        return null;
    }

    public boolean isUseUserPropertyEditor() {
        Set<String> propNameList = this.getUseUserPropertyEditorPropertyName();
        return !propNameList.isEmpty();
    }

    public Set<String> getUseUserPropertyEditorPropertyName() {
        if (this.useUserPropertyEditorPropertyNameList != null) {
            return this.useUserPropertyEditorPropertyNameList;
        }
        this.useUserPropertyEditorPropertyNameList = new HashSet<String>();
        List<PropertyColumn> properties = this.getColumnProperties();
        for (PropertyColumn property : properties) {
            String propertyName = property.getPropertyName();
            if (property.getEditor() instanceof ReferencePropertyEditor) {
                ReferencePropertyEditor editor = (ReferencePropertyEditor)property.getEditor();
                if (editor.getNestProperties().isEmpty()) continue;
                Set<String> nest = this.getUseUserPropertyEditorNestPropertyName(editor);
                for (String nestPropertyName : nest) {
                    String _nestPropertyName = propertyName + "." + nestPropertyName;
                    this.useUserPropertyEditorPropertyNameList.add(_nestPropertyName);
                }
                continue;
            }
            if (!(property.getEditor() instanceof UserPropertyEditor)) continue;
            this.useUserPropertyEditorPropertyNameList.add(propertyName);
        }
        return this.useUserPropertyEditorPropertyNameList;
    }

    private Set<String> getUseUserPropertyEditorNestPropertyName(ReferencePropertyEditor editor) {
        HashSet<String> ret = new HashSet<String>();
        for (NestProperty property : editor.getNestProperties()) {
            if (property.getEditor() instanceof ReferencePropertyEditor) {
                ReferencePropertyEditor nestEditor = (ReferencePropertyEditor)property.getEditor();
                if (nestEditor.getNestProperties().isEmpty()) continue;
                Set<String> nest = this.getUseUserPropertyEditorNestPropertyName(nestEditor);
                for (String nestPropertyName : nest) {
                    String _nestPropertyName = property.getPropertyName() + "." + nestPropertyName;
                    ret.add(_nestPropertyName);
                }
                continue;
            }
            if (!(property.getEditor() instanceof UserPropertyEditor)) continue;
            ret.add(property.getPropertyName());
        }
        return ret;
    }

    public SearchQueryContext beforeSearch(Query query, SearchQueryInterrupter.SearchQueryType type) {
        return this.getSearchQueryInterrupterHandler().beforeSearch(query, type);
    }

    public void afterSearch(Query query, Entity entity, SearchQueryInterrupter.SearchQueryType type) {
        this.getSearchQueryInterrupterHandler().afterSearch(query, entity, type);
    }

    public SearchQueryInterrupterHandler getSearchQueryInterrupterHandler() {
        if (this.interrupterHandler == null) {
            SearchQueryInterrupter interrupter = this.createInterrupter(this.getForm().getInterrupterName());
            this.interrupterHandler = new SearchQueryInterrupterHandler(this.request, this, interrupter);
        }
        return this.interrupterHandler;
    }

    protected SearchQueryInterrupter createInterrupter(String className) {
        SearchQueryInterrupter interrupter = null;
        if (StringUtil.isNotEmpty((String)className)) {
            if (log.isDebugEnabled()) {
                log.debug("set search query interrupter. class=" + className);
            }
            try {
                interrupter = (SearchQueryInterrupter)this.ucdm.createInstanceAs(SearchQueryInterrupter.class, className);
            }
            catch (ClassNotFoundException e) {
                log.error(className + " can not instantiate.", (Throwable)e);
                throw new EntityRuntimeException(SearchContextBase.resourceString("command.generic.detail.DetailCommandContext.internalErr", new Object[0]));
            }
        }
        if (interrupter == null) {
            if (log.isDebugEnabled()) {
                log.debug("set defaul search query interrupter.");
            }
            interrupter = this.getDefaultSearchQueryInterrupter();
        }
        return interrupter;
    }

    protected SearchQueryInterrupter getDefaultSearchQueryInterrupter() {
        return new SearchQueryInterrupter(){};
    }

    @Override
    public void fireCreateSearchResultEvent(SearchResultData result) {
        CreateSearchResultEvent event = new CreateSearchResultEvent(this.getRequest(), this.getDefName(), this.getViewName(), result);
        for (SearchFormViewHandler handler : this.getSearchFormViewHandlers()) {
            handler.onCreateSearchResult(event);
        }
    }

    private List<SearchFormViewHandler> getSearchFormViewHandlers() {
        if (this.searchFormViewHandlers == null) {
            this.searchFormViewHandlers = new ArrayList<SearchFormViewHandler>();
            if (this.getForm().getSearchFormViewHandlerName() != null) {
                for (String handlerClassName : this.getForm().getSearchFormViewHandlerName()) {
                    this.searchFormViewHandlers.add(this.createSearchFormViewHandler(handlerClassName));
                }
            }
            if (!this.getResultSection().isHideDetailLink() && this.getResultSection().isCheckEntityPermissionLimitConditionOfEditLink()) {
                if (log.isDebugEnabled()) {
                    log.debug("add CheckUpdateConditionOfEditLinkHandler to the first of search form view handler.");
                }
                this.searchFormViewHandlers.add(0, new CheckPermissionLimitConditionOfEditLinkHandler());
            }
        }
        return this.searchFormViewHandlers;
    }

    private SearchFormViewHandler createSearchFormViewHandler(String handlerClassName) {
        SearchFormViewHandler handler = null;
        if (StringUtil.isNotEmpty((String)handlerClassName)) {
            if (log.isDebugEnabled()) {
                log.debug("create search form view handler. class=" + handlerClassName);
            }
            try {
                handler = (SearchFormViewHandler)this.ucdm.createInstanceAs(SearchFormViewHandler.class, handlerClassName);
            }
            catch (ClassNotFoundException e) {
                log.error(handlerClassName + " can not instantiate.", (Throwable)e);
                throw new EntityRuntimeException(SearchContextBase.resourceString("command.generic.detail.DetailCommandContext.internalErr", new Object[0]));
            }
        }
        return handler;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

