/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.io.IOException;
import javax.servlet.ServletException;
import org.iplass.gem.command.CreateSearchResultUtil;
import org.iplass.gem.command.common.SearchResultData;
import org.iplass.gem.command.generic.search.SearchListContext;
import org.iplass.gem.command.generic.search.SearchListPartsCommandBase;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterManager;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/search/list", displayName="Entity\u4e00\u89a7\u691c\u7d22(\u30d1\u30fc\u30c4)", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"count", "htmlData"}, checkXRequestedWithHeader=true)
@Template(name="gem/generic/search/list", displayName="\u691c\u7d22\u7d50\u679c\u30d1\u30fc\u30c4", path="/jsp/gem/generic/search/list.jsp")
@CommandClass(name="gem/generic/search/SearchListCommand", displayName="Entity\u4e00\u89a7\u691c\u7d22(\u30d1\u30fc\u30c4)")
public final class SearchListCommand
extends SearchListPartsCommandBase {
    public static final String WEBAPI_NAME = "gem/generic/search/list";
    public static final String RESULT_PARAM_COUNT = "count";
    public static final String RESULT_PARAM_HTML_DATA = "htmlData";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    private EntityFilterManager efm = (EntityFilterManager)ManagerLocator.getInstance().getManager(EntityFilterManager.class);

    public String execute(RequestContext request) {
        SearchListContext context = new SearchListContext();
        context.setRequest(request);
        context.setEntityDefinition(this.edm.get(context.getDefName()));
        context.setEntityView((EntityView)this.evm.get(context.getDefName()));
        context.setFilter((EntityFilter)this.efm.get(context.getDefName()));
        Query query = this.toQuery(context);
        int count = this.count(context, query.copy());
        request.setAttribute(RESULT_PARAM_COUNT, (Object)count);
        query.setOrderBy(context.getOrderBy());
        query.setLimit(context.getLimit());
        SearchResult<Entity> result = this.search(context, query);
        try {
            SearchResultData resultData = CreateSearchResultUtil.getResultData(result.getList(), context.getEntityDefinition(), context.getResultSection(), context.getViewName());
            context.fireCreateSearchResultEvent(resultData);
            request.setAttribute(RESULT_PARAM_HTML_DATA, resultData.toResponse());
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
        catch (ServletException e) {
            throw new SystemException((Throwable)e);
        }
        return "SUCCESS";
    }
}

