/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.SyntaxService;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QuerySyntaxRegister;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterItem;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.element.section.SortSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchListContext
extends SearchContextBase {
    private static Logger logger = LoggerFactory.getLogger(SearchListContext.class);
    private EntityFilter filter;

    public void setFilter(EntityFilter filter) {
        this.filter = filter;
    }

    private EntityFilterItem getFilterItem() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getItem(this.getRequest().getParam("filterName"));
    }

    @Override
    public Where getWhere() {
        Condition defaultCond;
        Where where = new Where();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        EntityFilterItem filter = this.getFilterItem();
        if (filter != null && filter.getCondition() != null) {
            conditions.add(new PreparedQuery(filter.getCondition()).condition(null));
        }
        if ((defaultCond = this.getDefaultCondition()) != null && (filter == null || filter != null && this.getConditionSection().isUseDefaultConditionWithFilterDefinition())) {
            conditions.add(defaultCond);
        }
        if (!conditions.isEmpty()) {
            And and = new And(conditions);
            where.setCondition((Condition)and);
        }
        return where;
    }

    @Override
    public OrderBy getOrderBy() {
        String sortKey = this.getRequest().getParam("sortKey");
        String sortType = this.getRequest().getParam("sortType");
        EntityFilterItem filter = this.getFilterItem();
        OrderBy orderBy = null;
        if (StringUtil.isNotBlank((String)sortKey)) {
            PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(sortKey, this.getEntityDefinition());
            String propName = sortKey;
            if (pd instanceof ReferenceProperty) {
                propName = sortKey + "." + "oid";
            }
            orderBy = StringUtil.isBlank((String)sortType) ? new OrderBy().add(new SortSpec(propName, SortSpec.SortType.DESC)) : new OrderBy().add(new SortSpec(propName, SortSpec.SortType.valueOf((String)sortType)));
        } else if (filter != null && StringUtil.isNotBlank((String)filter.getSort())) {
            SyntaxService service = (SyntaxService)ServiceRegistry.getRegistry().getService(SyntaxService.class);
            OrderBySyntax syntax = (OrderBySyntax)service.getSyntaxContext(QuerySyntaxRegister.QUERY_CONTEXT).getSyntax(OrderBySyntax.class);
            ParseContext context = new ParseContext("order by " + filter.getSort());
            try {
                orderBy = syntax.parse(context);
            }
            catch (ParseException e) {
                throw new SystemException(e.getMessage(), (Throwable)e);
            }
        } else if (this.hasSortSetting()) {
            List<SortSetting> setting = this.getSortSetting();
            for (SortSetting ss : setting) {
                if (ss.getSortKey() == null) continue;
                String key = null;
                PropertyDefinition pd = this.getPropertyDefinition(ss.getSortKey());
                key = pd instanceof ReferenceProperty ? ss.getSortKey() + "." + "oid" : ss.getSortKey();
                SortSpec.SortType type = SortSpec.SortType.valueOf((String)ss.getSortType().name());
                SortSpec.NullOrderingSpec nullOrderingSpec = this.getNullOrderingSpec(ss.getNullOrderType());
                if (orderBy == null) {
                    orderBy = new OrderBy();
                }
                orderBy.add((Object)key, type, nullOrderingSpec);
            }
        } else {
            orderBy = new OrderBy().add(new SortSpec("updateDate", SortSpec.SortType.DESC));
        }
        return orderBy;
    }

    @Override
    protected Integer getOffset() {
        int offset;
        String topViewListOffset;
        block3: {
            String _offset = this.getRequest().getParam("offset");
            topViewListOffset = this.getRequest().getParam("topViewListOffset");
            offset = 0;
            try {
                offset = Integer.parseInt(_offset);
            }
            catch (NumberFormatException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("parse number faild.", (Throwable)e);
            }
        }
        if (StringUtil.isNotEmpty((String)topViewListOffset)) {
            offset = Integer.parseInt(topViewListOffset);
        }
        return offset;
    }

    @Override
    public boolean checkParameter() {
        return true;
    }
}

