/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.gem.command.generic.search.SearchContext;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.view.generic.SearchQueryContext;
import org.iplass.mtp.view.generic.SearchQueryInterrupter;

public abstract class SearchListPartsCommandBase
implements Command {
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    protected Query toQuery(SearchContext context) {
        Query query = new Query();
        query.setSelect(context.getSelect());
        query.setFrom(context.getFrom());
        query.setWhere(context.getWhere());
        query.setVersiond(context.isVersioned());
        return query;
    }

    protected int count(SearchContext context, Query query) {
        SearchContextBase _context = (SearchContextBase)context;
        SearchQueryContext sqContext = _context.beforeSearch(query, SearchQueryInterrupter.SearchQueryType.SEACH);
        if (sqContext.isDoPrivileged()) {
            return (Integer)AuthContext.doPrivileged(() -> this.em.count(sqContext.getQuery()));
        }
        if (sqContext.getWithoutConditionReferenceName() != null) {
            return (Integer)EntityPermission.doQueryAs((String[])sqContext.getWithoutConditionReferenceName(), () -> this.em.count(sqContext.getQuery()));
        }
        return this.em.count(sqContext.getQuery());
    }

    protected SearchResult<Entity> search(SearchContext context, Query query) {
        SearchContextBase _context = (SearchContextBase)context;
        ArrayList<String> userOidList = new ArrayList<String>();
        SearchQueryContext sqContext = _context.beforeSearch(query, SearchQueryInterrupter.SearchQueryType.SEACH);
        SearchResult result = null;
        result = sqContext.isDoPrivileged() ? (SearchResult)AuthContext.doPrivileged(() -> this.searchEntity(_context, userOidList, sqContext.getQuery())) : (sqContext.getWithoutConditionReferenceName() != null ? (SearchResult)EntityPermission.doQueryAs((String[])sqContext.getWithoutConditionReferenceName(), () -> this.searchEntity(_context, userOidList, sqContext.getQuery())) : this.searchEntity(_context, userOidList, sqContext.getQuery()));
        if (!userOidList.isEmpty()) {
            if (_context.getForm().isShowUserNameWithPrivilegedValue()) {
                AuthContext.doPrivileged(() -> this.setUserInfoMap(context, userOidList));
            } else {
                this.setUserInfoMap(context, userOidList);
            }
        }
        return result;
    }

    protected SearchResult<Entity> searchEntity(final SearchContextBase context, final List<String> userOidList, final Query query) {
        final ArrayList entityList = new ArrayList();
        this.em.searchEntity(query, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                context.afterSearch(query, dataModel, SearchQueryInterrupter.SearchQueryType.SEACH);
                if (context.isUseUserPropertyEditor()) {
                    for (String propertyName : context.getUseUserPropertyEditorPropertyName()) {
                        String oid = (String)dataModel.getValue(propertyName);
                        if (oid == null || userOidList.contains(oid)) continue;
                        userOidList.add(oid);
                    }
                }
                entityList.add(dataModel);
                return true;
            }
        });
        return new SearchResult(0, entityList);
    }

    protected void setUserInfoMap(SearchContext context, List<String> userOidList) {
        final HashMap userMap = new HashMap();
        Query q = new Query().select(new Object[]{"oid", "name"}).from("mtp.auth.User").where((Condition)new In("oid", userOidList.toArray()));
        this.em.searchEntity(q, (Predicate)new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                if (!userMap.containsKey(dataModel.getOid())) {
                    userMap.put(dataModel.getOid(), dataModel);
                }
                return true;
            }
        });
        context.getRequest().setAttribute("userInfoMap", userMap);
    }
}

