/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.SyntaxService;
import org.iplass.mtp.impl.query.OrderBySyntax;
import org.iplass.mtp.impl.query.QuerySyntaxRegister;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterItem;
import org.iplass.mtp.view.generic.element.section.SortSetting;

public class SearchNameListContext
extends SearchContextBase {
    private EntityFilter filter;

    public void setFilter(EntityFilter filter) {
        this.filter = filter;
    }

    private EntityFilterItem getFilterItem() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getItem(this.getRequest().getParam("filterName"));
    }

    @Override
    public Select getSelect() {
        Select select = new Select();
        select.add(new Object[]{"oid", "name", "version"});
        return select;
    }

    @Override
    public Where getWhere() {
        Condition defaultCond;
        Where where = new Where();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        EntityFilterItem filter = this.getFilterItem();
        if (filter != null && filter.getCondition() != null) {
            conditions.add(new PreparedQuery(filter.getCondition()).condition(null));
        }
        if ((defaultCond = this.getDefaultCondition()) != null && (filter == null || filter != null && this.getConditionSection().isUseDefaultConditionWithFilterDefinition())) {
            conditions.add(defaultCond);
        }
        if (!conditions.isEmpty()) {
            And and = new And(conditions);
            where.setCondition((Condition)and);
        }
        return where;
    }

    @Override
    public OrderBy getOrderBy() {
        EntityFilterItem filter = this.getFilterItem();
        OrderBy orderBy = null;
        if (filter != null && StringUtil.isNotBlank((String)filter.getSort())) {
            SyntaxService service = (SyntaxService)ServiceRegistry.getRegistry().getService(SyntaxService.class);
            OrderBySyntax syntax = (OrderBySyntax)service.getSyntaxContext(QuerySyntaxRegister.QUERY_CONTEXT).getSyntax(OrderBySyntax.class);
            ParseContext context = new ParseContext("order by " + filter.getSort());
            try {
                orderBy = syntax.parse(context);
            }
            catch (ParseException e) {
                throw new SystemException(e.getMessage(), (Throwable)e);
            }
        } else if (this.hasSortSetting()) {
            List<SortSetting> setting = this.getSortSetting();
            for (SortSetting ss : setting) {
                if (ss.getSortKey() == null) continue;
                String key = null;
                PropertyDefinition pd = this.getPropertyDefinition(ss.getSortKey());
                key = pd instanceof ReferenceProperty ? ss.getSortKey() + "." + "oid" : ss.getSortKey();
                SortSpec.SortType type = SortSpec.SortType.valueOf((String)ss.getSortType().name());
                SortSpec.NullOrderingSpec nullOrderingSpec = this.getNullOrderingSpec(ss.getNullOrderType());
                if (orderBy == null) {
                    orderBy = new OrderBy();
                }
                orderBy.add((Object)key, type, nullOrderingSpec);
            }
        } else {
            orderBy = new OrderBy().add(new SortSpec("updateDate", SortSpec.SortType.DESC));
        }
        return orderBy;
    }

    @Override
    public boolean checkParameter() {
        return true;
    }

    @Override
    public boolean isUseUserPropertyEditor() {
        return false;
    }
}

