/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.ArrayList;
import org.iplass.gem.command.generic.search.SearchCommandBase;
import org.iplass.gem.command.generic.search.SearchContext;
import org.iplass.gem.command.generic.search.SearchContextBase;
import org.iplass.gem.command.generic.search.SearchSelectListContext;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.CommandInvoker;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/search/searchSelectList", displayName="\u9078\u629e\u5bfe\u8c61\u691c\u7d22", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, results={"data"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/generic/search/SearchSelectListCommand", displayName="\u9078\u629e\u5bfe\u8c61")
public final class SearchSelectListCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/search/searchSelectList";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(RequestContext request) {
        String searchType = request.getParam("searchType");
        SearchCommandBase command = null;
        CommandInvoker ci = (CommandInvoker)ManagerLocator.getInstance().getManager(CommandInvoker.class);
        if ("normal".equals(searchType)) {
            command = (SearchCommandBase)ci.getCommandInstance("gem/generic/search/NormalSearchCommand");
        } else if ("detail".equals(searchType)) {
            command = (SearchCommandBase)ci.getCommandInstance("gem/generic/search/DetailSearchCommand");
        } else if ("fixed".equals(searchType)) {
            command = (SearchCommandBase)ci.getCommandInstance("gem/generic/search/FixedSearchCommand");
        }
        if (command == null) throw new IllegalArgumentException("invalid search type. value=" + searchType);
        WrappedSearchCommand wrapped = new WrappedSearchCommand(command);
        String ret = wrapped.execute(request);
        if ("SUCCESS".equals(ret)) {
            SearchResult result = (SearchResult)request.getAttribute("result");
            if (result == null) return "SUCCESS";
            ArrayList data = new ArrayList();
            result.getList().stream().forEach(e -> data.add(e.getOid() + "_" + e.getVersion()));
            request.setAttribute("data", data);
            return "SUCCESS";
        } else {
            if ("ERROR_PARAMETER".equals(ret)) {
                return "ERROR_PARAMETER";
            }
            if ("ERROR_VALIDATE".equals(ret)) {
                return "ERROR_VALIDATE";
            }
            if ("ERROR_SEARCH".equals(ret)) {
                return "ERROR_SEARCH";
            }
            String message = (String)request.getAttribute("message");
            throw new ApplicationException(message);
        }
    }

    private class WrappedSearchCommand
    extends SearchCommandBase {
        private SearchCommandBase command;

        public WrappedSearchCommand(SearchCommandBase command) {
            this.command = command;
        }

        @Override
        protected Class<? extends SearchContext> getContextClass() {
            return this.command.getContextClass();
        }

        @Override
        public SearchContext getContext(RequestContext request) {
            SearchContext context = this.command.getContext(request);
            return new SearchSelectListContext((SearchContextBase)context);
        }
    }
}

