/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.SearchFormViewData;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ActionMappings;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.filter.EntityFilter;
import org.iplass.mtp.view.filter.EntityFilterManager;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMappings(value={@ActionMapping(name="gem/generic/search/view", displayName="\u691c\u7d22\u753b\u9762\u8868\u793a", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.TEMPLATE, value="gem/generic/search/search"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/defaultLayout")}), @ActionMapping(name="gem/generic/search/ref/view", displayName="\u9078\u629e\u753b\u9762\u8868\u793a", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.JSP, value="/jsp/gem/generic/search/select.jsp", templateName="gem/generic/search/select", layoutActionName="gem/layout/popupLayout"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/popupLayout")})})
@CommandClass(name="gem/generic/search/SearchviewCommand", displayName="\u691c\u7d22\u753b\u9762\u8868\u793a")
@Template(name="gem/generic/search/search", path="/jsp/gem/generic/search/search.jsp", layoutActionName="gem/layout/defaultLayout")
public final class SearchViewCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(SearchViewCommand.class);
    public static final String SEARCH_ACTION_NAME = "gem/generic/search/view";
    public static final String SELECT_ACTION_NAME = "gem/generic/search/ref/view";

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        EntityFilterManager efm = (EntityFilterManager)ManagerLocator.getInstance().getManager(EntityFilterManager.class);
        EntityDefinition entityDefinition = edm.get(defName);
        EntityView entityView = (EntityView)evm.get(defName);
        EntityFilter entityFilter = (EntityFilter)efm.get(defName);
        String viewName = request.getParam("viewName");
        SearchFormView view = FormViewUtil.getSearchFormView(entityDefinition, entityView, viewName);
        evm.checkState(defName);
        if (view == null) {
            request.setAttribute("message", (Object)SearchViewCommand.resourceString("command.generic.search.SearchViewCommand.viewErr", new Object[0]));
            return "ERROR_VIEW";
        }
        SearchFormViewData data = new SearchFormViewData();
        data.setEntityDefinition(entityDefinition);
        data.setView(view);
        if (entityFilter != null) {
            data.setFilters(entityFilter.getItems());
        }
        Map<String, Object> defaultSearchCond = new HashMap<String, Object>();
        this.applyCommonParam(request, defaultSearchCond, view);
        List<PropertyItem> properties = view.getCondSection().getElements().stream().filter(e -> e instanceof PropertyItem).map(e -> (PropertyItem)e).collect(Collectors.toList());
        this.applyNormalSearchCond(request, defaultSearchCond, properties);
        this.applyDetailSearchCond(request, defaultSearchCond, view.getCondSection().getConditionDispCount());
        this.applyFixedSearchCond(request, defaultSearchCond);
        defaultSearchCond = evm.applyDefaultPropertyCondition(defName, viewName, defaultSearchCond);
        request.setAttribute("defaultSearchCond", defaultSearchCond);
        request.setAttribute("data", (Object)data);
        return "SUCCESS";
    }

    private void applyCommonParam(RequestContext request, Map<String, Object> defaultSearchCond, SearchFormView view) {
        String es;
        String searchType = request.getParam("searchType");
        if (StringUtil.isNotBlank((String)searchType)) {
            if ("detail".equals(searchType) && view.getCondSection().isHideDetailCondition()) {
                searchType = "normal";
            } else if ("fixed".equals(searchType) && view.getCondSection().isHideFixedCondition()) {
                searchType = "normal";
            }
            defaultSearchCond.put("searchType", searchType);
        }
        if (StringUtil.isNotBlank((String)(es = request.getParam("es"))) && "t".equals(es)) {
            defaultSearchCond.put("es", "t");
        }
    }

    private void applyNormalSearchCond(RequestContext request, Map<String, Object> defaultSearchCond, List<PropertyItem> properties) {
        for (PropertyItem property : properties) {
            ReferencePropertyEditor editor;
            if (property.isBlank()) continue;
            String[] val = request.getParams("sc_" + property.getPropertyName());
            if (val != null && val.length > 0) {
                defaultSearchCond.put(property.getPropertyName(), val);
            }
            if (!(property.getEditor() instanceof ReferencePropertyEditor) || (editor = (ReferencePropertyEditor)property.getEditor()).getNestProperties().isEmpty()) continue;
            this.setNestCondition(request, defaultSearchCond, editor, property.getPropertyName());
        }
    }

    private void setNestCondition(RequestContext request, Map<String, Object> defaultSearchCond, ReferencePropertyEditor editor, String parent) {
        for (NestProperty nest : editor.getNestProperties()) {
            String name = parent + "." + nest.getPropertyName();
            String[] val = request.getParams("sc_" + name);
            if (val != null && val.length > 0) {
                defaultSearchCond.put(name, val);
            }
            if (!(nest.getEditor() instanceof ReferencePropertyEditor) || ((ReferencePropertyEditor)nest.getEditor()).getNestProperties().isEmpty()) continue;
            this.setNestCondition(request, defaultSearchCond, (ReferencePropertyEditor)nest.getEditor(), name);
        }
    }

    private void applyDetailSearchCond(RequestContext request, Map<String, Object> defaultSearchCond, int condCount) {
        String expression;
        Integer count;
        block9: {
            count = null;
            String dtlCondCount = request.getParam("dtlCndCount");
            if (StringUtil.isNotBlank((String)dtlCondCount)) {
                try {
                    count = Integer.parseInt(dtlCondCount);
                    defaultSearchCond.put("dtlCndCount", dtlCondCount);
                }
                catch (NumberFormatException e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (count == null) {
            count = condCount;
        }
        for (int i = 0; i < count; ++i) {
            String vlKey;
            String vlValue;
            String prdcKey;
            String prdcValue;
            String nmKey = "dtlCndPropNm_" + i;
            String nmValue = request.getParam(nmKey);
            if (StringUtil.isNotBlank((String)nmValue)) {
                defaultSearchCond.put(nmKey, nmValue);
            }
            if (StringUtil.isNotBlank((String)(prdcValue = request.getParam(prdcKey = "dtlCndPrdct_" + i)))) {
                defaultSearchCond.put(prdcKey, prdcValue);
            }
            if (!StringUtil.isNotBlank((String)(vlValue = request.getParam(vlKey = "dtlCndVl_" + i)))) continue;
            defaultSearchCond.put(vlKey, vlValue);
        }
        String expr = request.getParam("dtlCndExpr");
        if (StringUtil.isNotBlank((String)expr)) {
            defaultSearchCond.put("dtlCndExpr", expr);
        }
        if (StringUtil.isNotBlank((String)(expression = request.getParam("dtlCndFilterExpression")))) {
            defaultSearchCond.put("dtlCndFilterExpression", expression);
        }
    }

    private void applyFixedSearchCond(RequestContext request, Map<String, Object> defaultSearchCond) {
        String filterName = request.getParam("filterName");
        if (StringUtil.isNotBlank((String)filterName)) {
            defaultSearchCond.put("filterName", filterName);
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

