/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.BooleanPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.web.template.TemplateUtil;

public class BooleanPropertySearchCondition
extends PropertySearchCondition {
    public BooleanPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public BooleanPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    protected Object convertDetailValue(SearchConditionDetail detail) {
        if ("NotNull".equals(detail.getPredicate()) || "Null".equals(detail.getPredicate())) {
            return null;
        }
        if ("In".equals(detail.getPredicate())) {
            StrTokenizer st = StrTokenizer.getCSVInstance((String)detail.getValue());
            String[] values = st.getTokenArray();
            Boolean[] ret = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = this.string2Boolean(values[i]);
            }
            return ret;
        }
        return this.string2Boolean(detail.getValue());
    }

    private boolean string2Boolean(String str) {
        if (StringUtil.isBlank((String)str)) {
            return false;
        }
        if ("true".equals(str.toLowerCase())) {
            return true;
        }
        if ("false".equals(str.toLowerCase())) {
            return false;
        }
        BooleanPropertyEditor editor = this.getEditor();
        String trueLabel = TemplateUtil.getMultilingualString((String)editor.getTrueLabel(), editor.getLocalizedTrueLabelList());
        return StringUtil.isNotBlank((String)trueLabel) ? trueLabel.equals(str) : StringUtil.isNotBlank((String)(trueLabel = TemplateUtil.getMultilingualString((String)GemResourceBundleUtil.resourceString("generic.editor.boolean.BooleanPropertyEditor_Condition.enable", new Object[0]), GemResourceBundleUtil.resourceList("generic.editor.boolean.BooleanPropertyEditor_Condition.enable", new Object[0])))) && trueLabel.equals(str);
    }

    @Override
    public BooleanPropertyEditor getEditor() {
        return (BooleanPropertyEditor)super.getEditor();
    }
}

