/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class DatePropertySearchCondition
extends PropertySearchCondition {
    public DatePropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public DatePropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Date[] d = (Date[])this.getValue();
        if (this.getEditor().isSingleDayCondition()) {
            if (d.length > 0 && d[0] != null) {
                conditions.add((Condition)new Equals(this.getPropertyName(), (Object)d[0]));
            }
        } else {
            Date from = null;
            Date to = null;
            if (d.length > 0 && d[0] != null) {
                from = d[0];
            }
            if (d.length > 1 && d[1] != null) {
                to = d[1];
            }
            if (from != null && to != null) {
                conditions.add((Condition)new Between(this.getPropertyName(), (Object)from, (Object)to));
            } else if (from != null && to == null) {
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)from));
            } else if (from == null && to != null) {
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)to));
            }
        }
        return conditions;
    }

    @Override
    protected Object convertDetailValue(SearchConditionDetail detail) {
        if ("NotNull".equals(detail.getPredicate()) || "Null".equals(detail.getPredicate())) {
            return null;
        }
        if ("In".equals(detail.getPredicate())) {
            StrTokenizer st = StrTokenizer.getCSVInstance((String)detail.getValue());
            String[] values = st.getTokenArray();
            Date[] ret = new Date[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = CommandUtil.getDate(values[i]);
            }
            return ret;
        }
        return CommandUtil.getDate(detail.getValue());
    }

    @Override
    public DatePropertyEditor getEditor() {
        return (DatePropertyEditor)super.getEditor();
    }
}

