/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.view.generic.editor.DecimalPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class DecimalPropertySearchCondition
extends PropertySearchCondition {
    public DecimalPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public DecimalPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        BigDecimal[] decimal = (BigDecimal[])this.getValue();
        if (this.getEditor().isSearchInRange()) {
            BigDecimal from = null;
            BigDecimal to = null;
            if (decimal.length > 0 && decimal[0] != null) {
                from = decimal[0];
            }
            if (decimal.length > 1 && decimal[1] != null) {
                to = decimal[1];
            }
            if (from != null && to != null) {
                conditions.add((Condition)new Between(this.getPropertyName(), (Object)from, (Object)to));
            } else if (from != null && to == null) {
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)from));
            } else if (from == null && to != null) {
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)to));
            }
        } else if (decimal.length > 0 && decimal[0] != null) {
            conditions.add((Condition)new Equals(this.getPropertyName(), (Object)decimal[0]));
        }
        return conditions;
    }

    @Override
    public DecimalPropertyEditor getEditor() {
        return (DecimalPropertyEditor)super.getEditor();
    }
}

