/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.condition.BooleanPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.DatePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.DecimalPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.FloatPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.IntegerPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.SelectPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.StringPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.TimePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.TimestampPropertySearchCondition;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.view.generic.editor.BooleanPropertyEditor;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.DecimalPropertyEditor;
import org.iplass.mtp.view.generic.editor.ExpressionPropertyEditor;
import org.iplass.mtp.view.generic.editor.FloatPropertyEditor;
import org.iplass.mtp.view.generic.editor.IntegerPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.editor.StringPropertyEditor;
import org.iplass.mtp.view.generic.editor.TimePropertyEditor;
import org.iplass.mtp.view.generic.editor.TimestampPropertyEditor;
import org.iplass.mtp.web.template.TemplateUtil;

public class ExpressionPropertySearchCondition
extends PropertySearchCondition {
    private String parent;

    public ExpressionPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public ExpressionPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
        this.parent = parent;
    }

    @Override
    public List<Condition> convertNormalCondition() {
        PropertyEditor editor;
        ExpressionProperty ep = (ExpressionProperty)this.getDefinition();
        ExpressionSearchConditionType type = ExpressionSearchConditionType.createSearchCondition(ep, editor = ((ExpressionPropertyEditor)this.getEditor()).getEditor());
        if (type == ExpressionSearchConditionType.EXPRESSION) {
            ArrayList<Condition> ret = new ArrayList<Condition>();
            String val = null;
            if (this.getValue() instanceof String[]) {
                val = ((String[])this.getValue())[0];
            } else if (this.getValue() instanceof String) {
                val = (String)this.getValue();
            }
            if (val != null && !val.isEmpty()) {
                ret.add((Condition)new Equals(this.getPropertyName(), (Object)val));
            }
            return ret;
        }
        Object value = this.getNormalTypeValue(type);
        PropertySearchCondition searchCondition = this.createSearchCondition(type, value);
        if (searchCondition != null) {
            return searchCondition.convertNormalCondition();
        }
        return new ArrayList<Condition>();
    }

    @Override
    public List<Condition> convertDetailCondition() {
        PropertySearchCondition searchCondition;
        PropertyEditor editor;
        ExpressionProperty ep = (ExpressionProperty)this.getDefinition();
        ExpressionSearchConditionType type = ExpressionSearchConditionType.createSearchCondition(ep, editor = ((ExpressionPropertyEditor)this.getEditor()).getEditor());
        if (type != ExpressionSearchConditionType.EXPRESSION && (searchCondition = this.createSearchCondition(type, this.getValue())) != null) {
            return searchCondition.convertDetailCondition();
        }
        return super.convertDetailCondition();
    }

    private PropertySearchCondition createSearchCondition(ExpressionSearchConditionType type, Object value) {
        if (value == null) {
            return null;
        }
        PropertyEditor editor = ((ExpressionPropertyEditor)this.getEditor()).getEditor();
        if (type == ExpressionSearchConditionType.BOOLEAN) {
            return new BooleanPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.DATE) {
            return new DatePropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.DATETIME) {
            return new TimestampPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.DECIMAL) {
            return new DecimalPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.FLOAT) {
            return new FloatPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.INTEGER) {
            return new IntegerPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.SELECT) {
            return new SelectPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.STRING) {
            return new StringPropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        if (type == ExpressionSearchConditionType.TIME) {
            return new TimePropertySearchCondition(this.getDefinition(), editor, value, this.parent);
        }
        return null;
    }

    private Object getNormalTypeValue(ExpressionSearchConditionType type) {
        PropertyEditor editor = ((ExpressionPropertyEditor)this.getEditor()).getEditor();
        if (type == ExpressionSearchConditionType.BOOLEAN) {
            String value = (String)this.getValue();
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            return Boolean.parseBoolean((String)this.getValue());
        }
        if (type == ExpressionSearchConditionType.DATE) {
            Date[] dateArray;
            String[] value = (String[])this.getValue();
            Date from = null;
            Date to = null;
            if (value.length > 1 && value[1] != null) {
                from = (Date)ConvertUtil.convertToDate(Date.class, (Object)value[1], (String)TemplateUtil.getLocaleFormat().getServerDateFormat(), (boolean)false);
            }
            if (value.length > 2 && value[2] != null) {
                to = (Date)ConvertUtil.convertToDate(Date.class, (Object)value[2], (String)TemplateUtil.getLocaleFormat().getServerDateFormat(), (boolean)false);
            }
            if (from == null && to == null) {
                dateArray = null;
            } else {
                Date[] dateArray2 = new Date[2];
                dateArray2[0] = from;
                dateArray = dateArray2;
                dateArray2[1] = to;
            }
            return dateArray;
        }
        if (type == ExpressionSearchConditionType.DATETIME) {
            Timestamp[] timestampArray;
            String[] value = (String[])this.getValue();
            Timestamp from = null;
            Timestamp to = null;
            if (value.length > 1 && value[1] != null) {
                from = (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)value[1], (String)TemplateUtil.getLocaleFormat().getServerDateTimeFormat(), (boolean)false);
            }
            if (value.length > 2 && value[2] != null) {
                to = (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)value[2], (String)TemplateUtil.getLocaleFormat().getServerDateTimeFormat(), (boolean)false);
            }
            if (from == null && to == null) {
                timestampArray = null;
            } else {
                Timestamp[] timestampArray2 = new Timestamp[2];
                timestampArray2[0] = from;
                timestampArray = timestampArray2;
                timestampArray2[1] = to;
            }
            return timestampArray;
        }
        if (type == ExpressionSearchConditionType.DECIMAL) {
            BigDecimal[] bigDecimalArray;
            String[] value = (String[])this.getValue();
            BigDecimal from = null;
            BigDecimal to = null;
            if (value.length > 0 && value[0] != null) {
                from = (BigDecimal)ConvertUtil.convertFromString(BigDecimal.class, (String)value[0]);
            }
            if (value.length > 1 && value[1] != null) {
                to = (BigDecimal)ConvertUtil.convertFromString(BigDecimal.class, (String)value[1]);
            }
            if (from == null && to == null) {
                bigDecimalArray = null;
            } else {
                BigDecimal[] bigDecimalArray2 = new BigDecimal[2];
                bigDecimalArray2[0] = from;
                bigDecimalArray = bigDecimalArray2;
                bigDecimalArray2[1] = to;
            }
            return bigDecimalArray;
        }
        if (type == ExpressionSearchConditionType.FLOAT) {
            Double[] doubleArray;
            String[] value = (String[])this.getValue();
            Double from = null;
            Double to = null;
            if (value.length > 0 && value[0] != null) {
                from = (Double)ConvertUtil.convertFromString(Double.class, (String)value[0]);
            }
            if (value.length > 1 && value[1] != null) {
                to = (Double)ConvertUtil.convertFromString(Double.class, (String)value[1]);
            }
            if (from == null && to == null) {
                doubleArray = null;
            } else {
                Double[] doubleArray2 = new Double[2];
                doubleArray2[0] = from;
                doubleArray = doubleArray2;
                doubleArray2[1] = to;
            }
            return doubleArray;
        }
        if (type == ExpressionSearchConditionType.INTEGER) {
            Long[] longArray;
            String[] value = (String[])this.getValue();
            Long from = null;
            Long to = null;
            if (value.length > 0 && value[0] != null) {
                from = (Long)ConvertUtil.convertFromString(Long.class, (String)value[0]);
            }
            if (value.length > 1 && value[1] != null) {
                to = (Long)ConvertUtil.convertFromString(Long.class, (String)value[1]);
            }
            if (from == null && to == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[2];
                longArray2[0] = from;
                longArray = longArray2;
                longArray2[1] = to;
            }
            return longArray;
        }
        if (type == ExpressionSearchConditionType.SELECT) {
            String[] value = (String[])this.getValue();
            if (value == null || value.length == 0) {
                return null;
            }
            SelectPropertyEditor se = (SelectPropertyEditor)editor;
            if (se.getDisplayType() == SelectPropertyEditor.SelectDisplayType.CHECKBOX || se.getDisplayType() == SelectPropertyEditor.SelectDisplayType.HIDDEN) {
                ArrayList<SelectValue> list = new ArrayList<SelectValue>();
                for (String val : value) {
                    if (val == null || val.isEmpty()) continue;
                    list.add(new SelectValue(val));
                }
                return list.toArray(new SelectValue[list.size()]);
            }
            if (value[0] != null && !value[0].isEmpty()) {
                return new SelectValue(value[0]);
            }
        } else {
            if (type == ExpressionSearchConditionType.STRING) {
                String value = (String)this.getValue();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                return value;
            }
            if (type == ExpressionSearchConditionType.TIME) {
                Time[] timeArray;
                String[] value = (String[])this.getValue();
                Time from = null;
                Time to = null;
                if (value.length > 1 && value[1] != null) {
                    from = (Time)ConvertUtil.convertToDate(Time.class, (Object)value[1], (String)TemplateUtil.getLocaleFormat().getServerTimeFormat(), (boolean)false);
                }
                if (value.length > 2 && value[2] != null) {
                    to = (Time)ConvertUtil.convertToDate(Time.class, (Object)value[2], (String)TemplateUtil.getLocaleFormat().getServerTimeFormat(), (boolean)false);
                }
                if (from == null && to == null) {
                    timeArray = null;
                } else {
                    Time[] timeArray2 = new Time[2];
                    timeArray2[0] = from;
                    timeArray = timeArray2;
                    timeArray2[1] = to;
                }
                return timeArray;
            }
        }
        return null;
    }

    static enum ExpressionSearchConditionType {
        BOOLEAN,
        DATE,
        DATETIME,
        DECIMAL,
        EXPRESSION,
        FLOAT,
        INTEGER,
        SELECT,
        STRING,
        TIME;


        public static ExpressionSearchConditionType createSearchCondition(ExpressionProperty ep, PropertyEditor editor) {
            if (ep.getResultType() == PropertyDefinitionType.BOOLEAN && editor instanceof BooleanPropertyEditor) {
                return BOOLEAN;
            }
            if (ep.getResultType() == PropertyDefinitionType.DATE && editor instanceof DatePropertyEditor) {
                return DATE;
            }
            if (ep.getResultType() == PropertyDefinitionType.DATETIME && editor instanceof TimestampPropertyEditor) {
                return DATETIME;
            }
            if (ep.getResultType() == PropertyDefinitionType.DECIMAL && editor instanceof DecimalPropertyEditor) {
                return DECIMAL;
            }
            if (ep.getResultType() == PropertyDefinitionType.FLOAT && editor instanceof FloatPropertyEditor) {
                return FLOAT;
            }
            if (ep.getResultType() == PropertyDefinitionType.INTEGER && editor instanceof IntegerPropertyEditor) {
                return INTEGER;
            }
            if (ep.getResultType() == PropertyDefinitionType.SELECT && editor instanceof SelectPropertyEditor) {
                return SELECT;
            }
            if (ep.getResultType() == PropertyDefinitionType.STRING && editor instanceof StringPropertyEditor) {
                return STRING;
            }
            if (ep.getResultType() == PropertyDefinitionType.TIME && editor instanceof TimePropertyEditor) {
                return TIME;
            }
            return EXPRESSION;
        }
    }
}

