/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.view.generic.editor.FloatPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class FloatPropertySearchCondition
extends PropertySearchCondition {
    public FloatPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public FloatPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Double[] dbl = (Double[])this.getValue();
        if (this.getEditor().isSearchInRange()) {
            Double from = null;
            Double to = null;
            if (dbl.length > 0 && dbl[0] != null) {
                from = dbl[0];
            }
            if (dbl.length > 1 && dbl[1] != null) {
                to = dbl[1];
            }
            if (from != null && to != null) {
                conditions.add((Condition)new Between(this.getPropertyName(), (Object)from, (Object)to));
            } else if (from != null && to == null) {
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)from));
            } else if (from == null && to != null) {
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)to));
            }
        } else if (dbl.length > 0 && dbl[0] != null) {
            conditions.add((Condition)new Equals(this.getPropertyName(), (Object)dbl[0]));
        }
        return conditions;
    }

    @Override
    public FloatPropertyEditor getEditor() {
        return (FloatPropertyEditor)super.getEditor();
    }
}

