/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.view.generic.editor.IntegerPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class IntegerPropertySearchCondition
extends PropertySearchCondition {
    public IntegerPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public IntegerPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Long[] lng = (Long[])this.getValue();
        if (this.getEditor().isSearchInRange()) {
            Long from = null;
            Long to = null;
            if (lng.length > 0 && lng[0] != null) {
                from = lng[0];
            }
            if (lng.length > 1 && lng[1] != null) {
                to = lng[1];
            }
            if (from != null && to != null) {
                conditions.add((Condition)new Between(this.getPropertyName(), (Object)from, (Object)to));
            } else if (from != null && to == null) {
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)from));
            } else if (from == null && to != null) {
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)to));
            }
        } else if (lng.length > 0 && lng[0] != null) {
            conditions.add((Condition)new Equals(this.getPropertyName(), (Object)lng[0]));
        }
        return conditions;
    }

    @Override
    public IntegerPropertyEditor getEditor() {
        return (IntegerPropertyEditor)super.getEditor();
    }
}

