/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.AutoNumberPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.BinaryPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.BooleanPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.DatePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.DateRangePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.DecimalPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.ExpressionPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.FloatPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.IntegerPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.LongTextPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.NumericRangePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.ReferencePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.SelectPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.StringPropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.TimePropertySearchCondition;
import org.iplass.gem.command.generic.search.condition.TimestampPropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.Not;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.NumericRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;

public abstract class PropertySearchCondition {
    private PropertyDefinition definition;
    private PropertyEditor editor;
    private Object value;
    private String parent;

    public PropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        this.definition = definition;
        this.editor = editor;
        this.value = value;
    }

    public PropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        this.definition = definition;
        this.editor = editor;
        this.value = value;
        this.parent = parent;
    }

    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add((Condition)new Equals(this.getPropertyName(), this.getValue()));
        return conditions;
    }

    public List<Condition> convertDetailCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (this.value instanceof SearchConditionDetail) {
            SearchConditionDetail detail = (SearchConditionDetail)this.value;
            Object conditionValue = this.convertDetailValue(detail);
            if ("Equals".equals(detail.getPredicate())) {
                conditions.add((Condition)new Equals(detail.getPropertyName(), conditionValue));
            } else if ("NotEquals".equals(detail.getPredicate())) {
                conditions.add((Condition)new NotEquals(detail.getPropertyName(), conditionValue));
            } else if ("Greater".equals(detail.getPredicate())) {
                conditions.add((Condition)new Greater(detail.getPropertyName(), conditionValue));
            } else if ("GreaterEquals".equals(detail.getPredicate())) {
                conditions.add((Condition)new GreaterEqual(detail.getPropertyName(), conditionValue));
            } else if ("Lesser".equals(detail.getPredicate())) {
                conditions.add((Condition)new Lesser(detail.getPropertyName(), conditionValue));
            } else if ("LesserEquals".equals(detail.getPredicate())) {
                conditions.add((Condition)new LesserEqual(detail.getPropertyName(), conditionValue));
            } else if ("FrontMatch".equals(detail.getPredicate())) {
                conditions.add((Condition)new Like(detail.getPropertyName(), (String)conditionValue, Like.MatchPattern.PREFIX));
            } else if ("BackwardMatch".equals(detail.getPredicate())) {
                conditions.add((Condition)new Like(detail.getPropertyName(), (String)conditionValue, Like.MatchPattern.POSTFIX));
            } else if ("Include".equals(detail.getPredicate())) {
                conditions.add((Condition)new Like(detail.getPropertyName(), (String)conditionValue, Like.MatchPattern.PARTIAL));
            } else if ("NotInclude".equals(detail.getPredicate())) {
                conditions.add((Condition)new Paren((Condition)new Not((Condition)new Like(detail.getPropertyName(), (String)conditionValue, Like.MatchPattern.PARTIAL))));
            } else if ("NotNull".equals(detail.getPredicate())) {
                conditions.add((Condition)new IsNotNull(detail.getPropertyName()));
            } else if ("Null".equals(detail.getPredicate())) {
                conditions.add((Condition)new IsNull(detail.getPropertyName()));
            } else if ("In".equals(detail.getPredicate())) {
                Object[] array = null;
                array = conditionValue.getClass().isArray() ? (Object[])conditionValue : new Object[]{conditionValue};
                conditions.add((Condition)new In(detail.getPropertyName(), array));
            }
        }
        return conditions;
    }

    protected Object convertDetailValue(SearchConditionDetail detail) {
        if ("NotNull".equals(detail.getPredicate()) || "Null".equals(detail.getPredicate())) {
            return null;
        }
        if ("In".equals(detail.getPredicate())) {
            StrTokenizer st = StrTokenizer.getCSVInstance((String)detail.getValue());
            String[] values = st.getTokenArray();
            String[] ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if ("FrontMatch".equals(detail.getPredicate()) || "BackwardMatch".equals(detail.getPredicate()) || "Include".equals(detail.getPredicate()) || "NotInclude".equals(detail.getPredicate())) {
            return detail.getValue();
        }
        return detail.getValue();
    }

    protected String getPropertyName() {
        if (this.parent != null) {
            return this.parent + "." + this.definition.getName();
        }
        return this.definition.getName();
    }

    public boolean checkNormalParameter(PropertyItem property) {
        return true;
    }

    public boolean checkDetailParameter(PropertyItem property) {
        return this.getValue() instanceof SearchConditionDetail;
    }

    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(PropertyDefinition definition) {
        this.definition = definition;
    }

    public PropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(PropertyEditor editor) {
        this.editor = editor;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected String getParent() {
        return this.parent;
    }

    public static PropertySearchCondition newInstance(PropertyDefinition definition, PropertyEditor editor, Object value) {
        return PropertySearchCondition.newInstance(definition, editor, value, null);
    }

    public static PropertySearchCondition newInstance(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        if (definition instanceof AutoNumberProperty) {
            return new AutoNumberPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof BinaryProperty) {
            return new BinaryPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof BooleanProperty) {
            return new BooleanPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof DateProperty) {
            if (editor instanceof DateRangePropertyEditor) {
                return new DateRangePropertySearchCondition(definition, editor, value, parent);
            }
            return new DatePropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof DateTimeProperty) {
            if (editor instanceof DateRangePropertyEditor) {
                return new DateRangePropertySearchCondition(definition, editor, value, parent);
            }
            return new TimestampPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof DecimalProperty) {
            if (editor instanceof NumericRangePropertyEditor) {
                return new NumericRangePropertySearchCondition(definition, editor, value, parent);
            }
            return new DecimalPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof ExpressionProperty) {
            return new ExpressionPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof FloatProperty) {
            if (editor instanceof NumericRangePropertyEditor) {
                return new NumericRangePropertySearchCondition(definition, editor, value, parent);
            }
            return new FloatPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof IntegerProperty) {
            if (editor instanceof NumericRangePropertyEditor) {
                return new NumericRangePropertySearchCondition(definition, editor, value, parent);
            }
            return new IntegerPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof LongTextProperty) {
            return new LongTextPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof ReferenceProperty) {
            return new ReferencePropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof SelectProperty) {
            return new SelectPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof StringProperty) {
            return new StringPropertySearchCondition(definition, editor, value, parent);
        }
        if (definition instanceof TimeProperty) {
            if (editor instanceof DateRangePropertyEditor) {
                return new DateRangePropertySearchCondition(definition, editor, value, parent);
            }
            return new TimePropertySearchCondition(definition, editor, value, parent);
        }
        return null;
    }
}

