/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.SearchConditionValidationException;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.Not;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.RangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.web.template.TemplateUtil;

public class ReferencePropertySearchCondition
extends PropertySearchCondition {
    private PropertyDefinition nestProperty;

    public ReferencePropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public ReferencePropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    public void setNestProperty(PropertyDefinition nestProperty) {
        this.nestProperty = nestProperty;
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ReferenceProperty rp;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        ReferencePropertyEditor editor = this.getReferencePropertyEditor();
        Object value = null;
        Entity nest = null;
        if (this.getValue() != null) {
            ReferenceNormalConditionValue nValue = (ReferenceNormalConditionValue)this.getValue();
            value = nValue.getValue();
            nest = nValue.getNest();
        }
        if (value != null && editor != null) {
            ArrayList<String> oidList;
            Entity[] list;
            Entity entity;
            if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.SELECT) {
                entity = (Entity)value;
                if (entity.getOid() != null && !entity.getOid().isEmpty()) {
                    conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)entity.getOid()));
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.CHECKBOX) {
                list = (Entity[])value;
                if (list != null) {
                    if (list.length == 1) {
                        conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)list[0].getOid()));
                    } else if (list.length > 1) {
                        oidList = new ArrayList<String>();
                        for (Entity tmp : list) {
                            oidList.add(tmp.getOid());
                        }
                        conditions.add((Condition)new In(this.getPropertyName() + "." + "oid", oidList.toArray()));
                    }
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.REFCOMBO) {
                RefComboCondition cond;
                if (value instanceof Entity) {
                    entity = (Entity)value;
                    if (entity.getOid() != null && !entity.getOid().isEmpty()) {
                        conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)entity.getOid()));
                    }
                } else if (value instanceof RefComboCondition && StringUtil.isNotBlank((String)(cond = (RefComboCondition)value).getName()) && StringUtil.isNotBlank((String)cond.getOid())) {
                    conditions.add((Condition)new Equals(cond.getName() + "." + "oid", (Object)cond.getOid()));
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LINK && editor.isUseSearchDialog() || editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LABEL) {
                list = (Entity[])value;
                if (list != null) {
                    if (list.length == 1) {
                        conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)list[0].getOid()));
                    } else if (list.length > 1) {
                        oidList = new ArrayList();
                        for (Entity tmp : list) {
                            oidList.add(tmp.getOid());
                        }
                        conditions.add((Condition)new In(this.getPropertyName() + "." + "oid", oidList.toArray()));
                    }
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.TREE) {
                list = (Entity[])value;
                if (list != null) {
                    if (list.length == 1) {
                        conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)list[0].getOid()));
                    } else if (list.length > 1) {
                        oidList = new ArrayList();
                        for (Entity tmp : list) {
                            oidList.add(tmp.getOid());
                        }
                        conditions.add((Condition)new In(this.getPropertyName() + "." + "oid", oidList.toArray()));
                    }
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.UNIQUE && editor.isUseSearchDialog()) {
                list = (Entity[])value;
                if (list != null) {
                    if (list.length == 1) {
                        conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)list[0].getOid()));
                    } else if (list.length > 1) {
                        oidList = new ArrayList();
                        for (Entity tmp : list) {
                            oidList.add(tmp.getOid());
                        }
                        conditions.add((Condition)new In(this.getPropertyName() + "." + "oid", oidList.toArray()));
                    }
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.HIDDEN) {
                list = (Entity[])value;
                if (list != null) {
                    if (list.length == 1) {
                        conditions.add((Condition)new Equals(this.getPropertyName() + "." + "oid", (Object)list[0].getOid()));
                    } else if (list.length > 1) {
                        oidList = new ArrayList();
                        for (Entity tmp : list) {
                            oidList.add(tmp.getOid());
                        }
                        conditions.add((Condition)new In(this.getPropertyName() + "." + "oid", oidList.toArray()));
                    }
                }
            } else {
                entity = (Entity)value;
                if (entity.getName() != null && !entity.getName().isEmpty()) {
                    conditions.add((Condition)new Like(this.getPropertyName() + "." + "name", entity.getName(), Like.MatchPattern.PARTIAL));
                }
            }
        }
        if (nest != null && (rp = this.getReferenceProperty()) != null) {
            EntityDefinition ed = ((EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class)).get(rp.getObjectDefinitionName());
            for (NestProperty np : editor.getNestProperties()) {
                Object _value = nest.getValue(np.getPropertyName());
                if (_value == null) continue;
                PropertyDefinition definition = ed.getProperty(np.getPropertyName());
                PropertySearchCondition nestPropertyCondition = PropertySearchCondition.newInstance(definition, np.getEditor(), _value, this.getPropertyName());
                conditions.addAll(nestPropertyCondition.convertNormalCondition());
            }
        }
        return conditions;
    }

    @Override
    public List<Condition> convertDetailCondition() {
        ArrayList<Condition> conditions;
        block3: {
            String propName;
            SearchConditionDetail detail;
            block4: {
                Object conditionValue;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block5: {
                                                                conditions = new ArrayList<Condition>();
                                                                if (!(this.getValue() instanceof SearchConditionDetail)) break block3;
                                                                detail = (SearchConditionDetail)this.getValue();
                                                                propName = detail.getPropertyName();
                                                                if (this.nestProperty != null && !(this.nestProperty instanceof ReferenceProperty)) break block4;
                                                                conditionValue = this.convertDetailValue(detail);
                                                                propName = propName + ".name";
                                                                if (!"Equals".equals(detail.getPredicate())) break block5;
                                                                conditions.add((Condition)new Equals(propName, conditionValue));
                                                                break block3;
                                                            }
                                                            if (!"NotEquals".equals(detail.getPredicate())) break block6;
                                                            conditions.add((Condition)new NotEquals(propName, conditionValue));
                                                            break block3;
                                                        }
                                                        if (!"Greater".equals(detail.getPredicate())) break block7;
                                                        conditions.add((Condition)new Greater(propName, conditionValue));
                                                        break block3;
                                                    }
                                                    if (!"GreaterEquals".equals(detail.getPredicate())) break block8;
                                                    conditions.add((Condition)new GreaterEqual(propName, conditionValue));
                                                    break block3;
                                                }
                                                if (!"Lesser".equals(detail.getPredicate())) break block9;
                                                conditions.add((Condition)new Lesser(propName, conditionValue));
                                                break block3;
                                            }
                                            if (!"LesserEquals".equals(detail.getPredicate())) break block10;
                                            conditions.add((Condition)new LesserEqual(propName, conditionValue));
                                            break block3;
                                        }
                                        if (!"FrontMatch".equals(detail.getPredicate())) break block11;
                                        conditions.add((Condition)new Like(propName, (String)conditionValue, Like.MatchPattern.PREFIX));
                                        break block3;
                                    }
                                    if (!"BackwardMatch".equals(detail.getPredicate())) break block12;
                                    conditions.add((Condition)new Like(propName, (String)conditionValue, Like.MatchPattern.POSTFIX));
                                    break block3;
                                }
                                if (!"Include".equals(detail.getPredicate())) break block13;
                                conditions.add((Condition)new Like(propName, (String)conditionValue, Like.MatchPattern.PARTIAL));
                                break block3;
                            }
                            if (!"NotInclude".equals(detail.getPredicate())) break block14;
                            conditions.add((Condition)new Paren((Condition)new Not((Condition)new Like(propName, (String)conditionValue, Like.MatchPattern.PARTIAL))));
                            break block3;
                        }
                        if (!"NotNull".equals(detail.getPredicate())) break block15;
                        conditions.add((Condition)new IsNotNull(propName));
                        break block3;
                    }
                    if (!"Null".equals(detail.getPredicate())) break block16;
                    conditions.add((Condition)new IsNull(propName));
                    break block3;
                }
                if (!"In".equals(detail.getPredicate())) break block3;
                Object[] array = null;
                array = conditionValue.getClass().isArray() ? (Object[])conditionValue : new Object[]{conditionValue};
                conditions.add((Condition)new In(propName, array));
                break block3;
            }
            int firstDotIndex = propName.indexOf(46);
            if (firstDotIndex > -1) {
                String topPropName = propName.substring(0, firstDotIndex);
                String subPropName = propName.substring(firstDotIndex + 1);
                if (topPropName.equals(this.getDefinition().getName())) {
                    ReferencePropertyEditor re = this.getReferencePropertyEditor();
                    for (NestProperty nest : re.getNestProperties()) {
                        PropertyEditor nestEditor = this.getNestPropertyEditor(nest, subPropName);
                        if (nestEditor == null) continue;
                        PropertySearchCondition nestPropertyCondition = PropertySearchCondition.newInstance(this.nestProperty, nestEditor, detail);
                        conditions.addAll(nestPropertyCondition.convertDetailCondition());
                    }
                }
            }
        }
        return conditions;
    }

    @Override
    public boolean checkNormalParameter(PropertyItem property) {
        ReferenceNormalConditionValue nValue = (ReferenceNormalConditionValue)this.getValue();
        if (nValue.getNest() == null) {
            return true;
        }
        Entity nest = nValue.getNest();
        ReferenceProperty rp = this.getReferenceProperty();
        EntityDefinition ed = ((EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class)).get(rp.getObjectDefinitionName());
        for (PropertyDefinition pd : ed.getPropertyList()) {
            PropertySearchCondition nestPropertyCondition;
            NestProperty np = this.getNestProperty(pd.getName());
            Object value = nest.getValue(pd.getName());
            if (np == null) {
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    if (((Object[])value).length == 0) continue;
                    return false;
                }
                return false;
            }
            if (!(pd instanceof ReferenceProperty) || value == null || (nestPropertyCondition = PropertySearchCondition.newInstance(pd, np.getEditor(), value, this.getPropertyName())).checkNormalParameter(null)) continue;
            return false;
        }
        return true;
    }

    private SearchConditionValidationException createException(String displayName) {
        if (displayName == null) {
            return new SearchConditionValidationException();
        }
        return new SearchConditionValidationException(ReferencePropertySearchCondition.resourceString("command.generic.search.condition.ReferencePropertySearchCondition.pleaseInput", displayName));
    }

    public void validateNormalParameter(boolean validateEntity) {
        ReferenceProperty rp;
        ReferencePropertyEditor editor = this.getReferencePropertyEditor();
        Object value = null;
        Entity nest = null;
        boolean validateNest = false;
        if (this.getValue() != null) {
            ReferenceNormalConditionValue nValue = (ReferenceNormalConditionValue)this.getValue();
            value = nValue.getValue();
            nest = nValue.getNest();
        }
        if (editor != null) {
            Entity[] list;
            Entity entity;
            if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.SELECT) {
                entity = (Entity)value;
                if (validateEntity && (value == null || StringUtil.isBlank((String)entity.getOid()))) {
                    throw this.createException(null);
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.CHECKBOX) {
                list = (Entity[])value;
                if (validateEntity && (value == null || list.length == 0)) {
                    throw this.createException(null);
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.REFCOMBO) {
                if (validateEntity && value == null) {
                    throw this.createException(null);
                }
                if (value instanceof Entity) {
                    entity = (Entity)value;
                    if (validateEntity && StringUtil.isBlank((String)entity.getOid())) {
                        throw this.createException(null);
                    }
                } else if (value instanceof RefComboCondition) {
                    RefComboCondition cond = (RefComboCondition)value;
                    if (validateEntity && StringUtil.isBlank((String)cond.getName()) || StringUtil.isBlank((String)cond.getOid())) {
                        throw this.createException(null);
                    }
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LINK && editor.isUseSearchDialog() || editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.LABEL) {
                list = (Entity[])value;
                if (validateEntity && (value == null || list.length == 0)) {
                    this.createException(null);
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.TREE) {
                list = (Entity[])value;
                if (validateEntity && (value == null || list.length == 0)) {
                    this.createException(null);
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.UNIQUE && editor.isUseSearchDialog()) {
                list = (Entity[])value;
                if (validateEntity && (value == null || list.length == 0)) {
                    this.createException(null);
                }
            } else if (editor.getDisplayType() == ReferencePropertyEditor.ReferenceDisplayType.HIDDEN) {
                list = (Entity[])value;
                if (validateEntity && (value == null || list.length == 0)) {
                    this.createException(null);
                }
            } else {
                int rowNum = 0;
                for (NestProperty np : editor.getNestProperties()) {
                    if (np.getEditor() == null) continue;
                    ++rowNum;
                }
                boolean bl = validateNest = rowNum != 0;
                if (rowNum == 0 || editor.isUseNestConditionWithProperty()) {
                    Entity entity2 = (Entity)value;
                    if (validateEntity && (value == null || StringUtil.isBlank((String)entity2.getName()))) {
                        throw this.createException(null);
                    }
                }
            }
        }
        if ((validateNest || editor != null && editor.isUseNestConditionWithProperty()) && (rp = this.getReferenceProperty()) != null) {
            EntityDefinition ed = ((EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class)).get(rp.getObjectDefinitionName());
            for (NestProperty np : editor.getNestProperties()) {
                Object _value;
                PropertyDefinition definition = ed.getProperty(np.getPropertyName());
                String displayLabel = TemplateUtil.getMultilingualString((String)np.getDisplayLabel(), np.getLocalizedDisplayLabelList(), (String)definition.getDisplayName(), (List)definition.getLocalizedDisplayNameList());
                Object object = _value = nest != null ? nest.getValue(np.getPropertyName()) : null;
                if (definition instanceof ReferenceProperty) {
                    try {
                        PropertySearchCondition nestPropertyCondition = PropertySearchCondition.newInstance(definition, np.getEditor(), _value, this.getPropertyName());
                        ((ReferencePropertySearchCondition)nestPropertyCondition).validateNormalParameter(np.isRequiredNormal());
                    }
                    catch (SearchConditionValidationException e) {
                        if (e.getMessage() == null) {
                            throw this.createException(displayLabel);
                        }
                        throw e;
                    }
                }
                if (!np.isRequiredNormal() || _value != null) continue;
                throw this.createException(displayLabel);
            }
        }
    }

    @Override
    public boolean checkDetailParameter(PropertyItem property) {
        if (!(this.getValue() instanceof SearchConditionDetail)) {
            return false;
        }
        if (this.nestProperty == null) {
            return true;
        }
        ReferencePropertyEditor editor = this.getReferencePropertyEditor();
        SearchConditionDetail detail = (SearchConditionDetail)this.getValue();
        int firstDotIndex = detail.getPropertyName().indexOf(46);
        if (firstDotIndex > 0) {
            String topPropName = detail.getPropertyName().substring(0, firstDotIndex);
            String subPropName = detail.getPropertyName().substring(firstDotIndex + 1);
            if (topPropName.equals(property.getPropertyName())) {
                for (NestProperty nest : editor.getNestProperties()) {
                    if (!this.checkNestProperty(nest, subPropName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkNestProperty(NestProperty nest, String propName) {
        int firstDotIndex = propName.indexOf(46);
        if (firstDotIndex > 0) {
            if (nest.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)nest.getEditor()).getNestProperties().isEmpty()) {
                ReferencePropertyEditor editor = (ReferencePropertyEditor)nest.getEditor();
                String topPropName = propName.substring(0, firstDotIndex);
                String subPropName = propName.substring(firstDotIndex + 1);
                if (topPropName.equals(nest.getPropertyName())) {
                    for (NestProperty child : editor.getNestProperties()) {
                        if (!this.checkNestProperty(child, subPropName)) continue;
                        return true;
                    }
                }
            }
        } else {
            if (nest.getEditor() instanceof RangePropertyEditor) {
                return ((RangePropertyEditor)((Object)nest.getEditor())).getToPropertyName().equals(propName);
            }
            return nest.getPropertyName().equals(propName);
        }
        return false;
    }

    private PropertyEditor getNestPropertyEditor(NestProperty nest, String propName) {
        int firstDotIndex = propName.indexOf(46);
        if (firstDotIndex > 0) {
            if (nest.getEditor() instanceof ReferencePropertyEditor && !((ReferencePropertyEditor)nest.getEditor()).getNestProperties().isEmpty()) {
                ReferencePropertyEditor editor = (ReferencePropertyEditor)nest.getEditor();
                String topPropName = propName.substring(0, firstDotIndex);
                String subPropName = propName.substring(firstDotIndex + 1);
                if (topPropName.equals(nest.getPropertyName())) {
                    for (NestProperty child : editor.getNestProperties()) {
                        if (!this.checkNestProperty(child, subPropName)) continue;
                        return child.getEditor();
                    }
                }
            }
        } else {
            return nest.getEditor();
        }
        return null;
    }

    private NestProperty getNestProperty(String name) {
        ReferencePropertyEditor editor = this.getReferencePropertyEditor();
        if (editor == null || editor.getNestProperties().isEmpty()) {
            return null;
        }
        for (NestProperty np : editor.getNestProperties()) {
            if (np.getPropertyName().equals(name)) {
                return np;
            }
            if (!(np.getEditor() instanceof RangePropertyEditor)) continue;
            return np;
        }
        return null;
    }

    private ReferenceProperty getReferenceProperty() {
        if (this.getDefinition() instanceof ReferenceProperty) {
            return (ReferenceProperty)this.getDefinition();
        }
        return null;
    }

    private ReferencePropertyEditor getReferencePropertyEditor() {
        if (this.getEditor() instanceof ReferencePropertyEditor) {
            return (ReferencePropertyEditor)this.getEditor();
        }
        return null;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    public static class RefComboCondition {
        private String oid;
        private String name;

        public RefComboCondition(String oid, String name) {
            this.oid = oid;
            this.name = name;
        }

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class ReferenceNormalConditionValue {
        private Object value;
        private Entity nest;

        public ReferenceNormalConditionValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Entity getNest() {
            return this.nest;
        }

        public void setNest(Entity nest) {
            this.nest = nest;
        }
    }
}

