/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.LocalizedSelectValueDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.view.generic.editor.EditorValue;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.web.template.TemplateUtil;

public class SelectPropertySearchCondition
extends PropertySearchCondition {
    public SelectPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public SelectPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Object value = this.getValue();
        SelectPropertyEditor editor = (SelectPropertyEditor)this.getEditor();
        if (value != null && editor != null) {
            if (editor.getDisplayType() == SelectPropertyEditor.SelectDisplayType.CHECKBOX || editor.getDisplayType() == SelectPropertyEditor.SelectDisplayType.HIDDEN) {
                SelectValue[] array = (SelectValue[])value;
                if (array != null) {
                    if (array.length == 1) {
                        conditions.add((Condition)new Equals(this.getPropertyName(), (Object)array[0].getValue()));
                    } else if (array.length > 1) {
                        ArrayList<String> valueList = new ArrayList<String>();
                        for (SelectValue tmp : array) {
                            valueList.add(tmp.getValue());
                        }
                        conditions.add((Condition)new In(this.getPropertyName(), valueList.toArray()));
                    }
                }
            } else {
                SelectValue sv = (SelectValue)value;
                conditions.add((Condition)new Equals(this.getPropertyName(), (Object)sv.getValue()));
            }
        }
        return conditions;
    }

    @Override
    protected Object convertDetailValue(SearchConditionDetail detail) {
        if ("NotNull".equals(detail.getPredicate()) || "Null".equals(detail.getPredicate())) {
            return null;
        }
        if ("In".equals(detail.getPredicate())) {
            StrTokenizer st = StrTokenizer.getCSVInstance((String)detail.getValue());
            String[] values = st.getTokenArray();
            String[] ret = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = this.string2Value(values[i]);
            }
            return ret;
        }
        return this.string2Value(detail.getValue());
    }

    private String string2Value(String str) {
        block11: {
            SelectPropertyEditor editor = (SelectPropertyEditor)this.getEditor();
            if (!editor.getValues().isEmpty()) {
                for (EditorValue ev : editor.getValues()) {
                    if (ev.getValue().equals(str)) {
                        return str;
                    }
                    String label = TemplateUtil.getMultilingualString((String)ev.getLabel(), ev.getLocalizedLabelList());
                    if (!label.equals(str)) continue;
                    return ev.getValue();
                }
            }
            if (!(this.getDefinition() instanceof SelectProperty)) break block11;
            SelectProperty sp = (SelectProperty)this.getDefinition();
            if (sp.getSelectValue(str) != null) {
                return str;
            }
            if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual() && sp.getLocalizedSelectValueList() != null && !sp.getLocalizedSelectValueList().isEmpty()) {
                String lang = ExecuteContext.getCurrentContext().getLanguage();
                for (LocalizedSelectValueDefinition lsd : sp.getLocalizedSelectValueList()) {
                    if (!lsd.getLocaleName().equals(lang)) continue;
                    if (lsd.getSelectValueList() != null && !lsd.getSelectValueList().isEmpty()) {
                        for (SelectValue sv : lsd.getSelectValueList()) {
                            if (!sv.getDisplayName().equals(str)) continue;
                            return sv.getValue();
                        }
                        continue;
                    }
                    for (SelectValue sv : sp.getSelectValueList()) {
                        if (!sv.getDisplayName().equals(str)) continue;
                        return sv.getValue();
                    }
                }
            } else {
                for (SelectValue sv : sp.getSelectValueList()) {
                    if (!sv.getDisplayName().equals(str)) continue;
                    return sv.getValue();
                }
            }
        }
        return null;
    }
}

