/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.StringPropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;

public class StringPropertySearchCondition
extends PropertySearchCondition {
    public StringPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public StringPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        PropertyEditor editor = this.getEditor();
        if (editor instanceof StringPropertyEditor) {
            StringPropertyEditor sp = (StringPropertyEditor)editor;
            if (sp.getDisplayType() != null && sp.getDisplayType() == StringPropertyEditor.StringDisplayType.SELECT || sp.isSearchExactMatchCondition()) {
                conditions.add((Condition)new Equals(this.getPropertyName(), this.getValue()));
            } else {
                conditions.add((Condition)new Like(this.getPropertyName(), this.getValue().toString(), Like.MatchPattern.PARTIAL));
            }
        } else if (editor instanceof UserPropertyEditor) {
            Like like = new Like("name", this.getValue().toString(), Like.MatchPattern.PARTIAL);
            conditions.add((Condition)new In(this.getPropertyName(), new SubQuery(new Query().select(new Object[]{"oid"}).from("mtp.auth.User").where((Condition)like))));
        } else {
            conditions.add((Condition)new Like(this.getPropertyName(), this.getValue().toString(), Like.MatchPattern.PARTIAL));
        }
        return conditions;
    }

    @Override
    public List<Condition> convertDetailCondition() {
        PropertyEditor editor = this.getEditor();
        if (editor instanceof UserPropertyEditor) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            SearchConditionDetail detail = (SearchConditionDetail)this.getValue();
            String _propName = detail.getPropertyName();
            detail.setPropertyName("name");
            List<Condition> userSearchCondition = super.convertDetailCondition();
            detail.setPropertyName(_propName);
            conditions.add((Condition)new In(this.getPropertyName(), new SubQuery(new Query().select(new Object[]{"oid"}).from("mtp.auth.User").where((Condition)new And(userSearchCondition)))));
            return conditions;
        }
        return super.convertDetailCondition();
    }
}

