/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.CommandUtil;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.view.generic.editor.DateTimePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.TimePropertyEditor;

public class TimePropertySearchCondition
extends PropertySearchCondition {
    public TimePropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public TimePropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Time[] t = (Time[])this.getValue();
        TimePropertyEditor editor = this.getEditor();
        if (editor.isSingleDayCondition()) {
            if (t.length > 0 && t[0] != null) {
                Calendar base = DateUtil.getCalendar((boolean)false);
                base.setTime(t[0]);
                Calendar from = DateUtil.getCalendar((boolean)false);
                from.setTime(base.getTime());
                Calendar to = DateUtil.getCalendar((boolean)false);
                to.setTime(base.getTime());
                from.set(14, 0);
                to.set(14, 999);
                if (!DateTimePropertyEditor.TimeDispRange.isDispSec(editor.getDispRange())) {
                    from.set(13, 0);
                    to.set(13, 59);
                }
                if (!DateTimePropertyEditor.TimeDispRange.isDispMin(editor.getDispRange())) {
                    from.set(12, 0);
                    to.set(12, 59);
                }
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)new Time(from.getTimeInMillis())));
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)new Time(to.getTimeInMillis())));
            }
        } else {
            Time from = null;
            Time to = null;
            if (t.length > 0 && t[0] != null) {
                from = t[0];
            }
            if (t.length > 1 && t[1] != null) {
                to = t[1];
            }
            if (from != null && to != null) {
                conditions.add((Condition)new Between(this.getPropertyName(), (Object)from, (Object)to));
            } else if (from != null && to == null) {
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)from));
            } else if (from == null && to != null) {
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)to));
            }
        }
        return conditions;
    }

    @Override
    protected Object convertDetailValue(SearchConditionDetail detail) {
        if ("NotNull".equals(detail.getPredicate()) || "Null".equals(detail.getPredicate())) {
            return null;
        }
        if ("In".equals(detail.getPredicate())) {
            StrTokenizer st = StrTokenizer.getCSVInstance((String)detail.getValue());
            String[] values = st.getTokenArray();
            Time[] ret = new Time[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = this.string2Time(values[i]);
            }
            return ret;
        }
        return this.string2Time(detail.getValue());
    }

    private Time string2Time(String str) {
        return CommandUtil.getTime6(str);
    }

    @Override
    public TimePropertyEditor getEditor() {
        return (TimePropertyEditor)super.getEditor();
    }
}

