/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.condition;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.text.StrTokenizer;
import org.iplass.gem.command.generic.search.SearchConditionDetail;
import org.iplass.gem.command.generic.search.condition.PropertySearchCondition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.view.generic.editor.DateTimePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.TimestampPropertyEditor;
import org.iplass.mtp.web.template.TemplateUtil;

public class TimestampPropertySearchCondition
extends PropertySearchCondition {
    public TimestampPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value) {
        super(definition, editor, value);
    }

    public TimestampPropertySearchCondition(PropertyDefinition definition, PropertyEditor editor, Object value, String parent) {
        super(definition, editor, value, parent);
    }

    @Override
    public List<Condition> convertNormalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Timestamp[] t = (Timestamp[])this.getValue();
        TimestampPropertyEditor editor = this.getEditor();
        if (editor.isSingleDayCondition()) {
            if (t.length > 0 && t[0] != null) {
                Calendar base = DateUtil.getCalendar((boolean)true);
                base.setTime(t[0]);
                Calendar from = DateUtil.getCalendar((boolean)true);
                from.setTime(base.getTime());
                Calendar to = DateUtil.getCalendar((boolean)true);
                to.setTime(base.getTime());
                from.set(14, 0);
                to.set(14, 999);
                if (!DateTimePropertyEditor.TimeDispRange.isDispSec(editor.getDispRange())) {
                    from.set(13, 0);
                    to.set(13, 59);
                }
                if (!DateTimePropertyEditor.TimeDispRange.isDispMin(editor.getDispRange())) {
                    from.set(12, 0);
                    to.set(12, 59);
                }
                if (!DateTimePropertyEditor.TimeDispRange.isDispHour(editor.getDispRange())) {
                    from.set(10, 0);
                    to.set(10, 23);
                }
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)new Timestamp(from.getTimeInMillis())));
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)new Timestamp(to.getTimeInMillis())));
            }
        } else {
            Timestamp from = null;
            Timestamp to = null;
            if (t.length > 0 && t[0] != null) {
                from = t[0];
            }
            if (t.length > 1 && t[1] != null) {
                to = t[1];
            }
            if (from != null && to != null) {
                conditions.add((Condition)new Between(this.getPropertyName(), (Object)from, (Object)to));
            } else if (from != null && to == null) {
                conditions.add((Condition)new GreaterEqual(this.getPropertyName(), (Object)from));
            } else if (from == null && to != null) {
                conditions.add((Condition)new LesserEqual(this.getPropertyName(), (Object)to));
            }
        }
        return conditions;
    }

    @Override
    protected Object convertDetailValue(SearchConditionDetail detail) {
        if ("NotNull".equals(detail.getPredicate()) || "Null".equals(detail.getPredicate())) {
            return null;
        }
        if ("In".equals(detail.getPredicate())) {
            StrTokenizer st = StrTokenizer.getCSVInstance((String)detail.getValue());
            String[] values = st.getTokenArray();
            Timestamp[] ret = new Timestamp[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = this.string2Timestamp(values[i]);
            }
            return ret;
        }
        return this.string2Timestamp(detail.getValue());
    }

    private Timestamp string2Timestamp(String str) {
        if (str.length() == 8) {
            return (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)str, (String)TemplateUtil.getLocaleFormat().getServerDateFormat(), (boolean)true);
        }
        if (str.length() == 14) {
            return (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)str, (String)(TemplateUtil.getLocaleFormat().getServerDateFormat() + "HHmmss"), (boolean)true);
        }
        return (Timestamp)ConvertUtil.convertToDate(Timestamp.class, (Object)str, (String)TemplateUtil.getLocaleFormat().getServerDateTimeFormat(), (boolean)true);
    }

    @Override
    public TimestampPropertyEditor getEditor() {
        return (TimestampPropertyEditor)super.getEditor();
    }
}

