/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.search.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.gem.command.common.SearchResultData;
import org.iplass.gem.command.common.SearchResultRow;
import org.iplass.gem.command.generic.search.handler.CreateSearchResultEvent;
import org.iplass.gem.command.generic.search.handler.SearchFormViewAdapter;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.iplass.mtp.impl.entity.interceptor.EntityQueryInvocationImpl;
import org.iplass.mtp.spi.ServiceRegistry;

public class CheckPermissionLimitConditionOfEditLinkHandler
extends SearchFormViewAdapter {
    @Override
    protected void onCreateSearchResult(CreateSearchResultEvent event) {
        if (event.getResultData().getRows().isEmpty()) {
            return;
        }
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        EntityHandler handler = ((EntityService)ServiceRegistry.getRegistry().getService(EntityService.class)).getRuntimeByName(event.getEntityName());
        if (!user.isPrivilegedExecution()) {
            this.checkUpdatePermission(handler, event.getResultData(), user);
            this.checkDeletePermission(handler, event.getResultData(), user);
        }
    }

    private void checkUpdatePermission(EntityHandler handler, SearchResultData resultData, AuthContextHolder user) {
        EntityPermission permission = new EntityPermission(handler.getMetaData().getName(), EntityPermission.Action.UPDATE);
        if (!user.checkPermission((Permission)permission)) {
            resultData.getRows().forEach(row -> row.getResponse().put("@canEdit", String.valueOf(false)));
            return;
        }
        this.checkLimitCondition(handler, resultData, permission, user, "@canEdit");
    }

    private void checkDeletePermission(EntityHandler handler, SearchResultData resultData, AuthContextHolder user) {
        EntityPermission permission = new EntityPermission(handler.getMetaData().getName(), EntityPermission.Action.DELETE);
        if (!user.checkPermission((Permission)permission)) {
            resultData.getRows().forEach(row -> row.getResponse().put("@canDelete", String.valueOf(false)));
            return;
        }
        this.checkLimitCondition(handler, resultData, permission, user, "@canDelete");
    }

    private void checkLimitCondition(EntityHandler handler, SearchResultData resultData, EntityPermission permission, AuthContextHolder user, String responseKey) {
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext((Permission)permission);
        if (eac.hasLimitCondition(permission, user)) {
            final boolean versionSpecified = handler.isVersioned();
            Query q = new Query().select(new Object[]{"oid"}).from(handler.getMetaData().getName());
            if (versionSpecified) {
                q.select().add((Object)"version");
            }
            Object cond = null;
            List<SearchResultRow> rows = resultData.getRows();
            if (rows.size() > 1) {
                ArrayList oids = new ArrayList();
                resultData.getRows().forEach(row -> {
                    if (versionSpecified) {
                        oids.add(new RowValueList(new ValueExpression[]{new Literal((Object)row.getEntity().getOid()), new Literal((Object)row.getEntity().getVersion())}));
                    } else {
                        oids.add(new Literal((Object)row.getEntity().getOid()));
                    }
                });
                In in = versionSpecified ? new In(new String[]{"oid", "version"}, (Object[][])new Object[0][]) : new In("oid", new Object[0]);
                in.setValue(oids);
                cond = in;
            } else {
                cond = versionSpecified ? new And(new Condition[]{new Equals("oid", (Object)rows.get(0).getEntity().getOid()), new Equals("version", (Object)rows.get(0).getEntity().getVersion())}) : new Equals("oid", (Object)rows.get(0).getEntity().getOid());
            }
            q.where((Condition)cond);
            Query transQuery = eac.modifyQuery(q, permission.getAction(), user);
            final ArrayList oids = new ArrayList();
            AuthContext.doPrivileged(() -> new EntityQueryInvocationImpl(transQuery, new SearchOption().unnotifyListeners(), (Predicate)new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    if (versionSpecified) {
                        oids.add((String)dataModel[0] + "." + dataModel[1]);
                    } else {
                        oids.add((String)dataModel[0]);
                    }
                    return true;
                }
            }, InvocationType.SEARCH, handler.getService().getInterceptors(), handler).proceed());
            resultData.getRows().forEach(row -> {
                Entity entity = row.getEntity();
                String ct = versionSpecified ? entity.getOid() + "." + entity.getVersion() : entity.getOid();
                if (!oids.contains(ct)) {
                    row.getResponse().put(responseKey, String.valueOf(false));
                }
            });
        }
    }
}

