/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.upload;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.iplass.gem.GemConfigService;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.impl.entity.csv.EntityCsvWriter;
import org.iplass.mtp.impl.entity.csv.EntityWriteOption;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.web.ResultStreamWriter;
import org.iplass.mtp.web.template.TemplateUtil;

@ActionMapping(name="gem/generic/upload/sample", displayName="CSV\u30b5\u30f3\u30d7\u30eb\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.STREAM, useContentDisposition=true)})
@CommandClass(name="gem/generic/upload/CsvSampleDownloadCommand", displayName="CSV\u30b5\u30f3\u30d7\u30eb\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9")
public final class CsvSampleDownloadCommand
implements Command {
    public static final String ACTION_NAME = "gem/generic/upload/sample";
    private static final String DEFAULT_CHAR_SET = "UTF-8";
    private static final String ENTITY_NAME_BINDING_NAME = "entityName";
    private static final String ENTITY_DISP_BINDING_NAME = "entityDisplayName";
    private static final String VIEW_NAME_BINDING_NAME = "viewName";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
    private GemConfigService gcs = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String viewName = request.getParam(VIEW_NAME_BINDING_NAME);
        EntityDefinition ed = this.edm.get(defName);
        EntityView ev = (EntityView)this.evm.get(defName);
        HashMap<String, Object> csvVariableMap = new HashMap<String, Object>();
        csvVariableMap.put(ENTITY_NAME_BINDING_NAME, ed.getName());
        csvVariableMap.put(ENTITY_DISP_BINDING_NAME, TemplateUtil.getMultilingualString((String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList()));
        csvVariableMap.put(VIEW_NAME_BINDING_NAME, StringUtil.isEmpty((String)viewName) ? null : viewName);
        String defaultName = TemplateUtil.getMultilingualString((String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList());
        String filename = this.evm.getCsvDownloadFileName(defName, viewName, defaultName, csvVariableMap) + ".csv";
        request.setAttribute("fileName", (Object)filename);
        request.setAttribute("contentType", (Object)("text/csv;charset=" + this.getCharacterCode(request)));
        request.setAttribute("streamData", (Object)new CSVDownloadSampleWriter(this.getCharacterCode(request), ed, ev, viewName));
        return "SUCCESS";
    }

    private String getCharacterCode(RequestContext request) {
        if (StringUtil.isEmpty((String)request.getParam("characterCode"))) {
            return DEFAULT_CHAR_SET;
        }
        return request.getParam("characterCode");
    }

    private class CSVDownloadSampleWriter
    implements ResultStreamWriter {
        private String charset;
        private EntityDefinition ed;
        private SearchConditionSection condition;
        private SearchResultSection result;

        public CSVDownloadSampleWriter(String charset, EntityDefinition ed, EntityView ev, String viewName) {
            this.charset = charset;
            this.ed = ed;
            SearchFormView form = FormViewUtil.getSearchFormView(ed, ev, viewName);
            this.condition = form != null ? form.getCondSection() : null;
            this.result = form != null ? form.getResultSection() : null;
        }

        public void write(OutputStream out) throws IOException {
            ArrayList<String> directProperties = null;
            if (this.condition != null && this.condition.getCsvdownloadUploadableProperties() != null) {
                directProperties = new ArrayList<String>(this.condition.getCsvdownloadUploadablePropertiesSet());
            }
            EntityWriteOption option = new EntityWriteOption().charset(this.charset).quoteAll(CsvSampleDownloadCommand.this.gcs.isCsvDownloadQuoteAll()).withReferenceVersion(CsvSampleDownloadCommand.this.gcs.isCsvDownloadReferenceVersion()).properties(directProperties).columnDisplayName(property -> this.getColumnName((PropertyDefinition)property));
            try (EntityCsvWriter writer = new EntityCsvWriter(this.ed, out, option);){
                writer.writeHeader();
                for (int i = 0; i < 2; ++i) {
                    Entity entity = this.createDummyEntity(writer.getProperties());
                    writer.writeEntity(entity);
                }
            }
        }

        private String getColumnName(PropertyDefinition property) {
            String displayLabel;
            PropertyColumn column = this.getPropertyColumn(property);
            if (column != null && StringUtil.isNotEmpty((String)column.getDisplayLabel()) && (displayLabel = TemplateUtil.getMultilingualString((String)column.getDisplayLabel(), column.getLocalizedDisplayLabelList())) != null) {
                return "(" + displayLabel + ")";
            }
            return "(" + TemplateUtil.getMultilingualString((String)property.getDisplayName(), (List)property.getLocalizedDisplayNameList()) + ")";
        }

        public PropertyColumn getPropertyColumn(PropertyDefinition property) {
            if (this.result == null) {
                return null;
            }
            Optional<PropertyColumn> column = this.result.getElements().stream().filter(e -> e instanceof PropertyColumn).map(e -> (PropertyColumn)e).filter(e -> property.getName().equals(e.getPropertyName())).findFirst();
            if (column.isPresent()) {
                return column.get();
            }
            return null;
        }

        private Entity createDummyEntity(List<PropertyDefinition> properties) {
            GenericEntity entity = new GenericEntity();
            for (PropertyDefinition pd : properties) {
                String propName = pd.getName();
                if (propName.equals("oid")) {
                    entity.setOid(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7));
                    continue;
                }
                if (propName.equals("state")) {
                    entity.setState(new SelectValue("V", "\u6709\u52b9"));
                    continue;
                }
                String createBy = "mtp" + RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)3);
                if (propName.equals("createBy")) {
                    entity.setCreateBy(createBy);
                    continue;
                }
                String updateBy = "mtp" + RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)3);
                if (propName.equals("updateBy")) {
                    entity.setUpdateBy(updateBy);
                    continue;
                }
                if (pd instanceof BinaryProperty) continue;
                if (pd instanceof BooleanProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)true);
                        continue;
                    }
                    entity.setValue(propName, (Object)new Boolean[]{true, false});
                    continue;
                }
                if (pd instanceof DateProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)DateUtil.getCurrentDate());
                        continue;
                    }
                    entity.setValue(propName, (Object)new Date[]{DateUtil.getCurrentDate(), DateUtil.getCurrentDate()});
                    continue;
                }
                if (pd instanceof DateTimeProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)DateUtil.getCurrentTimestamp());
                        continue;
                    }
                    entity.setValue(propName, (Object)new Timestamp[]{DateUtil.getCurrentTimestamp(), DateUtil.getCurrentTimestamp()});
                    continue;
                }
                if (pd instanceof DecimalProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)new BigDecimal(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)));
                        continue;
                    }
                    entity.setValue(propName, (Object)new BigDecimal[]{new BigDecimal(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)), new BigDecimal(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7))});
                    continue;
                }
                if (pd instanceof ExpressionProperty) continue;
                if (pd instanceof FloatProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)new Double(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)));
                        continue;
                    }
                    entity.setValue(propName, (Object)new Double[]{new Double(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)), new Double(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7))});
                    continue;
                }
                if (pd instanceof IntegerProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)new Long(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)));
                        continue;
                    }
                    entity.setValue(propName, (Object)new Long[]{new Long(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)), new Long(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7))});
                    continue;
                }
                if (pd instanceof LongTextProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)"\u30ed\u30f3\u30b0\u30c6\u30ad\u30b9\u30c8\n\u30b5\u30f3\u30d7\u30eb");
                        continue;
                    }
                    entity.setValue(propName, (Object)new String[]{"\u30ed\u30f3\u30b0\u30c6\u30ad\u30b9\u30c8\n\u30b5\u30f3\u30d7\u30eb", "\u30ed\u30f3\u30b0\u30c6\u30ad\u30b9\u30c8\n\u30b5\u30f3\u30d7\u30eb"});
                    continue;
                }
                if (pd instanceof ReferenceProperty) {
                    if (pd.getMultiplicity() == 1) {
                        GenericEntity refEntity = new GenericEntity();
                        refEntity.setOid(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7));
                        refEntity.setVersion(new Long(0L));
                        entity.setValue(propName, (Object)refEntity);
                        continue;
                    }
                    GenericEntity ref1Entity = new GenericEntity();
                    ref1Entity.setOid(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7));
                    ref1Entity.setVersion(new Long(0L));
                    GenericEntity ref2Entity = new GenericEntity();
                    ref2Entity.setOid(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7));
                    ref2Entity.setVersion(new Long(0L));
                    entity.setValue(propName, (Object)new Entity[]{ref1Entity, ref2Entity});
                    continue;
                }
                if (pd instanceof SelectProperty) {
                    if (pd.getMultiplicity() == 1) {
                        SelectValue selectValue = (SelectValue)((SelectProperty)pd).getSelectValueList().get(0);
                        entity.setValue(propName, (Object)selectValue);
                        continue;
                    }
                    SelectValue selectValue1 = (SelectValue)((SelectProperty)pd).getSelectValueList().get(0);
                    if (((SelectProperty)pd).getSelectValueList().size() > 1) {
                        SelectValue selectValue2 = (SelectValue)((SelectProperty)pd).getSelectValueList().get(1);
                        entity.setValue(propName, (Object)new SelectValue[]{selectValue1, selectValue2});
                        continue;
                    }
                    entity.setValue(propName, (Object)new SelectValue[]{selectValue1});
                    continue;
                }
                if (pd instanceof StringProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)RandomStringUtils.random((int)10, (String)"abcdefghtjklmnopqrstuvwxyz"));
                        continue;
                    }
                    entity.setValue(propName, (Object)new String[]{RandomStringUtils.random((int)10, (String)"abcdefghtjklmnopqrstuvwxyz"), RandomStringUtils.random((int)10, (String)"abcdefghtjklmnopqrstuvwxyz")});
                    continue;
                }
                if (pd instanceof TimeProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)DateUtil.getCurrentTime());
                        continue;
                    }
                    entity.setValue(propName, (Object)new Time[]{DateUtil.getCurrentTime(), DateUtil.getCurrentTime()});
                    continue;
                }
                if (pd instanceof AutoNumberProperty) {
                    if (pd.getMultiplicity() == 1) {
                        entity.setValue(propName, (Object)(RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)));
                        continue;
                    }
                    entity.setValue(propName, (Object)new String[]{RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7), RandomStringUtils.random((int)1, (String)"123456789") + RandomStringUtils.randomNumeric((int)7)});
                    continue;
                }
                throw new EntityRuntimeException("can not convert property : " + pd.getClass().getName());
            }
            this.setOidValue((Entity)entity);
            return entity;
        }

        private void setOidValue(Entity entity) {
            if (this.ed.getOidPropertyName() != null) {
                String oidValue = "";
                int cnt = 0;
                for (String propName : this.ed.getOidPropertyName()) {
                    oidValue = cnt == 0 ? (String)entity.getValue(propName) : oidValue + "-" + entity.getValue(propName);
                    ++cnt;
                }
                if (StringUtil.isNotEmpty((String)oidValue)) {
                    entity.setOid(oidValue);
                }
            }
        }
    }
}

