/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.upload;

import java.io.InputStream;
import java.util.Set;
import org.iplass.gem.GemConfigService;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.generic.detail.DetailCommandBase;
import org.iplass.gem.command.generic.detail.DetailCommandContext;
import org.iplass.gem.command.generic.upload.CsvUploadUtil;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.TokenCheck;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.csv.CsvUploadStatus;
import org.iplass.mtp.impl.csv.TransactionType;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="gem/generic/upload/bin", displayName="CSV\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9", paramMapping={@ParamMapping(name="defName", mapFrom="${0}", condition="subPath.length==1"), @ParamMapping(name="viewName", mapFrom="${0}", condition="subPath.length==2"), @ParamMapping(name="defName", mapFrom="${1}", condition="subPath.length==2")}, result={@Result(status="SUCCESS", type=Result.Type.JSP, value="/jsp/gem/generic/upload/csvUploadResult.jsp", templateName="gem/generic/upload/csvUploadResult", layoutActionName="gem/layout/defaultLayout"), @Result(status="SUCCESS_ASYNC", type=Result.Type.TEMPLATE, value="gem/generic/upload/csvUpload"), @Result(status="FAILURE", type=Result.Type.TEMPLATE, value="gem/generic/upload/csvUpload"), @Result(status="ERROR_VIEW", type=Result.Type.TEMPLATE, value="gem/generic/common/error", layoutActionName="gem/layout/defaultLayout")}, tokenCheck=@TokenCheck)
@CommandClass(name="gem/generic/upload/CsvUploadCommand", displayName="CSV\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9")
public final class CsvUploadCommand
extends DetailCommandBase {
    private static Logger logger = LoggerFactory.getLogger(CsvUploadCommand.class);
    public static final String ACTION_NAME = "gem/generic/upload/bin";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(RequestContext request) {
        Throwable throwable;
        InputStream is;
        DetailCommandContext context = this.getContext(request);
        String uniqueKey = request.getParam("uniqueKey");
        UploadFileHandle file = request.getParamAsFile("filePath");
        EntityDefinition ed = context.getEntityDefinition();
        String viewName = context.getViewName();
        String defName = ed.getName();
        EntityView view = (EntityView)this.evm.get(ed.getName());
        SearchFormView form = FormViewUtil.getSearchFormView(ed, view, viewName);
        if (form == null) {
            request.setAttribute("message", (Object)GemResourceBundleUtil.resourceString("command.generic.upload.CSVUploadCommand.viewErr", new Object[0]));
            return "ERROR_VIEW";
        }
        request.setAttribute("entityDefinition", (Object)ed);
        request.setAttribute("detailFormView", (Object)context.getView());
        request.setAttribute("searchCond", (Object)context.getSearchCond());
        request.setAttribute("requiredProperties", (Object)CsvUploadUtil.getRequiredProperties(ed));
        GemConfigService gcs = (GemConfigService)ServiceRegistry.getRegistry().getService(GemConfigService.class);
        int commitLimit = gcs.getCsvUploadCommitCount();
        boolean isDenyInsert = form.getCondSection().isCsvUploadDenyInsert();
        boolean isDenyUpdate = form.getCondSection().isCsvUploadDenyUpdate();
        boolean isDenyDelete = form.getCondSection().isCsvUploadDenyDelete();
        Set<String> insertProperties = form.getCondSection().getCsvUploadInsertPropertiesSet();
        Set<String> updateProperties = form.getCondSection().getCsvUploadUpdatePropertiesSet();
        SearchConditionSection.CsvUploadTransactionType csvUploadTransactionType = form.getCondSection().getCsvUploadTransactionType();
        CsvUploadService service = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
        if (file == null) {
            request.setAttribute("message", (Object)GemResourceBundleUtil.resourceString("command.generic.upload.CSVUploadCommand.selectFileMsg", new Object[0]));
            return "FAILURE";
        }
        if (gcs.isCsvUploadAsync()) {
            try (InputStream is2 = file.getInputStream();){
                service.asyncUpload(is2, file.getFileName(), defName, viewName, uniqueKey, isDenyInsert, isDenyUpdate, isDenyDelete, insertProperties, updateProperties, this.toTransactionType(csvUploadTransactionType), commitLimit, gcs.isCsvDownloadReferenceVersion(), form.isDeleteSpecificVersion());
                String string3 = "SUCCESS_ASYNC";
                return string3;
            }
            catch (ApplicationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                request.setAttribute("message", (Object)StringUtil.escapeHtml((String)e.getMessage()).replace("\n", "<br/>"));
                return "FAILURE";
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                request.setAttribute("message", (Object)GemResourceBundleUtil.resourceString("command.generic.upload.CSVUploadCommand.errReadFile", new Object[0]));
                return "FAILURE";
            }
        }
        try {
            is = file.getInputStream();
            throwable = null;
            try {
                service.validate(is, defName, gcs.isCsvDownloadReferenceVersion());
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (EntityCsvException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("message", (Object)StringUtil.escapeHtml((String)e.getMessage()).replace("\n", "<br/>"));
            return "FAILURE";
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("message", (Object)StringUtil.escapeHtml((String)e.getMessage()).replace("\n", "<br/>"));
            return "FAILURE";
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("message", (Object)GemResourceBundleUtil.resourceString("command.generic.upload.CSVUploadCommand.errReadFile", new Object[0]));
            return "FAILURE";
        }
        try {
            is = file.getInputStream();
            throwable = null;
            try {
                CsvUploadStatus result = service.upload(is, defName, uniqueKey, isDenyInsert, isDenyUpdate, isDenyDelete, insertProperties, updateProperties, this.toTransactionType(csvUploadTransactionType), commitLimit, gcs.isCsvDownloadReferenceVersion(), form.isDeleteSpecificVersion());
                request.setAttribute("message", result.getMessage() != null ? StringUtil.escapeHtml((String)result.getMessage()).replace("\n", "<br/>") : null);
                request.setAttribute("insertCount", (Object)result.getInsertCount());
                request.setAttribute("updateCount", (Object)result.getUpdateCount());
                request.setAttribute("deleteCount", (Object)result.getDeleteCount());
                if (result.getStatus() == TaskStatus.COMPLETED) {
                    String string2 = "SUCCESS";
                    return string2;
                }
                String string = "FAILURE";
                return string;
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (ApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("message", (Object)StringUtil.escapeHtml((String)e.getMessage()).replace("\n", "<br/>"));
            return "FAILURE";
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("message", (Object)GemResourceBundleUtil.resourceString("command.generic.upload.CSVUploadCommand.errReadFile", new Object[0]));
            return "FAILURE";
        }
    }

    private TransactionType toTransactionType(SearchConditionSection.CsvUploadTransactionType tt) {
        if (tt == null) {
            return null;
        }
        switch (tt) {
            case ONCE: {
                return TransactionType.ONCE;
            }
            case DIVISION: {
                return TransactionType.DIVISION;
            }
        }
        return null;
    }
}

