/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.generic.upload;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.gem.command.ViewUtil;
import org.iplass.gem.command.generic.upload.CsvUploadStatusData;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.csv.CsvUploadService;
import org.iplass.mtp.impl.csv.CsvUploadStatus;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/generic/upload/status", displayName=" CSV\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30b9\u30c6\u30fc\u30bf\u30b9\u78ba\u8a8d", accepts={RequestType.REST_FORM, RequestType.REST_JSON, RequestType.REST_XML}, methods={MethodType.POST}, results={"result"})
@CommandClass(name="gem/generic/upload/CsvUploadStatusCommand", displayName="CSV\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u30b9\u30c6\u30fc\u30bf\u30b9\u78ba\u8a8d")
public final class CsvUploadStatusCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/generic/upload/status";
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);

    public String execute(RequestContext request) {
        LocaleFormat lf = ExecuteContext.getCurrentContext().getLocaleFormat();
        SimpleDateFormat sdf = DateUtil.getSimpleDateFormat((String)lf.getOutputDatetimeSecFormat(), (boolean)true);
        CsvUploadService service = (CsvUploadService)ServiceRegistry.getRegistry().getService(CsvUploadService.class);
        List statusList = service.getStatus();
        ArrayList<CsvUploadStatusData> resultList = new ArrayList<CsvUploadStatusData>();
        HashMap<String, String> dispNames = new HashMap<String, String>();
        for (CsvUploadStatus status : statusList) {
            CsvUploadStatusData result = new CsvUploadStatusData();
            result.setInsertCount(status.getInsertCount());
            result.setUpdateCount(status.getUpdateCount());
            result.setDeleteCount(status.getDeleteCount());
            result.setFileName(status.getFileName());
            result.setUploadDate(sdf.format(status.getUploadDateTime()));
            result.setStatus(status.getStatus());
            result.setStatusLabel(GemResourceBundleUtil.resourceString("generic.csvUploadAsyncResult.status." + status.getStatus().name(), new Object[0]));
            result.setMessage(status.getMessage() != null ? StringUtil.escapeHtml((String)status.getMessage()).replace("\n", "<br/>") : null);
            String defName = status.getDefName();
            String viewName = status.getParameter();
            String dispNameKey = defName + "_" + (viewName != null ? viewName : "");
            if (dispNames.containsKey(dispNameKey)) {
                result.setTargetDisplayName((String)dispNames.get(dispNameKey));
            } else {
                String dispName = this.getDisplayName(defName, viewName);
                dispNames.put(dispNameKey, dispName);
                result.setTargetDisplayName(dispName);
            }
            resultList.add(result);
        }
        request.setAttribute("result", resultList);
        return "SUCCESS";
    }

    private String getDisplayName(String defName, String viewName) {
        EntityDefinition ed = this.edm.get(defName);
        if (ed == null) {
            return "";
        }
        FormView formView = ViewUtil.getFormView(defName, viewName, true);
        if (formView != null) {
            return TemplateUtil.getMultilingualString((String)formView.getTitle(), formView.getLocalizedTitleList(), (String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList());
        }
        return TemplateUtil.getMultilingualString((String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList());
    }
}

