/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.information;

import java.sql.Date;
import java.sql.Timestamp;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.policy.definition.AuthenticationPolicyDefinition;
import org.iplass.mtp.auth.policy.definition.AuthenticationPolicyDefinitionManager;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.impl.util.InternalDateUtil;
import org.iplass.mtp.view.top.parts.InformationParts;

@ActionMapping(name="gem/information/list", displayName="\u304a\u77e5\u3089\u305b\u4e00\u89a7", result={@Result(type=Result.Type.JSP, value="/jsp/gem/information/list.jsp", templateName="gem/information/list")})
@CommandClass(name="gem/information/InformationCommand", displayName="\u304a\u77e5\u3089\u305b\u4e00\u89a7")
public final class InformationListCommand
implements Command {
    public static final String ACTION_NAME = "gem/information/list";
    public static final String INFORMATION_ENTITY = "mtp.Information";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private AuthManager am = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);
    private AuthenticationPolicyDefinitionManager apdm = (AuthenticationPolicyDefinitionManager)ManagerLocator.getInstance().getManager(AuthenticationPolicyDefinitionManager.class);

    public String execute(RequestContext request) {
        this.searchInfo(request);
        this.checkPasswordAge(request);
        return "SUCCESS";
    }

    private void searchInfo(RequestContext request) {
        Timestamp value = this.em.getCurrentTimestamp();
        And a = new And();
        a.addExpression((Condition)new LesserEqual("startDate", (Object)value));
        a.addExpression((Condition)new GreaterEqual("endDate", (Object)value));
        Query q = new Query();
        q.select(new Object[]{"oid", "name", "version", "startDate"}).from(INFORMATION_ENTITY).where((Condition)a).order(new SortSpec[]{new SortSpec("startDate", SortSpec.SortType.DESC), new SortSpec("oid", SortSpec.SortType.DESC)});
        request.setAttribute("data", (Object)this.em.searchEntity(q).getList());
    }

    private void checkPasswordAge(RequestContext request) {
        InformationParts infoParts = (InformationParts)request.getAttribute("infoSetting");
        if (infoParts == null || !infoParts.isShowWarningPasswordAge().booleanValue()) {
            return;
        }
        AuthContext auth = AuthContext.getCurrentContext();
        User user = auth.getUser();
        if (user == null || user.isAnonymous()) {
            return;
        }
        Date lastPasswordChange = (Date)auth.getAttribute("lastPasswordChange");
        if (lastPasswordChange == null) {
            return;
        }
        lastPasswordChange = InternalDateUtil.truncateTime((Date)lastPasswordChange);
        if (!this.am.canUpdateCredential(auth.getPolicyName())) {
            return;
        }
        AuthenticationPolicyDefinition policy = this.apdm.getOrDefault(auth.getPolicyName());
        int maxAge = policy.getPasswordPolicy().getMaximumPasswordAge();
        if (maxAge <= 0) {
            return;
        }
        Date limitDate = InternalDateUtil.addDays((Date)lastPasswordChange, (int)maxAge);
        Date now = new Date(System.currentTimeMillis());
        int days = InternalDateUtil.diffDays((Date)limitDate, (Date)(now = InternalDateUtil.truncateTime((Date)now)));
        if (days <= infoParts.getPasswordWarningAge()) {
            request.setAttribute("infoPasswordWarning", (Object)Boolean.TRUE);
            request.setAttribute("infoPasswordRemainingDays", (Object)days);
        }
    }
}

