/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.preview;

import java.sql.Timestamp;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.preview.PreviewHandler;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.view.top.parts.PreviewDateParts;
import org.iplass.mtp.web.template.TemplateUtil;

@ActionMapping(name="gem/preview/index", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, displayName="\u30d7\u30ec\u30d3\u30e5\u30fc\u65e5\u4ed8\u753b\u9762\u8868\u793a", result={@Result(status="SUCCESS", type=Result.Type.JSP, value="/jsp/gem/layout/previewDate.jsp", templateName="gem/preview/previewDate", layoutActionName="gem/layout/popupLayout")})
@CommandClass(name="gem/preview/PreviewDateViewCommand", displayName="\u30d7\u30ec\u30d3\u30e5\u30fc\u65e5\u4ed8\u753b\u9762\u8868\u793a")
public final class PreviewDateViewCommand
implements Command {
    public static final String ACTION_NAME = "gem/preview/index";
    public static final String TITLE = "previewDateTitle";
    public static final String PREVIEW_DATE = "previewDate";

    public String execute(RequestContext request) {
        PreviewDateParts previewDateParts;
        TenantWebInfo webInfo = WebUtil.getTenantWebInfo((Tenant)TemplateUtil.getTenant());
        if (!webInfo.isUsePreview()) {
            throw new ApplicationException("not allowed to set preview date.");
        }
        String titlePreviewDate = null;
        TopViewDefinitionManager tvdm = (TopViewDefinitionManager)ManagerLocator.manager(TopViewDefinitionManager.class);
        TopViewDefinition topView = tvdm.getRequestTopView();
        if (topView != null && (previewDateParts = tvdm.getTopViewParts(topView, PreviewDateParts.class)) != null) {
            if (!previewDateParts.isUsePreviewDate()) {
                throw new ApplicationException("not allowed to set preview date.");
            }
            titlePreviewDate = TemplateUtil.getMultilingualString((String)previewDateParts.getTitle(), previewDateParts.getLocalizedTitleList());
        }
        if (titlePreviewDate == null) {
            titlePreviewDate = GemResourceBundleUtil.resourceString("layout.header.previewDate", new Object[0]);
        }
        PreviewHandler handler = new PreviewHandler();
        Timestamp previewDate = handler.getPreviewDate(request);
        request.setAttribute(TITLE, (Object)titlePreviewDate);
        request.setAttribute(PREVIEW_DATE, (Object)previewDate);
        return "SUCCESS";
    }
}

