/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.preview;

import java.sql.Timestamp;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.preview.PreviewHandler;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.web.TenantWebInfo;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.TopViewDefinitionManager;
import org.iplass.mtp.view.top.parts.PreviewDateParts;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;

@WebApi(name="gem/preview/setPreviewDateTime", accepts={RequestType.REST_JSON}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"dateTime"}, checkXRequestedWithHeader=true)
@CommandClass(name="gem/preview/SetPreviewDateTimeCommand", displayName="\u30d7\u30ec\u30d3\u30e5\u30fc\u65e5\u6642\u5909\u66f4")
public final class SetPreviewDateTimeCommand
implements Command {
    public static final String WEBAPI_NAME = "gem/preview/setPreviewDateTime";
    public static final String KEY_DATE_TIME = "dateTime";
    private PreviewHandler preview = new PreviewHandler();

    public String execute(RequestContext request) {
        PreviewDateParts previewDateParts;
        TenantWebInfo webInfo = WebUtil.getTenantWebInfo((Tenant)TemplateUtil.getTenant());
        if (!webInfo.isUsePreview()) {
            throw new ApplicationException("not allowed to set preview date.");
        }
        TopViewDefinitionManager tvdm = (TopViewDefinitionManager)ManagerLocator.manager(TopViewDefinitionManager.class);
        TopViewDefinition topView = tvdm.getRequestTopView();
        if (topView != null && (previewDateParts = tvdm.getTopViewParts(topView, PreviewDateParts.class)) != null && !previewDateParts.isUsePreviewDate()) {
            throw new ApplicationException("not allowed to set preview date.");
        }
        Timestamp ts = request.getParamAsTimestamp(KEY_DATE_TIME, "yyyyMMddHHmmss");
        this.preview.setPreviewDate(ts, request);
        return "SUCCESS";
    }
}

