/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.treeview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.gem.command.common.JsonStreamingOutput;
import org.iplass.gem.command.common.TreeGridData;
import org.iplass.gem.command.treeview.EntityDefinitionNode;
import org.iplass.gem.command.treeview.EntityNode;
import org.iplass.gem.command.treeview.IndexNode;
import org.iplass.gem.command.treeview.TreeNodeData;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.treeview.ReferenceTreeViewItem;
import org.iplass.mtp.view.treeview.TreeView;
import org.iplass.mtp.view.treeview.TreeViewGridColModel;
import org.iplass.mtp.view.treeview.TreeViewGridColModelMapping;
import org.iplass.mtp.view.treeview.TreeViewItem;
import org.iplass.mtp.view.treeview.TreeViewManager;
import org.iplass.mtp.web.actionmapping.permission.ActionParameter;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/treeview/getTreeViewGridData", displayName="\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u30b0\u30ea\u30c3\u30c9\u53d6\u5f97", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"data"}, checkXRequestedWithHeader=true)
@Template(name="gem/treeview/treeViewWidget", displayName="\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u30a6\u30a3\u30b8\u30a7\u30c3\u30c8", path="/jsp/gem/treeview/treeViewList.jsp")
@CommandClass(name="gem/treeview/GetTreeViewGridDataCommand", displayName="\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u30b0\u30ea\u30c3\u30c9\u30c7\u30fc\u30bf\u53d6\u5f97")
public final class GetTreeViewGridDataCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(GetTreeViewGridDataCommand.class);
    public static final String WEBAPI_NAME = "gem/treeview/getTreeViewGridData";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private TreeViewManager tvm = (TreeViewManager)ManagerLocator.getInstance().getManager(TreeViewManager.class);

    public String execute(RequestContext request) {
        int level;
        String nodeid;
        String defName;
        block10: {
            defName = request.getParam("defName");
            nodeid = request.getParam("nodeid");
            String _level = request.getParam("n_level");
            level = 0;
            if (_level != null) {
                try {
                    level = Integer.parseInt(_level) + 1;
                }
                catch (NumberFormatException e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        NodeInfo nodeInfo = new NodeInfo(nodeid, level);
        TreeView treeView = (TreeView)this.tvm.get(defName);
        List<TreeNodeData> nodes = null;
        if (nodeInfo.isInit()) {
            nodes = this.initTreeView(treeView, nodeInfo);
        } else if (nodeInfo.isEntityDefinition()) {
            TreeViewItem item = treeView.getItem(nodeInfo.getCurrentPath());
            nodes = this.underEntityDefinition(item, nodeInfo, treeView.getColModel());
        } else if (nodeInfo.isIndex()) {
            TreeViewItem item = treeView.getItem(nodeInfo.getCurrentPath());
            nodes = this.underIndex(item, nodeInfo, treeView.getColModel());
        } else if (nodeInfo.isEntity()) {
            TreeViewItem item = treeView.getItem(nodeInfo.getCurrentPath());
            nodes = this.underEntity(item, nodeInfo, treeView.getColModel());
        }
        request.setAttribute("data", (Object)new JsonStreamingOutput(new TreeGridData<TreeNodeData>(nodes)));
        return null;
    }

    private List<TreeNodeData> initTreeView(TreeView treeView, NodeInfo nodeInfo) {
        AuthContext authContext = AuthContext.getCurrentContext();
        ArrayList<TreeNodeData> nodes = new ArrayList<TreeNodeData>();
        for (final TreeViewItem item : treeView.getItems()) {
            if (!authContext.checkPermission((Permission)new ActionPermission("gem/generic/search/view", new ActionParameter(){

                public Object getValue(String name) {
                    if ("defName".equals(name)) {
                        return item.getDefName();
                    }
                    if ("viewName".equals(name)) {
                        return item.getViewName();
                    }
                    return null;
                }
            }))) continue;
            if (item.isDisplayDefinitionNode()) {
                TreeNodeData node = this.createEntityDefinitionNode(item, nodeInfo, treeView.getColModel());
                if (node == null) continue;
                nodes.add(node);
                continue;
            }
            List<TreeNodeData> _nodes = this.underEntityDefinition(item, nodeInfo, treeView.getColModel());
            if (_nodes == null || _nodes.isEmpty()) continue;
            nodes.addAll(_nodes);
        }
        return nodes;
    }

    private List<TreeNodeData> underEntityDefinition(TreeViewItem item, NodeInfo nodeInfo, List<TreeViewGridColModel> colModels) {
        ArrayList<TreeNodeData> nodes = new ArrayList<TreeNodeData>();
        int totalCount = this.count(item, nodeInfo.getOid());
        if (totalCount == 0) {
            return nodes;
        }
        if (totalCount > item.getLimit()) {
            int index = totalCount % item.getLimit() == 0 ? totalCount / item.getLimit() : totalCount / item.getLimit() + 1;
            String path = null;
            path = nodeInfo.isRoot() ? item.getDefName() : nodeInfo.getCurrentPath();
            for (int i = 0; i < index; ++i) {
                int _offset = item.getLimit() * i;
                IndexNode iNode = new IndexNode(path);
                iNode.setDisplayName(_offset + 1 + "\uff5e" + (_offset + item.getLimit()) + "\u4ef6");
                iNode.setIcon(item.getIndexNodeIcon());
                iNode.setCssStyle(item.getIndexNodeCssStyle());
                iNode.setOffset(_offset);
                iNode.setOid(nodeInfo.getOid());
                TreeNodeData data = new TreeNodeData(iNode, nodeInfo.getNodeid(), nodeInfo.getLevel(), nodeInfo.getOid(), _offset, new Object[colModels.size()]);
                nodes.add(data);
            }
        } else {
            nodes.addAll(this.createEntityNode(item, nodeInfo, colModels));
        }
        return nodes;
    }

    private List<TreeNodeData> underIndex(TreeViewItem item, NodeInfo nodeInfo, List<TreeViewGridColModel> colModels) {
        List<TreeNodeData> nodes = this.createEntityNode(item, nodeInfo, colModels);
        return nodes;
    }

    private List<TreeNodeData> underEntity(TreeViewItem item, NodeInfo nodeInfo, List<TreeViewGridColModel> colModels) {
        ArrayList<TreeNodeData> nodes = new ArrayList<TreeNodeData>();
        for (ReferenceTreeViewItem rItem : item.getReferenceTreeViewItems()) {
            NodeInfo newNodeInfo;
            if (rItem.isDisplayDefinitionNode()) {
                TreeNodeData rNode = this.createEntityDefinitionNode(rItem, nodeInfo, colModels);
                if (rNode == null) continue;
                nodes.add(rNode);
                continue;
            }
            NodeInfo nodeInfo2 = newNodeInfo = new NodeInfo(nodeInfo.getNodeid(), nodeInfo.getLevel());
            nodeInfo2.currentPath = nodeInfo2.currentPath + "/" + rItem.getPropertyName();
            List<TreeNodeData> _nodes = this.underEntityDefinition(rItem, newNodeInfo, colModels);
            if (_nodes == null || _nodes.isEmpty()) continue;
            nodes.addAll(_nodes);
        }
        return nodes;
    }

    private TreeNodeData createEntityDefinitionNode(TreeViewItem item, NodeInfo nodeInfo, List<TreeViewGridColModel> colModels) {
        int totalCount = this.count(item, nodeInfo.getOid());
        if (totalCount == 0) {
            return null;
        }
        EntityDefinitionNode edNode = null;
        if (item instanceof ReferenceTreeViewItem) {
            ReferenceTreeViewItem rItem = (ReferenceTreeViewItem)item;
            edNode = new EntityDefinitionNode(nodeInfo.getCurrentPath(), rItem.getPropertyName());
            edNode.setDisplayName(rItem.getDisplayName());
        } else {
            edNode = new EntityDefinitionNode(nodeInfo.getCurrentPath(), item.getDefName());
            String displayName = TemplateUtil.getMultilingualString((String)this.edm.get(item.getDefName()).getDisplayName(), (List)this.edm.get(item.getDefName()).getLocalizedDisplayNameList());
            edNode.setDisplayName(displayName);
        }
        edNode.setIcon(item.getEntityDefinitionNodeIcon());
        edNode.setCssStyle(item.getEntityDefinitionNodeCssStyle());
        TreeNodeData node = new TreeNodeData(edNode, nodeInfo.getNodeid(), nodeInfo.getLevel(), nodeInfo.getOid(), new Object[colModels.size()]);
        return node;
    }

    private List<TreeNodeData> createEntityNode(TreeViewItem item, NodeInfo nodeInfo, List<TreeViewGridColModel> colModels) {
        ArrayList<TreeNodeData> nodes = new ArrayList<TreeNodeData>();
        String path = null;
        path = nodeInfo.isRoot() ? item.getDefName() : nodeInfo.getCurrentPath();
        List<Object[]> entites = this.search(item, nodeInfo.getOffset(), nodeInfo.getOid(), colModels);
        for (Object[] values : entites) {
            EntityNode en = null;
            en = item instanceof ReferenceTreeViewItem ? new EntityNode(path, ((ReferenceTreeViewItem)item).getPropertyName()) : new EntityNode(path, item.getDefName());
            en.setOid(values[0].toString());
            en.setDisplayName(values[1].toString());
            en.setDefName(item.getDefName());
            en.setAction(item.getAction());
            en.setViewName(item.getViewName());
            en.setIcon(item.getEntityNodeIcon());
            en.setCssStyle(item.getEntityNodeCssStyle());
            en.setHasReference(!item.getReferenceTreeViewItems().isEmpty());
            Object[] propValues = null;
            propValues = values.length > 2 ? Arrays.copyOfRange(values, 2, values.length) : new Object[]{};
            TreeNodeData data = new TreeNodeData(en, nodeInfo.getNodeid(), nodeInfo.getLevel(), propValues);
            nodes.add(data);
        }
        return nodes;
    }

    private int count(TreeViewItem item, String oid) {
        Query cond = new Query();
        cond.select(new Object[]{"oid"});
        cond.select().setDistinct(true);
        cond.from(item.getDefName());
        if (oid != null && item instanceof ReferenceTreeViewItem) {
            cond.where(this.getCondition((ReferenceTreeViewItem)item, oid));
        }
        return this.em.count(cond);
    }

    private List<Object[]> search(TreeViewItem item, int offset, String oid, List<TreeViewGridColModel> colModels) {
        Query query = new Query();
        ArrayList<Object> select = new ArrayList<Object>();
        select.add(new EntityField("oid"));
        if (this.existProperty(item)) {
            if (this.isReferenceProperty(item)) {
                select.add(new EntityField(item.getDisplayPropertyName() + "." + "name"));
            } else {
                select.add(new EntityField(item.getDisplayPropertyName()));
            }
        } else {
            select.add(new EntityField("name"));
        }
        for (TreeViewGridColModel colModel : colModels) {
            TreeViewGridColModelMapping mapping = null;
            for (TreeViewGridColModelMapping tmp : item.getMapping()) {
                if (!colModel.getName().equals(tmp.getName())) continue;
                mapping = tmp;
            }
            if (mapping != null) {
                if (!this.existProperty(item, mapping.getMappingName())) {
                    select.add(new Literal((Object)""));
                    continue;
                }
                if (this.isReferenceProperty(item, mapping.getMappingName())) {
                    select.add(new EntityField(mapping.getMappingName() + "." + "name"));
                    continue;
                }
                select.add(new EntityField(mapping.getMappingName()));
                continue;
            }
            select.add(new Literal((Object)""));
        }
        query.select(select.toArray());
        query.from(item.getDefName());
        if (oid != null && item instanceof ReferenceTreeViewItem) {
            query.where(this.getCondition((ReferenceTreeViewItem)item, oid));
        }
        query.order(new SortSpec[]{this.getSortSpec(item)});
        if (offset > -1) {
            query.limit(item.getLimit(), offset);
        } else {
            query.limit(item.getLimit());
        }
        List list = this.em.search(query).getList();
        return list;
    }

    private boolean existProperty(TreeViewItem item) {
        if (item == null) {
            return false;
        }
        if (item.getDisplayPropertyName() == null) {
            return false;
        }
        EntityDefinition ed = this.edm.get(item.getDefName());
        return ed.getProperty(item.getDisplayPropertyName()) != null;
    }

    private boolean isReferenceProperty(TreeViewItem item) {
        if (item == null) {
            return false;
        }
        if (item.getDisplayPropertyName() == null) {
            return false;
        }
        EntityDefinition ed = this.edm.get(item.getDefName());
        PropertyDefinition pd = ed.getProperty(item.getDisplayPropertyName());
        if (pd == null) {
            return false;
        }
        return pd instanceof ReferenceProperty;
    }

    private boolean existProperty(TreeViewItem item, String propName) {
        if (item == null || propName == null) {
            return false;
        }
        EntityDefinition ed = this.edm.get(item.getDefName());
        PropertyDefinition pd = this.getPropertyDefinition(ed, propName);
        return pd != null;
    }

    private boolean isReferenceProperty(TreeViewItem item, String propName) {
        if (item == null || propName == null) {
            return false;
        }
        EntityDefinition ed = this.edm.get(item.getDefName());
        PropertyDefinition pd = this.getPropertyDefinition(ed, propName);
        if (pd == null) {
            return false;
        }
        return pd instanceof ReferenceProperty;
    }

    private PropertyDefinition getPropertyDefinition(EntityDefinition definition, String propName) {
        int firstDotIndex = propName.indexOf(46);
        if (firstDotIndex > 0) {
            EntityDefinition red;
            String topPropName = propName.substring(0, firstDotIndex);
            String subPropName = propName.substring(firstDotIndex + 1);
            PropertyDefinition topProperty = definition.getProperty(topPropName);
            if (topProperty instanceof ReferenceProperty && (red = this.edm.get(((ReferenceProperty)topProperty).getObjectDefinitionName())) != null) {
                return this.getPropertyDefinition(red, subPropName);
            }
        } else {
            return definition.getProperty(propName);
        }
        return null;
    }

    private Condition getCondition(ReferenceTreeViewItem item, String oid) {
        SubQuery sq = new SubQuery(new Query().select(new Object[]{item.getPropertyName() + "." + "oid"}).from(item.getParent().getDefName()).where((Condition)new Equals("oid", (Object)oid)));
        return new In("oid", sq);
    }

    private SortSpec getSortSpec(TreeViewItem item) {
        String sortKey = item.getSortItem() != null ? item.getSortItem() : "oid";
        SortSpec.SortType type = SortSpec.SortType.ASC;
        if (item.getSortType() != null && item.getSortType().equals((Object)TreeViewItem.TreeSortType.DESC)) {
            type = SortSpec.SortType.DESC;
        }
        return new SortSpec(sortKey, type);
    }

    private class NodeInfo {
        private String nodeid;
        private int level;
        private String type;
        private String oid;
        private int offset = -1;
        private String currentPath;

        public NodeInfo(String nodeid, int level) {
            this.nodeid = nodeid;
            this.level = level;
            if (nodeid != null) {
                String[] type_nodeid = nodeid.split("/", 2);
                this.type = type_nodeid[0];
                if ("D".equals(this.type)) {
                    String[] oid_nodeid = type_nodeid[1].split("/", 2);
                    this.oid = oid_nodeid[0];
                    this.currentPath = oid_nodeid[1];
                } else if ("I".equals(this.type)) {
                    String[] offset_nodeid;
                    block9: {
                        String[] oid_nodeid = type_nodeid[1].split("/", 2);
                        this.oid = oid_nodeid[0];
                        offset_nodeid = oid_nodeid[1].split("/", 2);
                        try {
                            this.offset = Integer.parseInt(offset_nodeid[0]);
                        }
                        catch (NumberFormatException e) {
                            if (!logger.isDebugEnabled()) break block9;
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                    this.currentPath = offset_nodeid[1];
                } else if ("E".equals(this.type)) {
                    String[] oid_nodeid = type_nodeid[1].split("/", 2);
                    this.oid = oid_nodeid[0];
                    this.currentPath = oid_nodeid[1];
                }
            } else {
                this.oid = "root";
            }
        }

        public String getNodeid() {
            return this.nodeid;
        }

        public int getLevel() {
            return this.level;
        }

        public String getOid() {
            if (this.isRoot()) {
                return null;
            }
            return this.oid;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getCurrentPath() {
            return this.currentPath;
        }

        public boolean isRoot() {
            return "root".equals(this.oid);
        }

        public boolean isInit() {
            return StringUtil.isBlank((String)this.nodeid);
        }

        public boolean isEntityDefinition() {
            return "D".equals(this.type);
        }

        public boolean isIndex() {
            return "I".equals(this.type);
        }

        public boolean isEntity() {
            return "E".equals(this.type);
        }
    }
}

