/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.treeview;

import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.common.JsonStreamingOutput;
import org.iplass.gem.command.treeview.EntityDefinitionNode;
import org.iplass.gem.command.treeview.EntityNode;
import org.iplass.gem.command.treeview.IndexNode;
import org.iplass.gem.command.treeview.TreeViewJqTreeData;
import org.iplass.gem.command.treeview.TreeViewNode;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.webapi.RestJson;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.treeview.ReferenceTreeViewItem;
import org.iplass.mtp.view.treeview.TreeView;
import org.iplass.mtp.view.treeview.TreeViewItem;
import org.iplass.mtp.view.treeview.TreeViewManager;
import org.iplass.mtp.web.actionmapping.permission.ActionParameter;
import org.iplass.mtp.web.actionmapping.permission.ActionPermission;
import org.iplass.mtp.web.template.TemplateUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebApi(name="gem/treeview/getTreeViewListData", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, restJson=@RestJson(parameterName="param"), results={"data"}, checkXRequestedWithHeader=true)
@Template(name="gem/treeview/treeViewParts", displayName="\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u30d1\u30fc\u30c4", path="/jsp/gem/treeview/treeViewParts.jsp")
@CommandClass(name="gem/treeview/GetTreeViewListDataCommand", displayName="\u30c4\u30ea\u30fc\u30d3\u30e5\u30fc\u30ea\u30b9\u30c8\u30c7\u30fc\u30bf\u53d6\u5f97")
public final class GetTreeViewListDataCommand
implements Command {
    private static Logger logger = LoggerFactory.getLogger(GetTreeViewListDataCommand.class);
    public static final String WEBAPI_NAME = "gem/treeview/getTreeViewListData";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
    private TreeViewManager tvm = (TreeViewManager)ManagerLocator.getInstance().getManager(TreeViewManager.class);

    public String execute(RequestContext request) {
        String defName = request.getParam("defName");
        String path = request.getParam("path");
        String type = request.getParam("type");
        String oid = request.getParam("oid");
        String offset = request.getParam("offset");
        TreeView tree = (TreeView)this.tvm.get(defName);
        List<TreeViewNode> nodes = null;
        if (StringUtil.isBlank((String)path)) {
            nodes = this.initTreeView(tree);
        } else {
            TreeViewItem item = tree.getItem(path);
            if ("root".equals(oid)) {
                oid = null;
            }
            if ("entitydefinition".equals(type)) {
                nodes = this.underEntityDefinition(item, oid, path);
            } else if ("index".equals(type)) {
                if (StringUtil.isNotBlank((String)offset)) {
                    try {
                        int _offset = Integer.parseInt(offset);
                        nodes = this.underIndex(item, oid, path, _offset);
                    }
                    catch (NumberFormatException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            } else if ("entity".equals(type)) {
                nodes = this.underEntity(item, oid, path);
            }
        }
        request.setAttribute("data", (Object)new JsonStreamingOutput(this.convertData(nodes)));
        return "SUCCESS";
    }

    private List<TreeViewJqTreeData> convertData(List<TreeViewNode> nodes) {
        ArrayList<TreeViewJqTreeData> ret = new ArrayList<TreeViewJqTreeData>();
        for (TreeViewNode node : nodes) {
            TreeViewJqTreeData data = new TreeViewJqTreeData();
            data.setType(node.getType());
            data.setPath(node.getPath());
            data.setName(node.getDisplayName());
            data.setStyle(node.getCssStyle());
            data.setIcon(node.getIcon());
            if (node instanceof EntityDefinitionNode) {
                data.setLoad_on_demand(true);
                data.setId(node.getPath().replaceAll("/", "_"));
            } else if (node instanceof IndexNode) {
                IndexNode in = (IndexNode)node;
                data.setLoad_on_demand(true);
                data.setOid(in.getOid());
                data.setOffset(in.getOffset());
                data.setId(node.getPath().replaceAll("/", "_") + ":" + in.getOffset());
            } else if (node instanceof EntityNode) {
                EntityNode en = (EntityNode)node;
                data.setLoad_on_demand(en.isHasReference());
                data.setOid(en.getOid());
                data.setDefName(en.getDefName());
                data.setAction(en.getAction());
                data.setViewName(en.getViewName());
                data.setId(node.getPath().replaceAll("/", "_") + ":" + en.getOid());
            }
            ret.add(data);
        }
        return ret;
    }

    private List<TreeViewNode> initTreeView(TreeView treeView) {
        AuthContext authContext = AuthContext.getCurrentContext();
        ArrayList<TreeViewNode> nodes = new ArrayList<TreeViewNode>();
        for (final TreeViewItem item : treeView.getItems()) {
            if (!authContext.checkPermission((Permission)new ActionPermission("gem/generic/search/view", new ActionParameter(){

                public Object getValue(String name) {
                    if ("defName".equals(name)) {
                        return item.getDefName();
                    }
                    if ("viewName".equals(name)) {
                        return item.getViewName();
                    }
                    return null;
                }
            }))) continue;
            if (item.isDisplayDefinitionNode()) {
                TreeViewNode node = this.createEntityDefinitionNode(item, null, null);
                if (node == null) continue;
                nodes.add(node);
                continue;
            }
            List<TreeViewNode> _nodes = this.underEntityDefinition(item, null, item.getDefName());
            if (_nodes == null || _nodes.isEmpty()) continue;
            nodes.addAll(_nodes);
        }
        return nodes;
    }

    private List<TreeViewNode> underEntityDefinition(TreeViewItem item, String oid, String path) {
        ArrayList<TreeViewNode> list = new ArrayList<TreeViewNode>();
        int totalCount = this.count(item, oid);
        if (totalCount == 0) {
            return list;
        }
        EntityDefinitionNode edNode = new EntityDefinitionNode((String)null, path);
        if (totalCount > item.getLimit()) {
            int index = totalCount % item.getLimit() == 0 ? totalCount / item.getLimit() : totalCount / item.getLimit() + 1;
            for (int i = 0; i < index; ++i) {
                int _offset = item.getLimit() * i;
                IndexNode iNode = new IndexNode(edNode.getPath());
                iNode.setDisplayName(_offset + 1 + "\uff5e" + (_offset + item.getLimit()) + "\u4ef6");
                iNode.setIcon(item.getIndexNodeIcon());
                iNode.setCssStyle(item.getIndexNodeCssStyle());
                iNode.setOffset(_offset);
                iNode.setOid(oid);
                list.add(iNode);
            }
        } else {
            list.addAll(this.createEntityNode(item, -1, oid, edNode.getPath()));
        }
        return list;
    }

    private List<TreeViewNode> underIndex(TreeViewItem item, String oid, String path, int offset) {
        List<EntityNode> entities = this.createEntityNode(item, offset, oid, path);
        ArrayList<TreeViewNode> nodes = new ArrayList<TreeViewNode>();
        nodes.addAll(entities);
        return nodes;
    }

    private List<TreeViewNode> underEntity(TreeViewItem item, String oid, String path) {
        ArrayList<TreeViewNode> nodes = new ArrayList<TreeViewNode>();
        for (ReferenceTreeViewItem rItem : item.getReferenceTreeViewItems()) {
            if (rItem.isDisplayDefinitionNode()) {
                TreeViewNode rNode = this.createEntityDefinitionNode(rItem, oid, path);
                if (rNode == null) continue;
                nodes.add(rNode);
                continue;
            }
            List<TreeViewNode> _nodes = this.underEntityDefinition(rItem, oid, path + "/" + rItem.getPropertyName());
            if (_nodes == null || _nodes.isEmpty()) continue;
            nodes.addAll(_nodes);
        }
        return nodes;
    }

    private TreeViewNode createEntityDefinitionNode(TreeViewItem item, String oid, String path) {
        int totalCount = this.count(item, oid);
        if (totalCount == 0) {
            return null;
        }
        EntityDefinitionNode edNode = null;
        if (item instanceof ReferenceTreeViewItem) {
            ReferenceTreeViewItem rItem = (ReferenceTreeViewItem)item;
            edNode = new EntityDefinitionNode(path, rItem.getPropertyName());
            edNode.setDisplayName(rItem.getDisplayName());
        } else {
            edNode = new EntityDefinitionNode(path, item.getDefName());
            String displayName = TemplateUtil.getMultilingualString((String)this.edm.get(item.getDefName()).getDisplayName(), (List)this.edm.get(item.getDefName()).getLocalizedDisplayNameList());
            edNode.setDisplayName(displayName);
        }
        edNode.setIcon(item.getEntityDefinitionNodeIcon());
        edNode.setCssStyle(item.getEntityDefinitionNodeCssStyle());
        return edNode;
    }

    private List<EntityNode> createEntityNode(TreeViewItem item, int offset, String oid, String path) {
        Entity[] entites;
        ArrayList<EntityNode> nodes = new ArrayList<EntityNode>();
        for (Entity entity : entites = this.search(item, offset, oid)) {
            EntityNode en = null;
            en = item instanceof ReferenceTreeViewItem ? new EntityNode(path, ((ReferenceTreeViewItem)item).getPropertyName()) : new EntityNode(path, item.getDefName());
            if (this.existProperty(item)) {
                en.setDisplayName(entity.getValue(item.getDisplayPropertyName()).toString());
            } else {
                en.setDisplayName(entity.getName());
            }
            en.setOid(entity.getOid());
            en.setDefName(entity.getDefinitionName());
            en.setAction(item.getAction());
            en.setViewName(item.getViewName());
            en.setIcon(item.getEntityNodeIcon());
            en.setCssStyle(item.getEntityNodeCssStyle());
            en.setHasReference(!item.getReferenceTreeViewItems().isEmpty());
            nodes.add(en);
        }
        return nodes;
    }

    private boolean existProperty(TreeViewItem item) {
        if (item == null) {
            return false;
        }
        if (item.getDisplayPropertyName() == null) {
            return false;
        }
        EntityDefinition ed = this.edm.get(item.getDefName());
        return ed.getProperty(item.getDisplayPropertyName()) != null;
    }

    private int count(TreeViewItem item, String oid) {
        Query cond = new Query();
        cond.select(new Object[]{"oid"});
        cond.select().setDistinct(true);
        cond.from(item.getDefName());
        if (oid != null && item instanceof ReferenceTreeViewItem) {
            cond.where(this.getCondition((ReferenceTreeViewItem)item, oid));
        }
        return this.em.count(cond);
    }

    private Entity[] search(TreeViewItem item, int offset, String oid) {
        Query cond = new Query();
        ArrayList<String> select = new ArrayList<String>();
        select.add("oid");
        select.add("name");
        if (this.existProperty(item) && !select.contains(item.getDisplayPropertyName())) {
            select.add(item.getDisplayPropertyName());
        }
        cond.select(select.toArray());
        cond.from(item.getDefName());
        if (oid != null && item instanceof ReferenceTreeViewItem) {
            cond.where(this.getCondition((ReferenceTreeViewItem)item, oid));
        }
        cond.order(new SortSpec[]{this.getSortSpec(item)});
        if (offset > -1) {
            cond.limit(item.getLimit(), offset);
        } else {
            cond.limit(item.getLimit());
        }
        List list = this.em.searchEntity(cond).getList();
        return list.toArray(new Entity[list.size()]);
    }

    private Condition getCondition(ReferenceTreeViewItem item, String oid) {
        SubQuery sq = new SubQuery(new Query().select(new Object[]{item.getPropertyName() + "." + "oid"}).from(item.getParent().getDefName()).where((Condition)new Equals("oid", (Object)oid)));
        return new In("oid", sq);
    }

    private SortSpec getSortSpec(TreeViewItem item) {
        String sortKey = item.getSortItem() != null ? item.getSortItem() : "oid";
        SortSpec.SortType type = SortSpec.SortType.ASC;
        if (item.getSortType() != null && item.getSortType().equals((Object)TreeViewItem.TreeSortType.DESC)) {
            type = SortSpec.SortType.DESC;
        }
        return new SortSpec(sortKey, type);
    }
}

