/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.gem.command.treeview;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.iplass.gem.command.treeview.EntityDefinitionNode;
import org.iplass.gem.command.treeview.EntityNode;
import org.iplass.gem.command.treeview.IndexNode;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.util.DateUtil;

public class TreeNodeData {
    private String id;
    private String type;
    private String name;
    private String defName;
    private String oid;
    private String action;
    private String viewName;
    private int level;
    private String parent;
    private boolean isLeaf;
    private boolean expanded;
    private boolean loaded;
    private Object[] values;

    public TreeNodeData(EntityDefinitionNode node, String parent, int level, String oid, Object[] values) {
        this.type = "D";
        this.name = node.getDisplayName();
        this.level = level;
        this.parent = parent;
        this.isLeaf = false;
        this.expanded = false;
        this.loaded = false;
        this.values = values;
        this.id = oid == null ? this.type + "/root/" + node.getPath() : this.type + "/" + oid + "/" + node.getPath();
    }

    public TreeNodeData(IndexNode node, String parent, int level, String oid, int offset, Object[] values) {
        this.type = "I";
        this.name = node.getDisplayName();
        this.level = level;
        this.parent = parent;
        this.isLeaf = false;
        this.expanded = false;
        this.loaded = false;
        this.values = values;
        this.id = oid == null ? this.type + "/root/" + offset + "/" + node.getPath() : this.type + "/" + oid + "/" + offset + "/" + node.getPath();
    }

    public TreeNodeData(EntityNode node, String parent, int level, Object[] values) {
        this.type = "E";
        this.name = node.getDisplayName();
        this.defName = node.getDefName();
        this.oid = node.getOid();
        this.action = node.getAction();
        this.viewName = node.getViewName();
        this.level = level;
        this.parent = parent;
        this.isLeaf = !node.isHasReference();
        this.expanded = false;
        this.loaded = false;
        this.values = values;
        this.id = this.type + "/" + node.getOid() + "/" + node.getPath();
    }

    public List<String> getStringValues() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object value : this.values) {
            String _value = this.convertValue(value);
            ret.add(_value);
        }
        return ret;
    }

    private String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryReference) {
            return ((BinaryReference)value).getName();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            return DateUtil.getDateInstance((int)2, (boolean)false).format((Date)value);
        }
        if (value instanceof Timestamp) {
            return DateUtil.getDateTimeInstance((int)2, (int)2, (boolean)true).format((Timestamp)value);
        }
        if (value instanceof BigDecimal) {
            return value.toString();
        }
        if (value instanceof Double) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Entity) {
            Entity entity = (Entity)value;
            return entity.getName();
        }
        if (value instanceof SelectValue) {
            SelectValue sv = (SelectValue)value;
            if (sv.getDisplayName() != null) {
                return sv.getDisplayName();
            }
        } else {
            if (value instanceof String) {
                return value.toString();
            }
            if (value instanceof Time) {
                return value.toString();
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefName() {
        return this.defName;
    }

    public void setDefName(String defName) {
        this.defName = defName;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }
}

