/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant.gem;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.gem.TenantGemInfo;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTenantGemInfo
extends MetaTenantConfig<TenantGemInfo> {
    private static final long serialVersionUID = -8193028509449590924L;
    private static Logger logger = LoggerFactory.getLogger(MetaTenantGemInfo.class);
    private boolean useDisplayName = true;
    private boolean dispTenantName;
    private String screenTitle;
    private List<MetaLocalizedString> localizedScreenTitle;
    private String skin;
    private String theme;
    private String tenantImageUrl;
    private String tenantMiniImageUrl;
    private String tenantLargeImageUrl;
    private String iconUrl;
    private String javascriptFilePath;
    private String stylesheetFilePath;

    public boolean isUseDisplayName() {
        return this.useDisplayName;
    }

    public void setUseDisplayName(boolean useDisplayName) {
        this.useDisplayName = useDisplayName;
    }

    public boolean isDispTenantName() {
        return this.dispTenantName;
    }

    public void setDispTenantName(boolean dispTenantName) {
        this.dispTenantName = dispTenantName;
    }

    public String getScreenTitle() {
        return this.screenTitle;
    }

    public void setScreenTitle(String screenTitle) {
        this.screenTitle = screenTitle;
    }

    public List<MetaLocalizedString> getLocalizedScreenTitle() {
        return this.localizedScreenTitle;
    }

    public void setLocalizedScreenTitle(List<MetaLocalizedString> localizedScreenTitle) {
        this.localizedScreenTitle = localizedScreenTitle;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getTenantImageUrl() {
        return this.tenantImageUrl;
    }

    public void setTenantImageUrl(String tenantImageUrl) {
        this.tenantImageUrl = tenantImageUrl;
    }

    public String getTenantMiniImageUrl() {
        return this.tenantMiniImageUrl;
    }

    public void setTenantMiniImageUrl(String tenantMiniImageUrl) {
        this.tenantMiniImageUrl = tenantMiniImageUrl;
    }

    public String getTenantLargeImageUrl() {
        return this.tenantLargeImageUrl;
    }

    public void setTenantLargeImageUrl(String tenantLargeImageUrl) {
        this.tenantLargeImageUrl = tenantLargeImageUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getJavascriptFilePath() {
        return this.javascriptFilePath;
    }

    public void setJavascriptFilePath(String javascriptFilePath) {
        this.javascriptFilePath = javascriptFilePath;
    }

    public String getStylesheetFilePath() {
        return this.stylesheetFilePath;
    }

    public void setStylesheetFilePath(String stylesheetFilePath) {
        this.stylesheetFilePath = stylesheetFilePath;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public void applyConfig(TenantGemInfo definition) {
        this.setUseDisplayName(definition.isUseDisplayName());
        this.setDispTenantName(definition.isDispTenantName());
        this.setScreenTitle(definition.getScreenTitle());
        this.setLocalizedScreenTitle(I18nUtil.toMeta(definition.getLocalizedScreenTitle()));
        this.setSkin(definition.getSkin());
        this.setTheme(definition.getTheme());
        this.setTenantImageUrl(definition.getTenantImageUrl());
        this.setTenantMiniImageUrl(definition.getTenantMiniImageUrl());
        this.setTenantLargeImageUrl(definition.getTenantLargeImageUrl());
        this.setIconUrl(definition.getIconUrl());
        this.setJavascriptFilePath(definition.getJavascriptFilePath());
        this.setStylesheetFilePath(definition.getStylesheetFilePath());
    }

    public TenantGemInfo currentConfig() {
        TenantGemInfo definition = new TenantGemInfo();
        definition.setUseDisplayName(this.useDisplayName);
        definition.setDispTenantName(this.dispTenantName);
        definition.setScreenTitle(this.getScreenTitle());
        definition.setLocalizedScreenTitle(I18nUtil.toDef(this.getLocalizedScreenTitle()));
        definition.setSkin(this.getSkin() != null ? this.getSkin().toLowerCase() : null);
        definition.setTheme(this.getTheme() != null ? this.getTheme().toLowerCase() : null);
        definition.setTenantImageUrl(this.getTenantImageUrl());
        definition.setTenantMiniImageUrl(this.getTenantMiniImageUrl());
        definition.setTenantLargeImageUrl(this.getTenantLargeImageUrl());
        definition.setIconUrl(this.getIconUrl());
        definition.setJavascriptFilePath(this.getJavascriptFilePath());
        definition.setStylesheetFilePath(this.getStylesheetFilePath());
        return definition;
    }

    public MetaTenantGemInfoRuntime createRuntime(MetaTenant.MetaTenantHandler tenantRuntime) {
        return new MetaTenantGemInfoRuntime();
    }

    public class MetaTenantGemInfoRuntime
    extends MetaTenantConfig.MetaTenantConfigRuntime {
        private GroovyTemplate screenTitleTemplate;
        private Map<String, GroovyTemplate> localizedScreenTitleTemplate;
        private ScriptEngine scriptEngine;

        public MetaTenantGemInfoRuntime() {
            super((MetaTenantConfig)MetaTenantGemInfo.this);
            this.scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            if (MetaTenantGemInfo.this.screenTitle != null) {
                try {
                    String scriptName = "MetaTenantGemInfo_screenTitle";
                    this.screenTitleTemplate = GroovyTemplateCompiler.compile((String)MetaTenantGemInfo.this.screenTitle, (String)scriptName, (GroovyScriptEngine)((GroovyScriptEngine)this.scriptEngine));
                }
                catch (Exception e) {
                    this.setIllegalStateException(new RuntimeException(e));
                }
            }
            if (MetaTenantGemInfo.this.localizedScreenTitle != null) {
                try {
                    this.localizedScreenTitleTemplate = MetaTenantGemInfo.this.localizedScreenTitle.stream().collect(Collectors.toMap(MetaLocalizedString::getLocaleName, l -> GroovyTemplateCompiler.compile((String)l.getStringValue(), (String)("MetaTenantGemInfo_screenTitle_" + l.getLocaleName()), (GroovyScriptEngine)((GroovyScriptEngine)this.scriptEngine))));
                }
                catch (Exception e) {
                    this.setIllegalStateException(new RuntimeException(e));
                }
            }
        }

        public String getScreenTitle() {
            String screenTitleByTemplate = this.getScreenTitleByTemplate();
            if (!StringUtils.isEmpty((CharSequence)screenTitleByTemplate)) {
                return screenTitleByTemplate;
            }
            Tenant tenant = TemplateUtil.getTenant();
            String dispTenantName = tenant.getDisplayName();
            if (StringUtils.isEmpty((CharSequence)(dispTenantName = TemplateUtil.getMultilingualString((String)dispTenantName, (List)tenant.getLocalizedDisplayNameList())))) {
                dispTenantName = tenant.getName();
            }
            return dispTenantName;
        }

        private String getScreenTitleByTemplate() {
            GroovyTemplate template = null;
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            if (lang != null && this.localizedScreenTitleTemplate != null && this.localizedScreenTitleTemplate.containsKey(lang)) {
                template = this.localizedScreenTitleTemplate.get(lang);
            } else if (this.screenTitleTemplate != null) {
                template = this.screenTitleTemplate;
            }
            if (template == null) {
                return null;
            }
            HashMap<String, RequestContext> binding = new HashMap<String, RequestContext>();
            binding.put("request", TemplateUtil.getRequestContext());
            StringWriter sw = new StringWriter();
            try {
                template.doTemplate(new GroovyTemplateBinding((Writer)sw, binding));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
            String tenantName = sw.toString();
            return tenantName;
        }

        public MetaData getMetaData() {
            return MetaTenantGemInfo.this;
        }

        public void applyMetaDataToTenant(Tenant tenant) {
        }
    }
}

