/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.calendar.MetaEntityCalendarItem;
import org.iplass.mtp.view.calendar.EntityCalendar;
import org.iplass.mtp.view.calendar.EntityCalendarItem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class MetaCalendar
extends BaseRootMetaData
implements DefinableMetaData<EntityCalendar> {
    private static final long serialVersionUID = 7232009428982319568L;
    private EntityCalendar.CalendarType type;
    private List<MetaEntityCalendarItem> items;

    public List<MetaEntityCalendarItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<MetaEntityCalendarItem>();
        }
        return this.items;
    }

    public void setItems(List<MetaEntityCalendarItem> items) {
        this.items = items;
    }

    public EntityCalendar.CalendarType getType() {
        return this.type;
    }

    public void setType(EntityCalendar.CalendarType type) {
        this.type = type;
    }

    public void addItem(MetaEntityCalendarItem item) {
        this.getItems().add(item);
    }

    public void applyConfig(EntityCalendar calendar) {
        this.name = calendar.getName();
        this.displayName = calendar.getDisplayName();
        this.description = calendar.getDescription();
        this.type = calendar.getType();
        for (EntityCalendarItem item : calendar.getItems()) {
            MetaEntityCalendarItem mItem = new MetaEntityCalendarItem();
            mItem.applyConfig(item);
            this.addItem(mItem);
        }
        this.localizedDisplayNameList = I18nUtil.toMeta(calendar.getLocalizedDisplayNameList());
    }

    public EntityCalendar currentConfig() {
        EntityCalendar calendar = new EntityCalendar();
        calendar.setName(this.name);
        calendar.setDisplayName(this.displayName);
        calendar.setDescription(this.description);
        calendar.setType(this.type);
        for (MetaEntityCalendarItem mItem : this.getItems()) {
            EntityCalendarItem item = mItem.currentConfig();
            calendar.addItem(item);
        }
        calendar.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        return calendar;
    }

    public MetaCalendar copy() {
        return (MetaCalendar)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new CalendarHandler();
    }

    public class CalendarHandler
    extends BaseMetaDataRuntime {
        public CalendarHandler() {
            try {
                if (MetaCalendar.this.items != null) {
                    for (MetaEntityCalendarItem item : MetaCalendar.this.items) {
                        item.createRuntime();
                    }
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaCalendar getMetaData() {
            return MetaCalendar.this;
        }

        public String getColorConfigResult(Entity entity) {
            String result = null;
            if (MetaCalendar.this.items != null) {
                for (MetaEntityCalendarItem item : MetaCalendar.this.items) {
                    MetaEntityCalendarItem.EntityCalendarItemRuntime runtime = item.createRuntime();
                    if (!entity.getDefinitionName().equals(runtime.getDefinitionName())) continue;
                    result = runtime.getColor(entity);
                    break;
                }
            }
            return result;
        }
    }
}

