/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.calendar;

import java.io.Serializable;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.calendar.EntityCalendarItem;

public class MetaEntityCalendarItem
implements MetaData {
    private static final long serialVersionUID = -143884759940160050L;
    private String definitionId;
    private String entityColor;
    private EntityCalendarItem.CalendarSearchType calendarSearchType;
    private String propertyId;
    private String fromPropertyId;
    private String toPropertyId;
    private String viewAction;
    private String addAction;
    private String viewName;
    private Boolean displayTime;
    private Integer limit;
    private String filterCondition;
    private String colorConfig;

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getEntityColor() {
        return this.entityColor;
    }

    public void setEntityColor(String entityColor) {
        this.entityColor = entityColor;
    }

    public EntityCalendarItem.CalendarSearchType getCalendarSearchType() {
        return this.calendarSearchType;
    }

    public void setCalendarSearchType(EntityCalendarItem.CalendarSearchType calendarSearchType) {
        this.calendarSearchType = calendarSearchType;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getFromPropertyId() {
        return this.fromPropertyId;
    }

    public void setFromPropertyId(String fromPropertyId) {
        this.fromPropertyId = fromPropertyId;
    }

    public String getToPropertyId() {
        return this.toPropertyId;
    }

    public void setToPropertyId(String toPropertyId) {
        this.toPropertyId = toPropertyId;
    }

    public String getViewAction() {
        return this.viewAction;
    }

    public void setViewAction(String viewAction) {
        this.viewAction = viewAction;
    }

    public String getAddAction() {
        return this.addAction;
    }

    public void setAddAction(String addAction) {
        this.addAction = addAction;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public Boolean getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(Boolean displayTime) {
        this.displayTime = displayTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public String getColorConfig() {
        return this.colorConfig;
    }

    public void setColorConfig(String colorConfig) {
        this.colorConfig = colorConfig;
    }

    public void applyConfig(EntityCalendarItem item) {
        PropertyHandler property;
        EntityContext metaContext = EntityContext.getCurrentContext();
        EntityHandler entity = metaContext.getHandlerByName(item.getDefinitionName());
        this.definitionId = entity.getMetaData().getId();
        this.entityColor = item.getEntityColor();
        if (item.getPropertyName() != null && (property = entity.getProperty(item.getPropertyName(), metaContext)) != null) {
            this.propertyId = property.getId();
        }
        if (item.getFromPropertyName() != null && (property = entity.getProperty(item.getFromPropertyName(), metaContext)) != null) {
            this.fromPropertyId = property.getId();
        }
        if (item.getToPropertyName() != null && (property = entity.getProperty(item.getToPropertyName(), metaContext)) != null) {
            this.toPropertyId = property.getId();
        }
        this.calendarSearchType = item.getCalendarSearchType();
        this.viewAction = item.getViewAction();
        this.addAction = item.getAddAction();
        this.viewName = item.getViewName();
        this.displayTime = item.getDisplayTime();
        this.limit = item.getLimit();
        this.filterCondition = item.getFilterCondition();
        this.colorConfig = item.getColorConfig();
    }

    public EntityCalendarItem currentConfig() {
        EntityCalendarItem item = new EntityCalendarItem();
        EntityContext metaContext = EntityContext.getCurrentContext();
        EntityHandler eHandler = metaContext.getHandlerById(this.definitionId);
        if (eHandler != null) {
            MetaProperty property;
            MetaEntity entity = eHandler.getMetaData();
            item.setDefinitionName(entity.getName());
            if (this.propertyId != null && (property = eHandler.getPropertyById(this.propertyId, metaContext).getMetaData()) != null) {
                item.setPropertyName(property.getName());
            }
            if (this.fromPropertyId != null && (property = eHandler.getPropertyById(this.fromPropertyId, metaContext).getMetaData()) != null) {
                item.setFromPropertyName(property.getName());
            }
            if (this.toPropertyId != null && (property = eHandler.getPropertyById(this.toPropertyId, metaContext).getMetaData()) != null) {
                item.setToPropertyName(property.getName());
            }
        }
        item.setEntityColor(this.entityColor);
        item.setCalendarSearchType(this.calendarSearchType);
        item.setViewAction(this.viewAction);
        item.setAddAction(this.addAction);
        item.setViewName(this.viewName);
        item.setDisplayTime(this.displayTime);
        item.setLimit(this.limit);
        item.setFilterCondition(this.filterCondition);
        item.setColorConfig(this.colorConfig);
        return item;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public EntityCalendarItemRuntime createRuntime() {
        return new EntityCalendarItemRuntime();
    }

    public class EntityCalendarItemRuntime {
        private static final String SCRIPT_PREFIX = "EntityCalendarItemRuntime_colorConfig";
        private Script colorConfigScript;
        private String definitionName;

        public EntityCalendarItemRuntime() {
            EntityContext metaContext = EntityContext.getCurrentContext();
            EntityHandler eHandler = metaContext.getHandlerById(MetaEntityCalendarItem.this.definitionId);
            if (eHandler == null) {
                throw new NullPointerException("definitionId:" + MetaEntityCalendarItem.this.definitionId + " MetaEntity not found");
            }
            if (StringUtil.isNotEmpty((String)MetaEntityCalendarItem.this.colorConfig)) {
                ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.colorConfigScript = scriptEngine.createScript(MetaEntityCalendarItem.this.colorConfig, SCRIPT_PREFIX);
            }
            this.definitionName = eHandler.getMetaData().getName();
        }

        public MetaEntityCalendarItem getMetaData() {
            return MetaEntityCalendarItem.this;
        }

        public String getDefinitionName() {
            return this.definitionName;
        }

        public String getColor(Entity entity) {
            ScriptContext sc = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine().newScriptContext();
            sc.setAttribute("today", (Object)DateUtil.getCurrentTimestamp());
            sc.setAttribute("propertyName", (Object)this.getMetaData().currentConfig().getPropertyName());
            sc.setAttribute("fromPropertyName", (Object)this.getMetaData().currentConfig().getFromPropertyName());
            sc.setAttribute("toPropertyName", (Object)this.getMetaData().currentConfig().getToPropertyName());
            sc.setAttribute("entity", (Object)entity);
            Object color = this.colorConfigScript.eval(sc);
            if (color == null) {
                return null;
            }
            return color.toString();
        }
    }
}

