/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.csv;

import java.io.Writer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.util.DateUtil;

public class CsvFileNameGroovyTemplateBinding
extends GroovyTemplateBinding {
    public CsvFileNameGroovyTemplateBinding(Writer out, String csvName) {
        super(out);
        this.setupCsvBinding(csvName);
    }

    public CsvFileNameGroovyTemplateBinding(Writer out, String csvName, Map<String, Object> customBindings) {
        super(out, customBindings);
        this.setupCsvBinding(csvName);
    }

    private void setupCsvBinding(String csvName) {
        ExecuteContext ex = ExecuteContext.getCurrentContext();
        Timestamp date = ex.getCurrentTimestamp();
        this.setVariable("date", date);
        this.setVariable("user", AuthContextHolder.getAuthContext().newUserBinding());
        SimpleDateFormat f = DateUtil.getSimpleDateFormat((String)"yyyy", (boolean)true);
        this.setVariable("yyyy", f.format(date));
        f.applyPattern("MM");
        this.setVariable("MM", f.format(date));
        f.applyPattern("dd");
        this.setVariable("dd", f.format(date));
        f.applyPattern("HH");
        this.setVariable("HH", f.format(date));
        f.applyPattern("mm");
        this.setVariable("mm", f.format(date));
        f.applyPattern("ss");
        this.setVariable("ss", f.format(date));
        this.setVariable("csvName", csvName);
    }
}

