/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.MetaDetailFormView;

public class DetailFormViewRuntime
extends FormViewRuntime {
    public static final String ENTITY_BINDING_NAME = "entity";
    public static final String ENTITY_DEFINITION_BINDING_NAME = "entityDefinition";
    public static final String ENTITY_MANAGER_BINDING_NAME = "entityManager";
    public static final String WF_START_PARAM_MAP_BINDING_NAME = "startParamMap";
    public static final String WF_REQUEST_BINDING_NAME = "request";
    public static final String WF_SESSION_BINDING_NAME = "session";
    public static final String WF_USER_BINDING_NAME = "user";
    public static final String REQUEST_BINDING_NAME = "request";
    public static final String SESSION_BINDING_NAME = "session";
    public static final String USER_BINDING_NAME = "user";
    public static final String OUTPUT_TYPE_BINDING_NAME = "outputType";
    private static final String SCRIPT_PREFIX_CUSTOM_COPY_SCRIPT = "DetailFormViewHandler_customCopyScript";
    private static final String SCRIPT_PREFIX_INIT_SCRIPT = "DetailFormViewHandler_initScript";
    private Script compiledCustomCopyScript;
    private Script compiledInitScript;
    private ScriptEngine scriptEngine;
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    public DetailFormViewRuntime(MetaDetailFormView metaData, EntityViewRuntime entityView) {
        super(metaData, entityView);
        String scriptName;
        TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
        this.scriptEngine = tc.getScriptEngine();
        if (metaData.getCustomCopyScript() != null) {
            scriptName = null;
            scriptName = metaData.getName() == null || metaData.getName().isEmpty() ? "DetailFormViewHandler_customCopyScript_" + entityView.getMetaData().getId() + "_default" : "DetailFormViewHandler_customCopyScript_" + entityView.getMetaData().getId() + "_" + metaData.getName();
            this.compiledCustomCopyScript = this.scriptEngine.createScript(metaData.getCustomCopyScript(), scriptName);
        }
        if (metaData.getInitScript() != null) {
            scriptName = null;
            scriptName = metaData.getName() == null || metaData.getName().isEmpty() ? "DetailFormViewHandler_initScript_" + entityView.getMetaData().getId() + "_default" : "DetailFormViewHandler_initScript_" + entityView.getMetaData().getId() + "_" + metaData.getName();
            this.compiledInitScript = this.scriptEngine.createScript(metaData.getInitScript(), scriptName);
        }
    }

    @Override
    public MetaDetailFormView getMetaData() {
        return (MetaDetailFormView)super.getMetaData();
    }

    public Entity copyEntity(Entity entity) {
        if (this.compiledCustomCopyScript == null) {
            throw new ApplicationException(DetailFormViewRuntime.resourceString("impl.view.generic.DetailFormViewHandler.noScript", new Object[0]));
        }
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(entity.getDefinitionName());
        UserBinding user = AuthContextHolder.getAuthContext().newUserBinding();
        ScriptContext sc = this.scriptEngine.newScriptContext();
        sc.setAttribute(ENTITY_BINDING_NAME, (Object)entity);
        sc.setAttribute(ENTITY_DEFINITION_BINDING_NAME, (Object)eh.getMetaData().currentConfig(ec));
        sc.setAttribute(ENTITY_MANAGER_BINDING_NAME, (Object)this.em);
        sc.setAttribute("request", (Object)RequestContextBinding.newRequestContextBinding());
        sc.setAttribute("session", (Object)SessionBinding.newSessionBinding());
        sc.setAttribute("user", (Object)user);
        Object val = this.compiledCustomCopyScript.eval(sc);
        if (val != null && val instanceof Entity) {
            return (Entity)val;
        }
        return null;
    }

    public Entity initEntity(Entity entity, String definitionName) {
        Entity ret = entity;
        if (ret == null) {
            EntityContext ec = EntityContext.getCurrentContext();
            EntityHandler eh = ec.getHandlerByName(definitionName);
            ret = eh.newInstance();
        }
        UserBinding user = AuthContextHolder.getAuthContext().newUserBinding();
        ScriptContext sc = this.scriptEngine.newScriptContext();
        sc.setAttribute(ENTITY_BINDING_NAME, (Object)ret);
        sc.setAttribute("request", (Object)RequestContextBinding.newRequestContextBinding());
        sc.setAttribute("session", (Object)SessionBinding.newSessionBinding());
        sc.setAttribute("user", (Object)user);
        this.compiledInitScript.eval(sc);
        return ret;
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }
}

