/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.iplass.gem.command.GemResourceBundleUtil;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.definition.AbstractTypedDefinitionManager;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.view.generic.DetailFormViewRuntime;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.EntityViewService;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.MetaEntityView;
import org.iplass.mtp.impl.view.generic.MetaViewControlSetting;
import org.iplass.mtp.impl.view.generic.SearchFormViewRuntime;
import org.iplass.mtp.impl.view.generic.common.MetaAutocompletionSetting;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaButton;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.impl.web.template.MetaGroovyTemplate;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.common.AutocompletionHandleException;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.MassReferenceSection;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SearchResultSection;
import org.iplass.mtp.view.generic.element.section.Section;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityViewManagerImpl
extends AbstractTypedDefinitionManager<EntityView>
implements EntityViewManager {
    private static Logger logger = LoggerFactory.getLogger(EntityViewManagerImpl.class);
    private static final String REQUEST_BINDING_NAME = "request";
    private static final String SESSION_BINDING_NAME = "session";
    private EntityViewService service = (EntityViewService)ServiceRegistry.getRegistry().getService(EntityViewService.class);
    private EntityDefinitionManager edm = (EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);

    @Override
    @Deprecated
    public DefinitionModifyResult create(String name, EntityView entityView) {
        return this.create(entityView);
    }

    @Override
    @Deprecated
    public DefinitionModifyResult update(String name, EntityView entityView) {
        return this.update(entityView);
    }

    @Override
    public PropertyEditor getPropertyEditor(String defName, String viewType, String viewName, String propName, Entity entity) {
        EntityView ev = (EntityView)this.get(defName);
        if (ev == null) {
            return null;
        }
        PropertyEditor editor = null;
        if ("detail".equals(viewType)) {
            DetailFormView form = null;
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultDetailFormView() : ev.getDetailFormView(viewName);
            editor = this.getDetailFormViewEditor(defName, propName, form, entity);
        } else if ("search".equals(viewType)) {
            SearchFormView form = null;
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultSearchFormView() : ev.getSearchFormView(viewName);
            editor = this.getSearchFormViewEditor(defName, propName, form);
        } else if ("searchResult".equals(viewType)) {
            SearchFormView form = null;
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultSearchFormView() : ev.getSearchFormView(viewName);
            editor = this.getSearchResultEditor(defName, propName, form);
        } else if ("bulk".equals(viewType)) {
            SearchFormView form = null;
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultSearchFormView() : ev.getSearchFormView(viewName);
            editor = this.getBulkUpdateEditor(defName, propName, form);
        } else if ("multiBulk".equals(viewType)) {
            BulkFormView form = null;
            form = viewName == null || viewName.isEmpty() ? ev.getDefaultBulkFormView() : ev.getBulkFormView(viewName);
            editor = this.getBulkFormViewEditor(defName, propName, form);
        }
        return editor;
    }

    private PropertyEditor getDetailFormViewEditor(String defName, String propName, DetailFormView form, Entity entity) {
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        OutputType outputType = OutputType.EDIT;
        for (Section section : form.getSections()) {
            PropertyEditor editor;
            if (!this.isDisplayElement(defName, section.getElementRuntimeId(), outputType, entity) || !(section instanceof DefaultSection ? (editor = this.getEditor(defName, outputType, (DefaultSection)section, currentPropName, subPropName, entity)) != null : section instanceof MassReferenceSection && (editor = this.getEditor(defName, outputType, (MassReferenceSection)section, currentPropName, subPropName, entity)) != null)) continue;
            return editor;
        }
        return null;
    }

    private PropertyEditor getEditor(String defName, OutputType outputType, DefaultSection section, String currentPropName, String subPropName, Entity entity) {
        for (Element element : section.getElements()) {
            PropertyEditor nest;
            if (!this.isDisplayElement(defName, element.getElementRuntimeId(), outputType, entity)) continue;
            if (element instanceof PropertyItem) {
                PropertyEditor editor;
                PropertyItem property = (PropertyItem)element;
                if (property.getPropertyName().equals(currentPropName)) {
                    if (subPropName == null) {
                        property.getEditor().setPropertyName(property.getPropertyName());
                        return property.getEditor();
                    }
                    return this.getEditor(subPropName, property.getEditor());
                }
                if (!(property.getEditor() instanceof JoinPropertyEditor) || (editor = this.getEditor(currentPropName, property.getEditor())) == null) continue;
                if (subPropName == null) {
                    return editor;
                }
                return this.getEditor(subPropName, editor);
            }
            if (!(element instanceof DefaultSection) || (nest = this.getEditor(defName, outputType, (DefaultSection)element, currentPropName, subPropName, entity)) == null) continue;
            return nest;
        }
        return null;
    }

    private PropertyEditor getEditor(String defName, OutputType outputType, MassReferenceSection section, String currentPropName, String subPropName, Entity entity) {
        if (subPropName == null) {
            return null;
        }
        if (!this.isDisplayElement(defName, section.getElementRuntimeId(), outputType, entity)) {
            return null;
        }
        if (section.getPropertyName().equals(currentPropName)) {
            for (NestProperty np : section.getProperties()) {
                if (subPropName.indexOf(".") > -1) {
                    PropertyEditor editor = this.getEditor(subPropName, np.getEditor());
                    if (editor == null) continue;
                    return editor;
                }
                if (!np.getPropertyName().equals(subPropName)) continue;
                return np.getEditor();
            }
        }
        return null;
    }

    private PropertyEditor getSearchFormViewEditor(String defName, String propName, SearchFormView form) {
        PropertyItem property;
        SearchConditionSection section;
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            section = form.getCondSection();
            for (Element element : section.getElements()) {
                if (!(element instanceof PropertyItem) || !this.isDisplayElement(defName, element.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || (property = (PropertyItem)element).isBlank() || !property.getPropertyName().equals(propName)) continue;
                return property.getEditor();
            }
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        section = form.getCondSection();
        for (Element element : section.getElements()) {
            if (!(element instanceof PropertyItem) || !this.isDisplayElement(defName, element.getElementRuntimeId(), OutputType.SEARCHCONDITION, null) || (property = (PropertyItem)element).isBlank() || !property.getPropertyName().equals(currentPropName)) continue;
            if (subPropName == null) {
                property.getEditor().setPropertyName(property.getPropertyName());
                return property.getEditor();
            }
            return this.getEditor(subPropName, property.getEditor());
        }
        return null;
    }

    private PropertyEditor getEditor(String propName, PropertyEditor editor) {
        List<NestProperty> nestProperties = null;
        if (editor instanceof ReferencePropertyEditor) {
            ReferencePropertyEditor refEditor = (ReferencePropertyEditor)editor;
            nestProperties = refEditor.getNestProperties();
        } else if (editor instanceof JoinPropertyEditor) {
            JoinPropertyEditor joinEditor = (JoinPropertyEditor)editor;
            nestProperties = joinEditor.getProperties();
        } else {
            return null;
        }
        if (nestProperties == null || nestProperties.isEmpty()) {
            return null;
        }
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        for (NestProperty property : nestProperties) {
            PropertyEditor nestEditor;
            if (property.getPropertyName().equals(currentPropName)) {
                if (subPropName == null) {
                    property.getEditor().setPropertyName(property.getPropertyName());
                    return property.getEditor();
                }
                return this.getEditor(subPropName, property.getEditor());
            }
            if (!(property.getEditor() instanceof JoinPropertyEditor) || (nestEditor = this.getEditor(currentPropName, property.getEditor())) == null) continue;
            if (subPropName == null) {
                return nestEditor;
            }
            return this.getEditor(subPropName, nestEditor);
        }
        return null;
    }

    private PropertyEditor getSearchResultEditor(String defName, String propName, SearchFormView form) {
        PropertyColumn property;
        SearchResultSection section;
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            section = form.getResultSection();
            for (Element element : section.getElements()) {
                if (!(element instanceof PropertyColumn) || !(property = (PropertyColumn)element).getPropertyName().equals(propName) || !EntityViewUtil.isDisplayElement(defName, property.getElementRuntimeId(), OutputType.SEARCHRESULT, null)) continue;
                return property.getEditor();
            }
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        section = form.getResultSection();
        for (Element element : section.getElements()) {
            if (!(element instanceof PropertyColumn) || !(property = (PropertyColumn)element).getPropertyName().equals(currentPropName) || !EntityViewUtil.isDisplayElement(defName, property.getElementRuntimeId(), OutputType.SEARCHRESULT, null)) continue;
            if (subPropName == null) {
                property.getEditor().setPropertyName(property.getPropertyName());
                return property.getEditor();
            }
            return this.getEditor(subPropName, property.getEditor());
        }
        return null;
    }

    private PropertyEditor getBulkUpdateEditor(String defName, String propName, SearchFormView form) {
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        SearchResultSection section = form.getResultSection();
        for (Element element : section.getElements()) {
            PropertyEditor editor;
            PropertyColumn property;
            if (!(element instanceof PropertyColumn) || !this.isDisplayElement(defName, element.getElementRuntimeId(), OutputType.BULK, null) || (property = (PropertyColumn)element).getBulkUpdateEditor() == null) continue;
            if (property.getPropertyName().equals(currentPropName)) {
                if (subPropName == null) {
                    property.getBulkUpdateEditor().setPropertyName(property.getPropertyName());
                    return property.getBulkUpdateEditor();
                }
                return this.getEditor(subPropName, property.getBulkUpdateEditor());
            }
            if (!(property.getBulkUpdateEditor() instanceof JoinPropertyEditor) || (editor = this.getEditor(currentPropName, property.getBulkUpdateEditor())) == null) continue;
            if (subPropName == null) {
                return editor;
            }
            return this.getEditor(subPropName, editor);
        }
        return null;
    }

    private PropertyEditor getBulkFormViewEditor(String defName, String propName, BulkFormView form) {
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        for (Section section : form.getSections()) {
            PropertyEditor editor;
            if (!this.isDisplayElement(defName, section.getElementRuntimeId(), OutputType.BULK, null) || !(section instanceof DefaultSection) || (editor = this.getEditor(defName, OutputType.BULK, (DefaultSection)section, currentPropName, subPropName, null)) == null) continue;
            return editor;
        }
        return null;
    }

    @Override
    public PropertyEditor getPropertyEditor(String defName, String viewType, String viewName, String propName, Integer refSectionIndex, Entity entity) {
        PropertyEditor editor = null;
        editor = refSectionIndex == null ? this.getPropertyEditor(defName, viewType, viewName, propName, entity) : this.getPropertyEditor(defName, viewName, propName, refSectionIndex);
        return editor;
    }

    @Override
    public void executeTemplate(String name, String templateName, HttpServletRequest req, HttpServletResponse res, ServletContext application, PageContext page) {
        if (name == null || templateName == null) {
            return;
        }
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(name);
        if (entityView == null) {
            return;
        }
        GroovyTemplate template = entityView.getTemplate(templateName);
        if (template != null) {
            try {
                template.doTemplate((GroovyTemplateBinding)new MetaGroovyTemplate.WebGroovyTemplateBinding(WebUtil.getRequestContext(), req, res, application, page));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Entity copyEntity(String viewName, Entity entity) {
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(entity.getDefinitionName());
        if (entityView == null) {
            throw new ApplicationException(EntityViewManagerImpl.resourceString("impl.view.generic.EntityViewManagerImpl.viewErr", new Object[0]));
        }
        DetailFormViewRuntime detailView = null;
        for (FormViewRuntime formView : entityView.getFormViews()) {
            if (!(formView instanceof DetailFormViewRuntime)) continue;
            if (viewName == null || viewName.isEmpty()) {
                if (formView.getMetaData().getName() != null && !formView.getMetaData().getName().isEmpty()) continue;
                detailView = (DetailFormViewRuntime)formView;
                break;
            }
            if (!viewName.equals(formView.getMetaData().getName())) continue;
            detailView = (DetailFormViewRuntime)formView;
            break;
        }
        if (detailView != null) {
            return detailView.copyEntity(entity);
        }
        return null;
    }

    @Override
    public Entity initEntity(String definitionName, String viewName, Entity entity) {
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            throw new ApplicationException(EntityViewManagerImpl.resourceString("impl.view.generic.EntityViewManagerImpl.viewErr", new Object[0]));
        }
        DetailFormViewRuntime detailView = null;
        for (FormViewRuntime formView : entityView.getFormViews()) {
            if (!(formView instanceof DetailFormViewRuntime)) continue;
            if (viewName == null || viewName.isEmpty()) {
                if (formView.getMetaData().getName() != null && !formView.getMetaData().getName().isEmpty()) continue;
                detailView = (DetailFormViewRuntime)formView;
                break;
            }
            if (!viewName.equals(formView.getMetaData().getName())) continue;
            detailView = (DetailFormViewRuntime)formView;
            break;
        }
        if (detailView != null) {
            return detailView.initEntity(entity, definitionName);
        }
        return null;
    }

    @Override
    public Map<String, Object> applyDefaultPropertyCondition(String definitionName, String viewName, Map<String, Object> defaultCondMap) {
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return defaultCondMap;
        }
        SearchFormViewRuntime searchView = null;
        for (FormViewRuntime formView : entityView.getFormViews()) {
            if (!(formView instanceof SearchFormViewRuntime)) continue;
            if (viewName == null || viewName.isEmpty()) {
                if (formView.getMetaData().getName() != null && !formView.getMetaData().getName().isEmpty()) continue;
                searchView = (SearchFormViewRuntime)formView;
                break;
            }
            if (!viewName.equals(formView.getMetaData().getName())) continue;
            searchView = (SearchFormViewRuntime)formView;
            break;
        }
        if (searchView != null) {
            return searchView.applyDefaultPropertyCondition(defaultCondMap);
        }
        return defaultCondMap;
    }

    @Override
    public String getCsvDownloadFileName(String definitionName, String viewName, String defaultName, Map<String, Object> csvVariableMap) {
        String fileName = defaultName;
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView != null) {
            SearchFormViewRuntime searchView = null;
            for (FormViewRuntime formView : entityView.getFormViews()) {
                if (!(formView instanceof SearchFormViewRuntime)) continue;
                if (StringUtil.isEmpty((String)viewName)) {
                    if (!StringUtil.isEmpty((String)formView.getMetaData().getName())) continue;
                    searchView = (SearchFormViewRuntime)formView;
                    break;
                }
                if (!viewName.equals(formView.getMetaData().getName())) continue;
                searchView = (SearchFormViewRuntime)formView;
                break;
            }
            if (searchView != null) {
                fileName = searchView.getCsvDownloadFileName(defaultName, csvVariableMap).replace("/", "_").replace(" ", "_");
            }
        }
        return fileName.replace("/", "_").replace(" ", "_");
    }

    @Override
    public Condition getSearchConditionSectionDefaultCondition(String name, SearchConditionSection section) {
        return this.getEntityViewCondition(name, section, "SearchConditionSection_defaultCondition_");
    }

    @Override
    public Condition getMassReferenceSectionCondition(String name, MassReferenceSection section) {
        return this.getEntityViewCondition(name, section, "MassReferenceSection_filterCondition_");
    }

    private Condition getEntityViewCondition(String name, Element element, String prefixKey) {
        if (name == null || element == null) {
            return null;
        }
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(name);
        if (entityView == null) {
            return null;
        }
        PreparedQuery query = entityView.getQuery(prefixKey + element.getElementRuntimeId());
        if (query == null) {
            return null;
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(REQUEST_BINDING_NAME, RequestContextBinding.newRequestContextBinding());
        bindings.put(SESSION_BINDING_NAME, SessionBinding.newSessionBinding());
        return query.condition(bindings);
    }

    @Override
    public SearchFormView createDefaultSearchFormView(String definitionName) {
        return FormViewUtil.createDefaultSearchFormView(this.edm.get(definitionName), false);
    }

    @Override
    public DetailFormView createDefaultDetailFormView(String definitionName) {
        return FormViewUtil.createDefaultDetailFormView(this.edm.get(definitionName), false);
    }

    @Override
    public BulkFormView createDefaultBulkFormView(String definitionName) {
        return FormViewUtil.createDefaultBulkFormView(this.edm.get(definitionName), false);
    }

    @Override
    public String getCustomStyle(String definitionName, String scriptKey, String editorScriptKey, Entity entity, Object propValue) {
        if (definitionName == null || scriptKey == null || editorScriptKey == null) {
            return "";
        }
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return "";
        }
        Map<String, GroovyTemplate> sectionScriptMap = entityView.getCustomStyleScriptMap(scriptKey);
        GroovyTemplate script = sectionScriptMap.get(editorScriptKey);
        if (script == null) {
            return "";
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("today", DateUtil.getCurrentTimestamp());
        bindings.put("entity", entity);
        bindings.put("value", propValue);
        StringWriter sw = new StringWriter();
        try {
            script.doTemplate(new GroovyTemplateBinding((Writer)sw, bindings));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String style = sw.toString();
        if (StringUtil.isNotEmpty((String)style)) {
            style = StringUtil.removeLineFeedCode((String)StringUtil.stripToEmpty((String)style)).replaceAll("\t", "");
        }
        return style;
    }

    @Override
    public boolean isDisplayElement(String definitionName, String elementRuntimeId, OutputType outputType, Entity entity) {
        if (definitionName == null || elementRuntimeId == null || outputType == null) {
            return true;
        }
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return false;
        }
        ElementRuntime element = entityView.getElement(elementRuntimeId);
        if (element == null) {
            return false;
        }
        return element.isDisplay(outputType, entity);
    }

    @Override
    public boolean isDisplayButton(String definitionName, String buttonKey, OutputType outputType, Entity entity) {
        if (definitionName == null || buttonKey == null || outputType == null) {
            return false;
        }
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return false;
        }
        MetaButton.ButtonRuntime button = entityView.getButton(buttonKey);
        if (button == null) {
            return false;
        }
        return button.isDisplayButton(outputType, entity);
    }

    @Override
    public String getUrlParameter(String definitionName, ReferencePropertyEditor editor, Entity entity, ReferencePropertyEditor.UrlParameterActionType actionType) {
        String urlParam;
        if (definitionName == null || editor == null || editor.getUrlParameterScriptKey() == null || actionType == null) {
            return "";
        }
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return "";
        }
        List<ReferencePropertyEditor.UrlParameterActionType> actions = editor.getUrlParameterAction();
        if (actions == null ? actionType != ReferencePropertyEditor.UrlParameterActionType.SELECT && actionType != ReferencePropertyEditor.UrlParameterActionType.ADD : !actions.contains((Object)actionType)) {
            return "";
        }
        GroovyTemplate template = entityView.getTemplate(editor.getUrlParameterScriptKey());
        StringWriter sw = new StringWriter();
        if (template != null) {
            try {
                template.doTemplate((GroovyTemplateBinding)new UrlParameterGroovyTemplateBinding(sw, entity, actionType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (StringUtil.isNotEmpty((String)(urlParam = sw.toString()))) {
            urlParam = StringUtil.removeLineFeedCode((String)StringUtil.stripToEmpty((String)urlParam)).replaceAll("\t", "");
        }
        return urlParam;
    }

    @Override
    public Object getAutocompletionValue(String definitionName, String viewName, String viewType, String propName, String autocompletionKey, Integer referenceSectionIndex, Map<String, String[]> param, List<String> currentValue, Entity entity) {
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return null;
        }
        MetaAutocompletionSetting.AutocompletionSettingRuntime autocompletionSetting = entityView.getAutocompletionSetting(autocompletionKey);
        if (autocompletionSetting == null) {
            return null;
        }
        PropertyEditor editor = null;
        editor = referenceSectionIndex != null ? this.getPropertyEditor(definitionName, viewName, propName, referenceSectionIndex) : this.getPropertyEditor(definitionName, viewType, viewName, propName, entity);
        PropertyDefinition pd = EntityViewUtil.getPropertyDefinition(propName, this.edm.get(definitionName));
        List<String> currValue = pd.getMultiplicity() == 1 ? (currentValue.size() > 0 ? currentValue.get(0) : "") : currentValue;
        boolean isReference = editor instanceof ReferencePropertyEditor;
        ArrayList<Object> value = autocompletionSetting.handle(param, currValue, isReference);
        ArrayList<Object> returnValue = null;
        if (isReference) {
            if (value instanceof List) {
                List list = value;
                for (Object obj : list) {
                    if (obj instanceof Entity) continue;
                    logger.error("For return type, please set Entity class as return value. The result type of this execution is of type " + obj.getClass().getName() + ".");
                    throw new AutocompletionHandleException();
                }
            } else if (!(value instanceof Entity)) {
                logger.error("For return type, please set Entity class as return value. The result type of this execution is of type " + value.getClass().getName() + ".");
                throw new AutocompletionHandleException();
            }
            returnValue = value;
        } else if (value instanceof Entity) {
            returnValue = ((Entity)value).getValue(propName);
        } else if (value instanceof List) {
            List list = value;
            ArrayList<Object> retList = new ArrayList<Object>();
            for (Object obj : list) {
                retList.add(this.convertAutocompletionValue(obj));
            }
            returnValue = retList;
        } else {
            returnValue = this.convertAutocompletionValue(value);
        }
        return returnValue;
    }

    private PropertyEditor getPropertyEditor(String definitionName, String viewName, String propName, Integer referenceSectionIndex) {
        EntityView ev = (EntityView)this.get(definitionName);
        if (ev == null) {
            return null;
        }
        DetailFormView form = null;
        form = viewName == null || viewName.isEmpty() ? ev.getDefaultDetailFormView() : ev.getDetailFormView(viewName);
        String currentPropName = null;
        String subPropName = null;
        if (propName.indexOf(".") == -1) {
            currentPropName = propName;
        } else {
            currentPropName = propName.substring(0, propName.indexOf("."));
            subPropName = propName.substring(propName.indexOf(".") + 1);
        }
        String _currentPropName = currentPropName;
        List secList = form.getSections().stream().filter(s -> s instanceof ReferenceSection).map(s -> (ReferenceSection)s).filter(s -> _currentPropName.equals(s.getPropertyName())).collect(Collectors.toList());
        ReferenceSection refSection = null;
        if (!secList.isEmpty()) {
            PropertyDefinition pd = this.edm.get(definitionName).getProperty(currentPropName);
            if (pd.getMultiplicity() == 1) {
                refSection = (ReferenceSection)secList.get(0);
            } else if (secList.size() > referenceSectionIndex) {
                refSection = (ReferenceSection)secList.get(referenceSectionIndex);
            }
        }
        PropertyEditor editor = null;
        if (refSection != null) {
            for (NestProperty nest : refSection.getProperties()) {
                if (!subPropName.equals(nest.getPropertyName())) continue;
                editor = nest.getEditor();
                break;
            }
        }
        return editor;
    }

    private Object convertAutocompletionValue(Object value) {
        if (value instanceof BinaryReference) {
            return ((BinaryReference)value).getName();
        }
        if (value instanceof Date) {
            return DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getServerDateFormat(), (boolean)false).format((Date)value);
        }
        if (value instanceof Timestamp) {
            return DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getServerDateTimeFormat(), (boolean)false).format((Timestamp)value);
        }
        if (value instanceof Time) {
            return DateUtil.getSimpleDateFormat((String)TemplateUtil.getLocaleFormat().getServerTimeFormat(), (boolean)false).format((Time)value);
        }
        if (value instanceof SelectValue) {
            return ((SelectValue)value).getValue();
        }
        return value;
    }

    public Class<EntityView> getDefinitionType() {
        return EntityView.class;
    }

    protected RootMetaData newInstance(EntityView definition) {
        return new MetaEntityView();
    }

    protected TypedMetaDataService getService() {
        return this.service;
    }

    @Override
    public List<String> getPermitRoles(String definitionName, String viewName) {
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return null;
        }
        List<MetaViewControlSetting> settings = entityView.getMetaData().getViewControlSettings();
        if (settings != null && !settings.isEmpty()) {
            MetaViewControlSetting setting = this.getViewControl(settings, viewName);
            if (setting != null) {
                if (StringUtil.isNotEmpty((String)setting.getPermitRoles())) {
                    String[] permitRoles = setting.getPermitRoles().split(",");
                    return Arrays.asList(permitRoles);
                }
                return Collections.EMPTY_LIST;
            }
            logger.debug("not defined view's viewControl. defName=" + definitionName + ",viewName=" + viewName);
        } else {
            logger.debug("not defined any viewControl. defName=" + definitionName);
        }
        SearchFormViewRuntime searchView = this.getSearchFormView(entityView.getFormViews(), viewName);
        if (searchView != null) {
            return Collections.EMPTY_LIST;
        }
        if (StringUtil.isEmpty((String)viewName)) {
            return null;
        }
        throw new ApplicationException("invalid viewName. defName=" + definitionName + ",viewName=" + viewName);
    }

    private MetaViewControlSetting getViewControl(List<MetaViewControlSetting> settings, String viewName) {
        boolean checkDefault = StringUtil.isEmpty((String)viewName);
        Optional<MetaViewControlSetting> ret = settings.stream().filter(setting -> {
            String name = setting.getName();
            if (checkDefault) {
                return StringUtil.isEmpty((String)name);
            }
            return viewName.equals(name);
        }).findFirst();
        if (ret.isPresent()) {
            return ret.get();
        }
        return null;
    }

    private SearchFormViewRuntime getSearchFormView(List<FormViewRuntime> formViews, String viewName) {
        boolean checkDefault = StringUtil.isEmpty((String)viewName);
        Optional<SearchFormViewRuntime> searchView = formViews.stream().filter(view -> view instanceof SearchFormViewRuntime).filter(view -> {
            String name = view.getMetaData().getName();
            if (checkDefault) {
                return StringUtil.isEmpty((String)name);
            }
            return viewName.equals(name);
        }).map(view -> (SearchFormViewRuntime)view).findFirst();
        if (searchView.isPresent()) {
            return searchView.get();
        }
        return null;
    }

    @Override
    public void checkState(String definitionName) {
        EntityViewRuntime entityView = (EntityViewRuntime)this.service.getRuntimeByName(definitionName);
        if (entityView == null) {
            return;
        }
        entityView.checkState();
    }

    private static String resourceString(String key, Object ... arguments) {
        return GemResourceBundleUtil.resourceString(key, arguments);
    }

    private class UrlParameterGroovyTemplateBinding
    extends GroovyTemplateBinding {
        public UrlParameterGroovyTemplateBinding(Writer writer, Entity entity, ReferencePropertyEditor.UrlParameterActionType actionType) {
            super(writer);
            RequestContext request = WebUtil.getRequestContext();
            this.setVariable(EntityViewManagerImpl.REQUEST_BINDING_NAME, request);
            this.setVariable(EntityViewManagerImpl.SESSION_BINDING_NAME, request.getSession());
            this.setVariable("parent", entity);
            this.setVariable("actionType", (Object)actionType);
        }
    }
}

