/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.MetaEntityView;
import org.iplass.mtp.impl.view.generic.MetaFormView;
import org.iplass.mtp.impl.view.generic.common.MetaAutocompletionSetting;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaButton;

public class EntityViewRuntime
extends BaseMetaDataRuntime {
    protected MetaEntityView metaData;
    private List<FormViewRuntime> formViews;
    private Map<String, GroovyTemplate> templates;
    private Map<String, Map<String, GroovyTemplate>> customStylesMap;
    private Map<String, ElementRuntime> elementMap;
    private Map<String, MetaButton.ButtonRuntime> buttonMap;
    private Map<String, MetaAutocompletionSetting.AutocompletionSettingRuntime> autocompletionSettingMap;
    private Map<String, PreparedQuery> queries;

    public EntityViewRuntime(MetaEntityView metaData) {
        try {
            this.metaData = metaData;
            if (metaData.getViews().size() > 0) {
                for (MetaFormView view : metaData.getViews()) {
                    this.addFormView(view.createRuntime(this));
                }
            }
        }
        catch (RuntimeException e) {
            this.setIllegalStateException(e);
        }
    }

    private void addFormView(FormViewRuntime formView) {
        if (this.formViews == null) {
            this.formViews = new ArrayList<FormViewRuntime>();
        }
        this.formViews.add(formView);
    }

    public List<FormViewRuntime> getFormViews() {
        if (this.formViews == null) {
            this.formViews = new ArrayList<FormViewRuntime>();
        }
        return this.formViews;
    }

    public void addTemplate(String key, GroovyTemplate template) {
        this.checkState();
        if (this.templates == null) {
            this.templates = new HashMap<String, GroovyTemplate>();
        }
        this.templates.put(key, template);
    }

    public GroovyTemplate getTemplate(String key) {
        this.checkState();
        if (this.templates == null) {
            return null;
        }
        return this.templates.get(key);
    }

    public void addQuery(String key, PreparedQuery query) {
        this.checkState();
        if (this.queries == null) {
            this.queries = new HashMap<String, PreparedQuery>();
        }
        this.queries.put(key, query);
    }

    public PreparedQuery getQuery(String key) {
        this.checkState();
        if (this.queries == null) {
            return null;
        }
        return this.queries.get(key);
    }

    public MetaEntityView getMetaData() {
        return this.metaData;
    }

    public void addCustomStyle(String key, Map<String, GroovyTemplate> customStyleMap) {
        if (this.customStylesMap == null) {
            this.customStylesMap = new HashMap<String, Map<String, GroovyTemplate>>();
        }
        this.customStylesMap.put(key, customStyleMap);
    }

    public Map<String, GroovyTemplate> getCustomStyleScriptMap(String key) {
        if (this.customStylesMap == null) {
            return null;
        }
        return this.customStylesMap.get(key);
    }

    public void addElement(ElementRuntime element) {
        if (this.elementMap == null) {
            this.elementMap = new HashMap<String, ElementRuntime>();
        }
        if (element.getMetaData().getElementRuntimeId() != null) {
            this.elementMap.put(element.getMetaData().getElementRuntimeId(), element);
        }
    }

    public ElementRuntime getElement(String elementRuntimeId) {
        if (this.elementMap == null) {
            return null;
        }
        return this.elementMap.get(elementRuntimeId);
    }

    public void addButton(MetaButton.ButtonRuntime button) {
        if (this.buttonMap == null) {
            this.buttonMap = new HashMap<String, MetaButton.ButtonRuntime>();
        }
        if (button.getMetaData().getCustomDisplayTypeScriptKey() != null) {
            this.buttonMap.put(button.getMetaData().getCustomDisplayTypeScriptKey(), button);
        }
    }

    public MetaButton.ButtonRuntime getButton(String key) {
        if (this.buttonMap == null) {
            return null;
        }
        return this.buttonMap.get(key);
    }

    public void addAutocompletionSetting(MetaAutocompletionSetting.AutocompletionSettingRuntime setting) {
        if (this.autocompletionSettingMap == null) {
            this.autocompletionSettingMap = new HashMap<String, MetaAutocompletionSetting.AutocompletionSettingRuntime>();
        }
        if (setting.getMetaData().getRuntimeKey() != null) {
            this.autocompletionSettingMap.put(setting.getMetaData().getRuntimeKey(), setting);
        }
    }

    public MetaAutocompletionSetting.AutocompletionSettingRuntime getAutocompletionSetting(String key) {
        if (this.autocompletionSettingMap == null) {
            return null;
        }
        return this.autocompletionSettingMap.get(key);
    }
}

