/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

public interface HasEntityProperty {
    default public String convertName(String propId, EntityContext context, EntityHandler eh) {
        if (propId != null && propId.contains(".")) {
            int indexOfDot = propId.indexOf(".");
            String objPropId = propId.substring(0, indexOfDot);
            String subPropPath = propId.substring(indexOfDot + 1, propId.length());
            PropertyHandler property = eh.getPropertyById(objPropId, context);
            if (!(property instanceof ReferencePropertyHandler)) {
                return null;
            }
            ReferencePropertyHandler refProp = (ReferencePropertyHandler)property;
            EntityHandler refEntity = refProp.getReferenceEntityHandler(context);
            if (refEntity == null) {
                return null;
            }
            String refProperty = this.convertName(subPropPath, context, refEntity);
            if (refProperty == null) {
                return null;
            }
            return property.getName() + "." + refProperty;
        }
        PropertyHandler property = eh.getPropertyById(propId, context);
        if (property == null) {
            return null;
        }
        return property.getName();
    }

    default public PropertyDefinition getProperty(String propId, EntityContext context, EntityHandler eh) {
        if (propId != null && propId.contains(".")) {
            int indexOfDot = propId.indexOf(".");
            String objPropId = propId.substring(0, indexOfDot);
            String subPropPath = propId.substring(indexOfDot + 1, propId.length());
            PropertyHandler property = eh.getPropertyById(objPropId, context);
            if (!(property instanceof ReferencePropertyHandler)) {
                return null;
            }
            ReferencePropertyHandler refProp = (ReferencePropertyHandler)property;
            EntityHandler refEntity = refProp.getReferenceEntityHandler(context);
            if (refEntity == null) {
                return null;
            }
            PropertyDefinition refProperty = this.getProperty(subPropPath, context, refEntity);
            if (refProperty == null) {
                return null;
            }
            return refProperty;
        }
        PropertyHandler property = eh.getPropertyById(propId, context);
        if (property == null) {
            return null;
        }
        return property.getMetaData().currentConfig(context);
    }

    default public String convertId(String propName, EntityContext context, EntityHandler entity) {
        if (propName == null || propName.isEmpty()) {
            return null;
        }
        if (propName.contains(".")) {
            int indexOfDot = propName.indexOf(46);
            String objPropName = propName.substring(0, indexOfDot);
            String subPropPath = propName.substring(indexOfDot + 1, propName.length());
            PropertyHandler property = entity.getProperty(objPropName, context);
            if (!(property instanceof ReferencePropertyHandler)) {
                throw new IllegalArgumentException("path is invalid:" + objPropName + " is not ObjectReferenceProperty of " + entity.getMetaData().getName());
            }
            ReferencePropertyHandler refProp = (ReferencePropertyHandler)property;
            EntityHandler refEntity = refProp.getReferenceEntityHandler(context);
            if (refEntity == null) {
                throw new IllegalArgumentException(objPropName + "'s Entity is not defined.");
            }
            String refProperty = this.convertId(subPropPath, context, refEntity);
            if (refProperty == null) {
                throw new IllegalArgumentException(subPropPath + "'s Property is not defined.");
            }
            return property.getId() + "." + refProperty;
        }
        PropertyHandler property = entity.getProperty(propName, context);
        if (property == null) {
            throw new IllegalArgumentException(propName + "'s Property is not defined.");
        }
        return property.getId();
    }
}

